/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CGRecipeProvider {
    private static ItemStack vanillaBlock;
    private static final List<ItemStack> vanillaBlocks;
    private static final EnumMap<EnumDyeColor, ItemStack> vanillaColoredBlocks;
    private static ItemStack vanillaPane;
    private static final List<ItemStack> vanillaPanes;
    private static final EnumMap<EnumDyeColor, ItemStack> vanillaColoredPanes;

    public static void registerRecipes(RegistryEvent.Register<IRecipe> e) {
        ItemStack result;
        CGGlassBlock previous;
        CGRecipeProvider.gatherVanillaBlocks();
        CGRecipeProvider.gatherVanillaPanes();
        CGGlassType lastType = null;
        for (CGGlassType type : CGGlassType.values()) {
            ShapedRecipes recipe;
            EnumDyeColor color;
            for (CGGlassBlock cGGlassBlock : type.blocks) {
                color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).color : null;
                ItemStack previous2 = lastType == null ? CGRecipeProvider.getVanillaBlock(color) : new ItemStack((Block)lastType.getBlock(color));
                ShapedRecipes recipe3 = CGRecipeProvider.createShaped(new ResourceLocation(cGGlassBlock.getRegistryName().func_110624_b(), cGGlassBlock.getRegistryName().func_110623_a() + "1"), new ItemStack((Block)cGGlassBlock, 4), "GG", "GG", Character.valueOf('G'), previous2);
                e.getRegistry().register((IForgeRegistryEntry)recipe3);
            }
            for (CGColoredGlassBlock cGColoredGlassBlock : type.colored_blocks.values()) {
                ShapedRecipes recipe2 = CGRecipeProvider.createShaped(new ResourceLocation(cGColoredGlassBlock.getRegistryName().func_110624_b(), cGColoredGlassBlock.getRegistryName().func_110623_a() + "2"), new ItemStack((Block)cGColoredGlassBlock, 8), "GGG", "GDG", "GGG", Character.valueOf('G'), new ItemStack((Block)type.block), Character.valueOf('D'), CGRecipeProvider.getColorIngredient(cGColoredGlassBlock.color));
                e.getRegistry().register((IForgeRegistryEntry)recipe2);
            }
            for (CGPaneBlock cGPaneBlock : type.panes) {
                color = cGPaneBlock instanceof CGColoredPaneBlock ? ((CGColoredGlassBlock)cGPaneBlock.block).color : null;
                ItemStack previous2 = lastType == null ? CGRecipeProvider.getVanillaPane(color) : new ItemStack((Block)lastType.getPane(color));
                recipe = CGRecipeProvider.createShaped(new ResourceLocation(cGPaneBlock.getRegistryName().func_110624_b(), cGPaneBlock.getRegistryName().func_110623_a() + "1"), new ItemStack((Block)cGPaneBlock, 4), "GG", "GG", Character.valueOf('G'), previous2);
                e.getRegistry().register((IForgeRegistryEntry)recipe);
            }
            for (CGColoredPaneBlock cGColoredPaneBlock : type.colored_panes.values()) {
                ShapedRecipes recipe2 = CGRecipeProvider.createShaped(new ResourceLocation(cGColoredPaneBlock.getRegistryName().func_110624_b(), cGColoredPaneBlock.getRegistryName().func_110623_a() + "2"), new ItemStack((Block)cGColoredPaneBlock, 8), "GGG", "GDG", "GGG", Character.valueOf('G'), new ItemStack((Block)type.pane), Character.valueOf('D'), CGRecipeProvider.getColorIngredient(((CGColoredGlassBlock)cGColoredPaneBlock.block).color));
                e.getRegistry().register((IForgeRegistryEntry)recipe2);
            }
            for (CGGlassBlock cGGlassBlock : type.blocks) {
                color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).color : null;
                CGPaneBlock pane = type.getPane(color);
                recipe = CGRecipeProvider.createShaped(new ResourceLocation(pane.getRegistryName().func_110624_b(), pane.getRegistryName().func_110623_a() + "3"), new ItemStack((Block)pane, 16), "GGG", "GGG", Character.valueOf('G'), new ItemStack((Block)cGGlassBlock));
                e.getRegistry().register((IForgeRegistryEntry)recipe);
            }
            lastType = type;
        }
        for (ItemStack stack : vanillaBlocks) {
            EnumDyeColor color = ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockStainedGlass ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()) : null;
            previous = lastType.getBlock(color);
            result = stack.func_77946_l();
            result.func_190920_e(4);
            ShapedRecipes shapedRecipes = CGRecipeProvider.createShaped(new ResourceLocation("connectedglass", "vanilla_" + stack.func_77973_b().getRegistryName().func_110623_a()), result, "GG", "GG", Character.valueOf('G'), new ItemStack((Block)previous));
            e.getRegistry().register((IForgeRegistryEntry)shapedRecipes);
        }
        for (ItemStack stack : vanillaPanes) {
            EnumDyeColor color = ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockStainedGlassPane ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()) : null;
            previous = new ItemStack((Block)lastType.getPane(color));
            result = stack.func_77946_l();
            result.func_190920_e(4);
            ShapedRecipes shapedRecipes = CGRecipeProvider.createShaped(new ResourceLocation("connectedglass", "vanilla_" + stack.func_77973_b().getRegistryName().func_110623_a()), result, new Object[]{"GG", "GG", Character.valueOf('G'), previous});
            e.getRegistry().register((IForgeRegistryEntry)shapedRecipes);
        }
    }

    private static ShapedRecipes createShaped(ResourceLocation registryName, ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes("", primer.width, primer.height, primer.input, output);
        recipe.setRegistryName(registryName);
        return recipe;
    }

    private static void gatherVanillaBlocks() {
        CGRecipeProvider.addVanillaBlock(new ItemStack(Blocks.field_150359_w));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            CGRecipeProvider.addVanillaBlock(new ItemStack((Block)Blocks.field_150399_cn, 1, color.func_176765_a()));
        }
    }

    private static void addVanillaBlock(ItemStack stack) {
        EnumDyeColor color;
        vanillaBlocks.add(stack);
        EnumDyeColor enumDyeColor = color = ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockStainedGlass ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()) : null;
        if (color == null) {
            vanillaBlock = stack;
        } else {
            vanillaColoredBlocks.put(color, stack);
        }
    }

    private static void gatherVanillaPanes() {
        CGRecipeProvider.addVanillaPane(new ItemStack(Blocks.field_150410_aZ));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            CGRecipeProvider.addVanillaPane(new ItemStack((Block)Blocks.field_150397_co, 1, color.func_176765_a()));
        }
    }

    private static void addVanillaPane(ItemStack stack) {
        EnumDyeColor color;
        vanillaPanes.add(stack);
        EnumDyeColor enumDyeColor = color = ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockStainedGlassPane ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()) : null;
        if (color == null) {
            vanillaPane = stack;
        } else {
            vanillaColoredPanes.put(color, stack);
        }
    }

    private static ItemStack getVanillaBlock(EnumDyeColor color) {
        if (color == null) {
            return vanillaBlock;
        }
        return vanillaColoredBlocks.get(color);
    }

    private static ItemStack getVanillaPane(EnumDyeColor color) {
        if (color == null) {
            return vanillaPane;
        }
        return vanillaColoredPanes.get(color);
    }

    private static OreIngredient getColorIngredient(EnumDyeColor color) {
        if (color == EnumDyeColor.SILVER) {
            return new OreIngredient("dyeLightGray");
        }
        String ore = color.func_176762_d();
        ore = "dye" + ore.substring(0, 1).toUpperCase(Locale.ROOT) + ore.substring(1);
        return new OreIngredient(ore);
    }

    static {
        vanillaBlocks = new ArrayList<ItemStack>();
        vanillaColoredBlocks = new EnumMap(EnumDyeColor.class);
        vanillaPanes = new ArrayList<ItemStack>();
        vanillaColoredPanes = new EnumMap(EnumDyeColor.class);
    }
}

