/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.ConnectedGlass;
import com.supermartijn642.connectedglass.model.CGBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedPaneBakedModel;
import com.supermartijn642.connectedglass.model.CGPaneBakedModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="connectedglass")
public class ClientProxy {
    public static final Map<CGGlassBlock, TextureAtlasSprite> TEXTURES = new HashMap<CGGlassBlock, TextureAtlasSprite>();

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (final CGGlassBlock block : ConnectedGlass.BLOCKS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation(block.getRegistryName(), "normal");
                }
            });
        }
        for (final CGPaneBlock pane : ConnectedGlass.PANES) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)pane), (int)0, (ModelResourceLocation)new ModelResourceLocation(pane.getRegistryName(), "inventory"));
            ModelLoader.setCustomStateMapper((Block)pane, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation(pane.getRegistryName(), "normal");
                }
            });
        }
    }

    @SubscribeEvent
    public static void onBake(ModelBakeEvent e) {
        Object model;
        for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
            model = block.connected ? new CGConnectedBakedModel(block) : new CGBakedModel(block);
            e.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(block.getRegistryName(), "normal"), model);
            e.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(block.getRegistryName(), "inventory"), model);
        }
        for (CGPaneBlock pane : ConnectedGlass.PANES) {
            model = pane.block.connected ? new CGConnectedPaneBakedModel(pane) : new CGPaneBakedModel(pane);
            e.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(pane.getRegistryName(), "normal"), model);
            e.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(pane.getRegistryName(), "inventory"), model);
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre e) {
        if (e.getMap().getBasePath().equals("textures")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                TEXTURES.put(block, e.getMap().func_174942_a(block.getRegistryName()));
            }
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post e) {
        if (e.getMap().getBasePath().equals("textures")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                TEXTURES.put(block, e.getMap().func_110572_b(block.getRegistryName().toString()));
            }
        }
    }
}

