/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.CGRecipeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="connectedglass", name="Connected Glass", version="1.0.8", dependencies="required-after:forge", acceptedMinecraftVersions="[1.12.2]")
public class ConnectedGlass {
    public static final String MODID = "connectedglass";
    public static final String NAME = "Connected Glass";
    public static final String VERSION = "1.0.8";
    public static final String DEPENDENCIES = "required-after:forge";
    public static final List<CGGlassBlock> BLOCKS = new ArrayList<CGGlassBlock>();
    public static final List<CGPaneBlock> PANES = new ArrayList<CGPaneBlock>();

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        for (CGGlassType type : CGGlassType.values()) {
            type.blocks.forEach(block -> {
                OreDictionary.registerOre((String)"blockGlass", (Block)block);
                OreDictionary.registerOre((String)"blockGlass", (Item)Item.func_150898_a((Block)block));
            });
            OreDictionary.registerOre((String)"blockGlassColorless", (Block)type.block);
            OreDictionary.registerOre((String)"blockGlassColorless", (Item)Item.func_150898_a((Block)type.block));
            type.colored_blocks.forEach((color, block) -> {
                String name = color == EnumDyeColor.SILVER ? "LightGray" : color.func_176762_d().toUpperCase().charAt(0) + color.func_176762_d().substring(1);
                OreDictionary.registerOre((String)("blockGlass" + name), (Block)block);
                OreDictionary.registerOre((String)("blockGlass" + name), (Item)Item.func_150898_a((Block)block));
                OreDictionary.registerOre((String)"blockGlassColored", (Block)block);
                OreDictionary.registerOre((String)"blockGlassColored", (Item)Item.func_150898_a((Block)block));
            });
            type.panes.forEach(pane -> {
                OreDictionary.registerOre((String)"blockPane", (Block)pane);
                OreDictionary.registerOre((String)"blockPane", (Item)Item.func_150898_a((Block)pane));
            });
            OreDictionary.registerOre((String)"blockPaneColorless", (Block)type.pane);
            OreDictionary.registerOre((String)"blockPaneColorless", (Item)Item.func_150898_a((Block)type.pane));
            type.colored_panes.forEach((color, pane) -> {
                String name = color == EnumDyeColor.SILVER ? "LightGray" : color.func_176762_d().toUpperCase().charAt(0) + color.func_176762_d().substring(1);
                OreDictionary.registerOre((String)("blockPane" + name), (Block)pane);
                OreDictionary.registerOre((String)("blockPane" + name), (Item)Item.func_150898_a((Block)pane));
                OreDictionary.registerOre((String)"blockPaneColored", (Block)pane);
                OreDictionary.registerOre((String)"blockPaneColored", (Item)Item.func_150898_a((Block)pane));
            });
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            for (CGGlassType type : CGGlassType.values()) {
                type.init();
                BLOCKS.addAll(type.blocks);
                PANES.addAll(type.panes);
            }
            for (Block block : BLOCKS) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
            for (Block block : PANES) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            for (Block block : BLOCKS) {
                RegistryEvents.registerItemBlock(e, block);
            }
            for (Block block : PANES) {
                RegistryEvents.registerItemBlock(e, block);
            }
        }

        private static void registerItemBlock(RegistryEvent.Register<Item> e, Block block) {
            e.getRegistry().register(new ItemBlock(block).func_77637_a(CreativeTabs.field_78027_g).setRegistryName(Objects.requireNonNull(block.getRegistryName())));
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<IRecipe> e) {
            CGRecipeProvider.registerRecipes(e);
        }
    }
}

