/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.ClientProxy;
import com.supermartijn642.connectedglass.model.CGPaneModelData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Vector3f;

public class CGPaneBakedModel
implements IBakedModel {
    private static final FaceBakery BAKERY = new FaceBakery();
    private final CGPaneBlock pane;

    public CGPaneBakedModel(CGPaneBlock pane) {
        this.pane = pane;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(Blocks.field_150348_b.func_176223_P()).func_177552_f();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        EnumFacing[] enumFacingArray;
        CGPaneModelData data;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        CGPaneModelData cGPaneModelData = data = state instanceof IExtendedBlockState ? (CGPaneModelData)((IExtendedBlockState)state).getValue(CGPaneBlock.MODEL_DATA) : null;
        if (side == null) {
            enumFacingArray = EnumFacing.values();
        } else {
            EnumFacing[] enumFacingArray2 = new EnumFacing[1];
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[0] = side;
        }
        EnumFacing[] sides = enumFacingArray;
        boolean culling = side != null;
        for (EnumFacing side2 : sides) {
            quads.addAll(this.getPostQuad(side2, culling, this.isEnabledUp(null, data), this.isEnabledDown(null, data)));
            float[] uv = this.getUV(side2, data);
            for (EnumFacing part : EnumFacing.Plane.HORIZONTAL) {
                quads.addAll(this.getPartQuad(state, part, side2, uv, culling, this.isEnabledUp(part, data), this.isEnabledDown(part, data)));
            }
        }
        return quads;
    }

    protected TextureAtlasSprite getTexture() {
        return ClientProxy.TEXTURES.get((Object)this.pane.block);
    }

    protected float[] getUV(EnumFacing side, CGPaneModelData modelData) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return this.getBorderUV();
        }
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected List<BakedQuad> getPostQuad(EnumFacing side, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        boolean hasCulling;
        if (side.func_176740_k() != EnumFacing.Axis.Y) {
            return Collections.emptyList();
        }
        boolean bl = hasCulling = side == EnumFacing.UP ? isEnabledUp : isEnabledDown;
        if (hasCulling != culling) {
            return Collections.emptyList();
        }
        Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
        Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
        float[] uv = new float[]{0.875f, 14.875f, 1.125f, 15.125f};
        BlockPartFace face = new BlockPartFace((EnumFacing)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, 0));
        BakedQuad quad = BAKERY.func_178414_a(from, to, face, this.getTexture(), side, ModelRotation.X0_Y0, null, false, true);
        return Collections.singletonList(quad);
    }

    protected List<BakedQuad> getPartQuad(IBlockState state, EnumFacing part, EnumFacing side, float[] totalUV, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        PropertyBool property;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float unitW = (totalUV[2] - totalUV[0]) / 16.0f;
        float unitH = (totalUV[3] - totalUV[1]) / 16.0f;
        Object object = part == EnumFacing.NORTH ? BlockPane.field_176241_b : (part == EnumFacing.EAST ? BlockPane.field_176242_M : (part == EnumFacing.SOUTH ? BlockPane.field_176243_N : (property = part == EnumFacing.WEST ? BlockPane.field_176244_O : null)));
        if (state == null && (part == EnumFacing.NORTH || part == EnumFacing.SOUTH) || state != null && ((Boolean)state.func_177229_b((IProperty)property)).booleanValue()) {
            boolean hasQuad = true;
            float[] uv = new float[]{};
            boolean hasCulling = false;
            int rotation = 0;
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                hasCulling = side == EnumFacing.UP ? isEnabledUp : isEnabledDown;
                uv = part == EnumFacing.NORTH || part == EnumFacing.EAST ? new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitW, totalUV[1] + 7.0f * unitH} : new float[]{totalUV[0] + 7.0f * unitW, totalUV[1] + 9.0f * unitH, totalUV[0] + 9.0f * unitW, totalUV[3]};
                if (part.func_176740_k() == EnumFacing.Axis.X) {
                    rotation = 90;
                }
            } else if (side.func_176734_d() == part) {
                hasQuad = false;
            } else if (side == part) {
                uv = this.getBorderUV();
                uv[0] = uv[0] + 7.0f * unitW;
                uv[2] = uv[2] - 7.0f * unitW;
                hasCulling = true;
            } else if (side.func_176735_f() == part) {
                uv = new float[]{totalUV[0] + 9.0f * unitW, totalUV[1], totalUV[2], totalUV[3]};
            } else if (side.func_176746_e() == part) {
                uv = new float[]{totalUV[0], totalUV[1], totalUV[0] + 7.0f * unitW, totalUV[3]};
            }
            if (hasQuad && hasCulling == culling) {
                Vector3f from = this.getPartFromPos(part);
                Vector3f to = this.getPartToPos(part);
                BlockPartFace face = new BlockPartFace((EnumFacing)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, rotation));
                quads.add(BAKERY.func_178414_a(from, to, face, this.getTexture(), side, ModelRotation.X0_Y0, null, false, true));
            }
        } else if (side == part && !culling) {
            Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
            Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
            float[] uv = new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitH, totalUV[3]};
            BlockPartFace face = new BlockPartFace(null, -1, "", new BlockFaceUV(uv, 0));
            quads.add(BAKERY.func_178414_a(from, to, face, this.getTexture(), side, ModelRotation.X0_Y0, null, false, true));
        }
        return quads;
    }

    private Vector3f getPartFromPos(EnumFacing part) {
        if (part == EnumFacing.NORTH) {
            return new Vector3f(7.0f, 0.0f, 0.0f);
        }
        if (part == EnumFacing.EAST) {
            return new Vector3f(9.0f, 0.0f, 7.0f);
        }
        if (part == EnumFacing.SOUTH) {
            return new Vector3f(7.0f, 0.0f, 9.0f);
        }
        if (part == EnumFacing.WEST) {
            return new Vector3f(0.0f, 0.0f, 7.0f);
        }
        return null;
    }

    private Vector3f getPartToPos(EnumFacing part) {
        if (part == EnumFacing.NORTH) {
            return new Vector3f(9.0f, 16.0f, 7.0f);
        }
        if (part == EnumFacing.EAST) {
            return new Vector3f(16.0f, 16.0f, 9.0f);
        }
        if (part == EnumFacing.SOUTH) {
            return new Vector3f(9.0f, 16.0f, 16.0f);
        }
        if (part == EnumFacing.WEST) {
            return new Vector3f(7.0f, 16.0f, 9.0f);
        }
        return null;
    }

    protected float[] getBorderUV() {
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected boolean isEnabledUp(EnumFacing part, CGPaneModelData extraData) {
        return false;
    }

    protected boolean isEnabledDown(EnumFacing part, CGPaneModelData extraData) {
        return false;
    }
}

