/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.ClientProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class CGPaneBakedModel
implements IDynamicBakedModel {
    private static final FaceBakery BAKERY = new FaceBakery();
    private final CGPaneBlock pane;

    public CGPaneBakedModel(CGPaneBlock pane) {
        this.pane = pane;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(Blocks.field_150348_b.getRegistryName(), "")).func_177552_f();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Direction[] directionArray;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side == null) {
            directionArray = Direction.values();
        } else {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = side;
        }
        Direction[] sides = directionArray;
        boolean culling = side != null;
        for (Direction side2 : sides) {
            quads.addAll(this.getPostQuad(side2, culling, this.isEnabledUp(null, extraData), this.isEnabledDown(null, extraData)));
            float[] uv = this.getUV(side2, extraData);
            for (Direction part : Direction.Plane.HORIZONTAL) {
                quads.addAll(this.getPartQuad(state, part, side2, uv, culling, this.isEnabledUp(part, extraData), this.isEnabledDown(part, extraData)));
            }
        }
        return quads;
    }

    protected TextureAtlasSprite getTexture() {
        return ClientProxy.TEXTURES.get((Object)this.pane.block);
    }

    protected float[] getUV(Direction side, IModelData modelData) {
        if (side == Direction.UP || side == Direction.DOWN) {
            return this.getBorderUV();
        }
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected List<BakedQuad> getPostQuad(Direction side, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        boolean hasCulling;
        if (side.func_176740_k() != Direction.Axis.Y) {
            return Collections.emptyList();
        }
        boolean bl = hasCulling = side == Direction.UP ? isEnabledUp : isEnabledDown;
        if (hasCulling != culling) {
            return Collections.emptyList();
        }
        Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
        Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
        float[] uv = new float[]{0.875f, 14.875f, 1.125f, 15.125f};
        BlockPartFace face = new BlockPartFace((Direction)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, 0));
        BakedQuad quad = BAKERY.makeBakedQuad(from, to, face, this.getTexture(), side, (ISprite)ModelRotation.X0_Y0, null, true);
        return Collections.singletonList(quad);
    }

    protected List<BakedQuad> getPartQuad(BlockState state, Direction part, Direction side, float[] totalUV, boolean culling, boolean isEnabledUp, boolean isEnabledDown) {
        BooleanProperty property;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float unitW = (totalUV[2] - totalUV[0]) / 16.0f;
        float unitH = (totalUV[3] - totalUV[1]) / 16.0f;
        Object object = part == Direction.NORTH ? FourWayBlock.field_196409_a : (part == Direction.EAST ? FourWayBlock.field_196411_b : (part == Direction.SOUTH ? FourWayBlock.field_196413_c : (property = part == Direction.WEST ? FourWayBlock.field_196414_y : null)));
        if (state == null && (part == Direction.NORTH || part == Direction.SOUTH) || state != null && ((Boolean)state.func_177229_b((IProperty)property)).booleanValue()) {
            boolean hasQuad = true;
            float[] uv = new float[]{};
            boolean hasCulling = false;
            int rotation = 0;
            if (side == Direction.UP || side == Direction.DOWN) {
                hasCulling = side == Direction.UP ? isEnabledUp : isEnabledDown;
                uv = part == Direction.NORTH || part == Direction.EAST ? new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitW, totalUV[1] + 7.0f * unitH} : new float[]{totalUV[0] + 7.0f * unitW, totalUV[1] + 9.0f * unitH, totalUV[0] + 9.0f * unitW, totalUV[3]};
                if (part.func_176740_k() == Direction.Axis.X) {
                    rotation = 90;
                }
            } else if (side.func_176734_d() == part) {
                hasQuad = false;
            } else if (side == part) {
                uv = this.getBorderUV();
                uv[0] = uv[0] + 7.0f * unitW;
                uv[2] = uv[2] - 7.0f * unitW;
                hasCulling = true;
            } else if (side.func_176735_f() == part) {
                uv = new float[]{totalUV[0] + 9.0f * unitW, totalUV[1], totalUV[2], totalUV[3]};
            } else if (side.func_176746_e() == part) {
                uv = new float[]{totalUV[0], totalUV[1], totalUV[0] + 7.0f * unitW, totalUV[3]};
            }
            if (hasQuad && hasCulling == culling) {
                Vector3f from = this.getPartFromPos(part);
                Vector3f to = this.getPartToPos(part);
                BlockPartFace face = new BlockPartFace((Direction)(hasCulling ? side : null), -1, "", new BlockFaceUV(uv, rotation));
                quads.add(BAKERY.makeBakedQuad(from, to, face, this.getTexture(), side, (ISprite)ModelRotation.X0_Y0, null, true));
            }
        } else if (side == part && !culling) {
            Vector3f from = new Vector3f(7.0f, 0.0f, 7.0f);
            Vector3f to = new Vector3f(9.0f, 16.0f, 9.0f);
            float[] uv = new float[]{totalUV[0] + 7.0f * unitW, totalUV[1], totalUV[0] + 9.0f * unitH, totalUV[3]};
            BlockPartFace face = new BlockPartFace(null, -1, "", new BlockFaceUV(uv, 0));
            quads.add(BAKERY.makeBakedQuad(from, to, face, this.getTexture(), side, (ISprite)ModelRotation.X0_Y0, null, true));
        }
        return quads;
    }

    private Vector3f getPartFromPos(Direction part) {
        if (part == Direction.NORTH) {
            return new Vector3f(7.0f, 0.0f, 0.0f);
        }
        if (part == Direction.EAST) {
            return new Vector3f(9.0f, 0.0f, 7.0f);
        }
        if (part == Direction.SOUTH) {
            return new Vector3f(7.0f, 0.0f, 9.0f);
        }
        if (part == Direction.WEST) {
            return new Vector3f(0.0f, 0.0f, 7.0f);
        }
        return null;
    }

    private Vector3f getPartToPos(Direction part) {
        if (part == Direction.NORTH) {
            return new Vector3f(9.0f, 16.0f, 7.0f);
        }
        if (part == Direction.EAST) {
            return new Vector3f(16.0f, 16.0f, 9.0f);
        }
        if (part == Direction.SOUTH) {
            return new Vector3f(9.0f, 16.0f, 16.0f);
        }
        if (part == Direction.WEST) {
            return new Vector3f(7.0f, 16.0f, 9.0f);
        }
        return null;
    }

    protected float[] getBorderUV() {
        return new float[]{0.0f, 0.0f, 16.0f, 16.0f};
    }

    protected boolean isEnabledUp(Direction part, IModelData extraData) {
        return false;
    }

    protected boolean isEnabledDown(Direction part, IModelData extraData) {
        return false;
    }
}

