/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGDummyBlockStateProvider;
import com.supermartijn642.connectedglass.CGDummyItemModelProvider;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.data.CGLootTableProvider;
import com.supermartijn642.connectedglass.data.CGRecipeProvider;
import com.supermartijn642.connectedglass.data.CGTagProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="connectedglass")
public class ConnectedGlass {
    public static final List<CGGlassBlock> BLOCKS = new ArrayList<CGGlassBlock>();
    public static final List<CGPaneBlock> PANES = new ArrayList<CGPaneBlock>();

    @Mod.EventBusSubscriber(modid="connectedglass", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            for (CGGlassType type : CGGlassType.values()) {
                type.init();
                BLOCKS.addAll(type.blocks);
                PANES.addAll(type.panes);
            }
            for (Block block : BLOCKS) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
            for (Block block : PANES) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            for (Block block : BLOCKS) {
                RegistryEvents.registerItemBlock(e, block);
            }
            for (Block block : PANES) {
                RegistryEvents.registerItemBlock(e, block);
            }
        }

        private static void registerItemBlock(RegistryEvent.Register<Item> e, Block block) {
            e.getRegistry().register(new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName(Objects.requireNonNull(block.getRegistryName())));
        }

        @SubscribeEvent
        public static void registerDataProviders(GatherDataEvent e) {
            if (e.includeServer()) {
                e.getGenerator().func_200390_a((IDataProvider)new CGRecipeProvider(e.getGenerator()));
                CGTagProvider.init();
                e.getGenerator().func_200390_a((IDataProvider)new CGLootTableProvider(e.getGenerator()));
            }
            if (e.includeClient()) {
                e.getGenerator().func_200390_a((IDataProvider)new CGDummyBlockStateProvider(e.getGenerator(), e.getExistingFileHelper()));
                e.getGenerator().func_200390_a((IDataProvider)new CGDummyItemModelProvider(e.getGenerator(), e.getExistingFileHelper()));
            }
        }
    }
}

