/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGDummyBlockStateProvider;
import com.supermartijn642.connectedglass.CGDummyItemModelProvider;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.data.CGBlockTagProvider;
import com.supermartijn642.connectedglass.data.CGItemTagProvider;
import com.supermartijn642.connectedglass.data.CGLootTableProvider;
import com.supermartijn642.connectedglass.data.CGRecipeProvider;
import com.supermartijn642.connectedglass.data.CGTagProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="connectedglass")
public class ConnectedGlass {
    public static final List<CGGlassBlock> BLOCKS = new ArrayList<CGGlassBlock>();
    public static final List<CGPaneBlock> PANES = new ArrayList<CGPaneBlock>();
    public static final CreativeModeTab GROUP = new CreativeModeTab("connectedglass"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CGGlassType.BORDERLESS_GLASS.block);
        }
    };

    @Mod.EventBusSubscriber(modid="connectedglass", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            for (CGGlassType type : CGGlassType.values()) {
                type.init();
                BLOCKS.addAll(type.blocks);
                if (!type.hasPanes) continue;
                PANES.addAll(type.panes);
            }
            for (Block block : BLOCKS) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
            for (Block block : PANES) {
                e.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            for (Block block : BLOCKS) {
                RegistryEvents.registerItemBlock(e, block);
            }
            for (Block block : PANES) {
                RegistryEvents.registerItemBlock(e, block);
            }
        }

        private static void registerItemBlock(RegistryEvent.Register<Item> e, Block block) {
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(GROUP)).setRegistryName(Objects.requireNonNull(block.getRegistryName()))));
        }

        @SubscribeEvent
        public static void registerDataProviders(GatherDataEvent e) {
            if (e.includeServer()) {
                e.getGenerator().m_123914_((DataProvider)new CGRecipeProvider(e.getGenerator()));
                CGTagProvider.init();
                CGBlockTagProvider blockTagProvider = new CGBlockTagProvider(e.getGenerator(), e.getExistingFileHelper());
                e.getGenerator().m_123914_((DataProvider)blockTagProvider);
                e.getGenerator().m_123914_((DataProvider)new CGItemTagProvider(e.getGenerator(), blockTagProvider, e.getExistingFileHelper()));
                e.getGenerator().m_123914_((DataProvider)new CGLootTableProvider(e.getGenerator()));
            }
            if (e.includeClient()) {
                e.getGenerator().m_123914_((DataProvider)new CGDummyBlockStateProvider(e.getGenerator(), e.getExistingFileHelper()));
                e.getGenerator().m_123914_((DataProvider)new CGDummyItemModelProvider(e.getGenerator(), e.getExistingFileHelper()));
            }
        }
    }
}

