/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs;

import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.init.KeybindsInit;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCFolderPack;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cosmicnpcs")
public class CosmicNPCs {
    public static CosmicNPCs instance;
    public static final Logger LOGGER;
    public static final String MODID = "cosmicnpcs";
    public static String[] storedCommands;
    public static int commandCounter;
    public Map<PlayerEntity, NPCRecorder> recordThreads = Collections.synchronizedMap(new HashMap());

    public CosmicNPCs() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityTypesInit.ENTITY_TYPES.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CosmicNPCs.injectCustomResourcePack());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> EntityTypesInit.registerAttributes());
        ArgumentTypes.func_218136_a((String)"centity_summon", CEntitySummonArgument.class, (IArgumentSerializer)new ArgumentSerializer(CEntitySummonArgument::entitySummon));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EntityTypesInit.registerEntityRenderers();
        KeybindsInit.register(event);
        CosmicNPCs.loadCommandData();
    }

    public static void safeCommandData() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("counter", commandCounter);
        data.func_218657_a("commands", (INBT)new CompoundNBT());
        for (int i = 0; i < storedCommands.length; ++i) {
            if (storedCommands[i] == null) continue;
            data.func_74775_l("commands").func_74778_a("cmd_" + i, storedCommands[i]);
        }
        File file = new File("config/cosmicnpcs/commands.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((CompoundNBT)data, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
    }

    public static void loadCommandData() {
        CompoundNBT data = new CompoundNBT();
        try {
            data = CompressedStreamTools.func_244263_a((File)new File("config/cosmicnpcs/commands.dat"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
        commandCounter = data.func_74762_e("counter");
        for (int i = 0; i < 99; ++i) {
            CosmicNPCs.storedCommands[i] = data.func_74775_l("commands").func_74779_i("cmd_" + i);
        }
    }

    public List<NPCAction> getActionListForPlayer(PlayerEntity ep) {
        NPCRecorder aRecorder = this.recordThreads.get(ep);
        if (aRecorder == null) {
            return null;
        }
        return aRecorder.eventsList;
    }

    public void broadcastMsg(String msg) {
        List temp = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : temp) {
            StringTextComponent cmp = new StringTextComponent("[CosmicNPCs]: " + msg);
            player.func_145747_a((ITextComponent)cmp, Util.field_240973_b_);
        }
    }

    public static void injectCustomResourcePack() {
        String path = "config/cosmicnpcs/resources";
        new File(path + "/textures/main").mkdirs();
        new File(path + "/textures/layers").mkdirs();
        NPCFolderPack pack = new NPCFolderPack(new File(path));
        Minecraft.func_71410_x().func_195548_H().addPackFinder(new IPackFinder((IResourcePack)pack){
            final /* synthetic */ IResourcePack val$pack;
            {
                this.val$pack = iResourcePack;
            }

            public void func_230230_a_(Consumer<ResourcePackInfo> infoConsumer, ResourcePackInfo.IFactory infoFactory) {
                infoConsumer.accept(new ResourcePackInfo("npctextures", true, () -> this.val$pack, (ITextComponent)new StringTextComponent("NPC Resources"), (ITextComponent)new StringTextComponent("NPC Resources from the config folder"), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.BOTTOM, true, text -> text, true));
            }
        });
    }

    static {
        LOGGER = LogManager.getLogger();
        storedCommands = new String[99];
        commandCounter = 1;
    }
}

