/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CCommandSuggestionHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Style EMPTY_ERROR_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.RED);
    private static final Style EMPTY_PASS_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
    private static final List<Style> COMMAND_COLOR_STYLES = (List)Stream.of(TextFormatting.AQUA, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD).map(arg_0 -> ((Style)Style.field_240709_b_).func_240712_a_(arg_0)).collect(ImmutableList.toImmutableList());
    private final Minecraft mc;
    private final Screen screen;
    private final TextFieldWidget inputField;
    private final FontRenderer font;
    private final boolean commandsOnly;
    private final boolean hasCursor;
    private final int minAmountRendered;
    private final int maxAmountRendered;
    private final boolean isChat;
    private final int color;
    private final List<IReorderingProcessor> exceptionList = Lists.newArrayList();
    private int x;
    private int width;
    private ParseResults<ISuggestionProvider> parseResults;
    private CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> suggestionsFuture;
    private Suggestions suggestions;
    private boolean autoSuggest;
    private boolean isApplyingSuggestion;
    private int yPos;

    public CCommandSuggestionHelper(Minecraft mc, Screen screen, TextFieldWidget inputField, FontRenderer font, boolean commandsOnly, boolean hasCursor, int minAmountRendered, int maxAmountRendered, int yPos, int color) {
        this.mc = mc;
        this.screen = screen;
        this.inputField = inputField;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.hasCursor = hasCursor;
        this.minAmountRendered = minAmountRendered;
        this.maxAmountRendered = maxAmountRendered;
        this.isChat = false;
        this.yPos = yPos;
        this.color = color;
        inputField.func_195607_a(this::getParsedSuggestion);
    }

    public void shouldAutoSuggest(boolean autoSuggest) {
        this.autoSuggest = autoSuggest;
        if (!autoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions != null && this.suggestions.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screen.func_241217_q_() == this.inputField && keyCode == 258) {
            this.updateSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean onScroll(double delta) {
        return this.suggestions != null && this.suggestions.onScroll(MathHelper.func_151237_a((double)delta, (double)-1.0, (double)1.0));
    }

    public boolean onClick(double mouseX, double mouseY, int mouseButton) {
        return this.suggestions != null && this.suggestions.onClick((int)mouseX, (int)mouseY, mouseButton);
    }

    public void updateSuggestions(boolean narrateFirstSuggestion) {
        com.mojang.brigadier.suggestion.Suggestions suggestions;
        if (this.suggestionsFuture != null && this.suggestionsFuture.isDone() && !(suggestions = this.suggestionsFuture.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.func_78256_a(suggestion.getText()));
            }
            int j = MathHelper.func_76125_a((int)this.inputField.func_195611_j(suggestions.getRange().getStart()), (int)0, (int)(this.inputField.func_195611_j(0) + this.inputField.func_146200_o() - i));
            int k = this.yPos;
            this.suggestions = new Suggestions(j, k, i, this.getSuggestions(suggestions), narrateFirstSuggestion);
        }
    }

    private List<Suggestion> getSuggestions(com.mojang.brigadier.suggestion.Suggestions suggestions) {
        String s = this.inputField.func_146179_b().substring(0, this.inputField.func_146198_h());
        int i = CCommandSuggestionHelper.getLastWhitespace(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void init() {
        boolean flag;
        String s = this.inputField.func_146179_b();
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(s)) {
            this.parseResults = null;
        }
        if (!this.isApplyingSuggestion) {
            this.inputField.func_195612_c((String)null);
            this.suggestions = null;
        }
        this.exceptionList.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.inputField.func_146198_h();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.mc.field_71439_g.field_71174_a.func_195515_i();
            if (this.parseResults == null) {
                this.parseResults = commanddispatcher.parse(stringreader, (Object)this.mc.field_71439_g.field_71174_a.func_195513_b());
            }
            int n = j = this.hasCursor ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.isApplyingSuggestion)) {
                this.suggestionsFuture = commanddispatcher.getCompletionSuggestions(this.parseResults, i);
                this.suggestionsFuture.thenRun(() -> {
                    if (this.suggestionsFuture.isDone()) {
                        this.recompileSuggestions();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = CCommandSuggestionHelper.getLastWhitespace(s1);
            Collection collection = this.mc.field_71439_g.field_71174_a.func_195513_b().func_197011_j();
            this.suggestionsFuture = ISuggestionProvider.func_197005_b((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWhitespace(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static IReorderingProcessor parseException(CommandSyntaxException exception) {
        ITextComponent itextcomponent = TextComponentUtils.func_202465_a((Message)exception.getRawMessage());
        String s = exception.getContext();
        return s == null ? itextcomponent.func_241878_f() : new TranslationTextComponent("command.context.parse_error", new Object[]{itextcomponent, exception.getCursor(), s}).func_241878_f();
    }

    private void recompileSuggestions() {
        if (this.inputField.func_146198_h() == this.inputField.func_146179_b().length()) {
            if (this.suggestionsFuture.join().isEmpty() && !this.parseResults.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.parseResults.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)entry.getValue();
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(commandsyntaxexception));
                }
                if (i > 0) {
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.parseResults.getReader().canRead()) {
                this.exceptionList.add(CCommandSuggestionHelper.parseException(Commands.func_227481_a_(this.parseResults)));
            }
        }
        this.x = 0;
        this.width = this.screen.field_230708_k_;
        if (this.exceptionList.isEmpty()) {
            this.applyFormattingToCommand(TextFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.autoSuggest && this.mc.field_71474_y.field_198018_T) {
            this.updateSuggestions(false);
        }
    }

    private void applyFormattingToCommand(TextFormatting formatting) {
        CommandContextBuilder commandcontextbuilder = this.parseResults.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.inputField.func_146198_h());
        Map map = this.mc.field_71439_g.field_71174_a.func_195515_i().getSmartUsage(suggestioncontext.parent, (Object)this.mc.field_71439_g.field_71174_a.func_195513_b());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        Style style = Style.field_240709_b_.func_240712_a_(formatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(IReorderingProcessor.func_242239_a((String)((String)entry.getValue()), (Style)style));
            i = Math.max(i, this.font.func_78256_a((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.exceptionList.addAll(list);
            this.x = MathHelper.func_76125_a((int)this.inputField.func_195611_j(suggestioncontext.startPos), (int)0, (int)(this.inputField.func_195611_j(0) + this.inputField.func_146200_o() - i));
            this.width = i;
        }
    }

    private IReorderingProcessor getParsedSuggestion(String command, int maxLength) {
        return this.parseResults != null ? CCommandSuggestionHelper.getFinalSuggestion(this.parseResults, command, maxLength) : IReorderingProcessor.func_242239_a((String)command, (Style)Style.field_240709_b_);
    }

    @Nullable
    private static String getMatchedSuggestionText(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    private static IReorderingProcessor getFinalSuggestion(ParseResults<ISuggestionProvider> provider, String command, int maxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = provider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= COMMAND_COLOR_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - maxLength, 0)) >= command.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - maxLength, command.length());
            if (l <= 0) continue;
            list.add(IReorderingProcessor.func_242239_a((String)command.substring(i, k), (Style)EMPTY_PASS_STYLE));
            list.add(IReorderingProcessor.func_242239_a((String)command.substring(k, l), (Style)COMMAND_COLOR_STYLES.get(j)));
            i = l;
        }
        if (provider.getReader().canRead() && (i1 = Math.max(provider.getReader().getCursor() - maxLength, 0)) < command.length()) {
            int j1 = Math.min(i1 + provider.getReader().getRemainingLength(), command.length());
            list.add(IReorderingProcessor.func_242239_a((String)command.substring(i, i1), (Style)EMPTY_PASS_STYLE));
            list.add(IReorderingProcessor.func_242239_a((String)command.substring(i1, j1), (Style)EMPTY_ERROR_STYLE));
            i = j1;
        }
        list.add(IReorderingProcessor.func_242239_a((String)command.substring(i), (Style)EMPTY_PASS_STYLE));
        return IReorderingProcessor.func_242241_a((List)list);
    }

    public void drawSuggestionList(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.drawSuggestions(matrixStack, mouseX, mouseY);
        } else {
            int i = 0;
            for (IReorderingProcessor ireorderingprocessor : this.exceptionList) {
                int j = this.yPos + 12 * i;
                ++i;
            }
        }
    }

    public String getSuggestionMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getCurrentSuggestionMessage() : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Suggestions {
        private final Rectangle2d suggestionRenderBox;
        private final String originalInputText;
        private final List<Suggestion> suggestions;
        private int lowestDisplayedSuggestionIndex;
        private int selectedIndex;
        private Vector2f lastMousePosition = Vector2f.field_189974_a;
        private boolean changeSelectionOnNextTabInput;
        private int lastObtainedSuggestionMessageIndex;

        private Suggestions(int x, int y, int width, List<Suggestion> suggestions, boolean narrateFirstSuggestion) {
            int i = x - 1;
            int j = CCommandSuggestionHelper.this.isChat ? y - 3 - Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12 : y;
            this.suggestionRenderBox = new Rectangle2d(i, j, width + 1, Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12);
            this.originalInputText = CCommandSuggestionHelper.this.inputField.func_146179_b();
            this.lastObtainedSuggestionMessageIndex = narrateFirstSuggestion ? -1 : 0;
            this.suggestions = suggestions;
            this.selectSuggestion(0);
        }

        public void drawSuggestions(MatrixStack matrixStack, int mouseX, int mouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered);
            int j = -5592406;
            boolean flag = this.lowestDisplayedSuggestionIndex > 0;
            boolean flag1 = this.suggestions.size() > this.lowestDisplayedSuggestionIndex + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMousePosition.field_189982_i != (float)mouseX || this.lastMousePosition.field_189983_j != (float)mouseY;
            if (flag3) {
                this.lastMousePosition = new Vector2f((float)mouseX, (float)mouseY);
            }
            if (flag2) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.suggestionRenderBox.func_199318_a(), (int)(this.suggestionRenderBox.func_199319_b() - 1), (int)(this.suggestionRenderBox.func_199318_a() + this.suggestionRenderBox.func_199316_c()), (int)this.suggestionRenderBox.func_199319_b(), (int)CCommandSuggestionHelper.this.color);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.suggestionRenderBox.func_199318_a(), (int)(this.suggestionRenderBox.func_199319_b() + this.suggestionRenderBox.func_199317_d()), (int)(this.suggestionRenderBox.func_199318_a() + this.suggestionRenderBox.func_199316_c()), (int)(this.suggestionRenderBox.func_199319_b() + this.suggestionRenderBox.func_199317_d() + 1), (int)CCommandSuggestionHelper.this.color);
                if (flag) {
                    for (int k = 0; k < this.suggestionRenderBox.func_199316_c(); ++k) {
                        if (k % 2 != 0) continue;
                        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.suggestionRenderBox.func_199318_a() + k), (int)(this.suggestionRenderBox.func_199319_b() - 1), (int)(this.suggestionRenderBox.func_199318_a() + k + 1), (int)this.suggestionRenderBox.func_199319_b(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.suggestionRenderBox.func_199316_c(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(this.suggestionRenderBox.func_199318_a() + i1), (int)(this.suggestionRenderBox.func_199319_b() + this.suggestionRenderBox.func_199317_d()), (int)(this.suggestionRenderBox.func_199318_a() + i1 + 1), (int)(this.suggestionRenderBox.func_199319_b() + this.suggestionRenderBox.func_199317_d() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.get(l + this.lowestDisplayedSuggestionIndex);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.suggestionRenderBox.func_199318_a(), (int)(this.suggestionRenderBox.func_199319_b() + 12 * l), (int)(this.suggestionRenderBox.func_199318_a() + this.suggestionRenderBox.func_199316_c()), (int)(this.suggestionRenderBox.func_199319_b() + 12 * l + 12), (int)CCommandSuggestionHelper.this.color);
                if (mouseX > this.suggestionRenderBox.func_199318_a() && mouseX < this.suggestionRenderBox.func_199318_a() + this.suggestionRenderBox.func_199316_c() && mouseY > this.suggestionRenderBox.func_199319_b() + 12 * l && mouseY < this.suggestionRenderBox.func_199319_b() + 12 * l + 12) {
                    if (flag3) {
                        this.selectSuggestion(l + this.lowestDisplayedSuggestionIndex);
                    }
                    flag4 = true;
                }
                CCommandSuggestionHelper.this.font.func_238405_a_(matrixStack, suggestion.getText(), (float)(this.suggestionRenderBox.func_199318_a() + 1), (float)(this.suggestionRenderBox.func_199319_b() + 2 + 12 * l), l + this.lowestDisplayedSuggestionIndex == this.selectedIndex ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestions.get(this.selectedIndex).getTooltip()) != null) {
                CCommandSuggestionHelper.this.screen.func_238652_a_(matrixStack, TextComponentUtils.func_202465_a((Message)message), mouseX, mouseY);
            }
        }

        public boolean onClick(int mouseX, int mouseY, int mouseButton) {
            if (!this.suggestionRenderBox.func_199315_b(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.suggestionRenderBox.func_199319_b()) / 12 + this.lowestDisplayedSuggestionIndex;
            if (i >= 0 && i < this.suggestions.size()) {
                this.selectSuggestion(i);
                this.applySuggestionToInput();
            }
            return true;
        }

        public boolean onScroll(double delta) {
            int j;
            int i = (int)(((CCommandSuggestionHelper)CCommandSuggestionHelper.this).mc.field_71417_B.func_198024_e() * (double)CCommandSuggestionHelper.this.mc.func_228018_at_().func_198107_o() / (double)CCommandSuggestionHelper.this.mc.func_228018_at_().func_198105_m());
            if (this.suggestionRenderBox.func_199315_b(i, j = (int)(((CCommandSuggestionHelper)CCommandSuggestionHelper.this).mc.field_71417_B.func_198026_f() * (double)CCommandSuggestionHelper.this.mc.func_228018_at_().func_198087_p() / (double)CCommandSuggestionHelper.this.mc.func_228018_at_().func_198083_n()))) {
                this.lowestDisplayedSuggestionIndex = MathHelper.func_76125_a((int)((int)((double)this.lowestDisplayedSuggestionIndex - delta)), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
                return true;
            }
            return false;
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.changeSelection(-1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 264) {
                this.changeSelection(1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 258) {
                if (this.changeSelectionOnNextTabInput) {
                    this.changeSelection(Screen.func_231173_s_() ? -1 : 1);
                }
                this.applySuggestionToInput();
                return true;
            }
            if (keyCode == 256) {
                this.clearSuggestions();
                return true;
            }
            return false;
        }

        public void changeSelection(int change) {
            this.selectSuggestion(this.selectedIndex + change);
            int i = this.lowestDisplayedSuggestionIndex;
            int j = this.lowestDisplayedSuggestionIndex + CCommandSuggestionHelper.this.maxAmountRendered - 1;
            if (this.selectedIndex < i) {
                this.lowestDisplayedSuggestionIndex = MathHelper.func_76125_a((int)this.selectedIndex, (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            } else if (this.selectedIndex > j) {
                this.lowestDisplayedSuggestionIndex = MathHelper.func_76125_a((int)(this.selectedIndex + CCommandSuggestionHelper.this.minAmountRendered - CCommandSuggestionHelper.this.maxAmountRendered), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            }
        }

        public void selectSuggestion(int index) {
            this.selectedIndex = index;
            if (this.selectedIndex < 0) {
                this.selectedIndex += this.suggestions.size();
            }
            if (this.selectedIndex >= this.suggestions.size()) {
                this.selectedIndex -= this.suggestions.size();
            }
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.inputField.func_195612_c(CCommandSuggestionHelper.getMatchedSuggestionText(CCommandSuggestionHelper.this.inputField.func_146179_b(), suggestion.apply(this.originalInputText)));
            if (NarratorChatListener.field_193643_a.func_193640_a() && this.lastObtainedSuggestionMessageIndex != this.selectedIndex) {
                NarratorChatListener.field_193643_a.func_216864_a(this.getCurrentSuggestionMessage());
            }
        }

        public void applySuggestionToInput() {
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = true;
            CCommandSuggestionHelper.this.inputField.func_146180_a(suggestion.apply(this.originalInputText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            CCommandSuggestionHelper.this.inputField.func_212422_f(i);
            CCommandSuggestionHelper.this.inputField.func_146199_i(i);
            this.selectSuggestion(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = false;
            this.changeSelectionOnNextTabInput = true;
        }

        private String getCurrentSuggestionMessage() {
            this.lastObtainedSuggestionMessageIndex = this.selectedIndex;
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            Message message = suggestion.getTooltip();
            return message != null ? I18n.func_135052_a((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText(), message.getString()}) : I18n.func_135052_a((String)"narration.suggestion", (Object[])new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText()});
        }

        public void clearSuggestions() {
            CCommandSuggestionHelper.this.suggestions = null;
        }
    }
}

