/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.namensammler.cosmicnpcs.client.renderer.entity.CustomLivingRenderer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CAbstractEyesLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CCatCollarLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CDrownedOuterLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CEnergyLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CHeldBlockLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLeatherHorseArmorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLlamaDecorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CMooshroomMushroomLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSaddleLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSheepWoolLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSlimeGelLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSnowmanHeadLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CStrayClothingLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CVillagerLevelPendantLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CWolfCollarLayer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.MooshroomRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.SnowManRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.WitherRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.client.renderer.entity.layers.CreeperChargeLayer;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.EndermanEyesLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldBlockLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.LeatherHorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.LlamaDecorLayer;
import net.minecraft.client.renderer.entity.layers.MooshroomMushroomLayer;
import net.minecraft.client.renderer.entity.layers.PhantomEyesLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.client.renderer.entity.layers.SheepWoolLayer;
import net.minecraft.client.renderer.entity.layers.SlimeGelLayer;
import net.minecraft.client.renderer.entity.layers.SnowmanHeadLayer;
import net.minecraft.client.renderer.entity.layers.SpiderEyesLayer;
import net.minecraft.client.renderer.entity.layers.StayClothingLayer;
import net.minecraft.client.renderer.entity.layers.VillagerLevelPendantLayer;
import net.minecraft.client.renderer.entity.layers.WitherAuraLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.CatModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.LlamaModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;

public class CosmicNPCRenderer
extends LivingRenderer<CosmicNPCEntity, PlayerModel<CosmicNPCEntity>> {
    private static PlayerModel player_model = new PlayerModel(0.0f, false);
    private static PlayerModel player_model_slim = new PlayerModel(0.0f, true);
    private static final ResourceLocation STEVE_TEXTURE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation ALEX_TEXTURE = new ResourceLocation("textures/entity/alex.png");

    public CosmicNPCRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)player_model, 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
    }

    protected void preRenderCallback(CosmicNPCEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    public ResourceLocation getEntityTexture(CosmicNPCEntity npc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + npc.getTextureName() + ".png");
        if (npc.getTextureName() != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/main/" + npc.getTextureName() + ".png");
        }
        return npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim")) ? ALEX_TEXTURE : STEVE_TEXTURE;
    }

    public void render(CosmicNPCEntity npc, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            this.field_77045_g = player_model_slim;
            this.field_76989_e = 0.5f;
            this.setModelVisibilities(npc);
            super.func_225623_a_((LivingEntity)npc, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player"))) {
            this.field_77045_g = player_model;
            this.field_76989_e = 0.5f;
            this.setModelVisibilities(npc);
            super.func_225623_a_((LivingEntity)npc, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            EntityType.func_220327_a((String)npc.getModel().toString()).ifPresent(entityType -> {
                if (entityType.func_200721_a(npc.field_70170_p) instanceof LivingEntity) {
                    LivingEntity modelEntity = (LivingEntity)entityType.func_200721_a(npc.field_70170_p);
                    if (this.field_76990_c.func_78713_a((Entity)(modelEntity = this.copyEntityData(modelEntity, npc))) instanceof LivingRenderer) {
                        LivingRenderer modelEntityRenderer = (LivingRenderer)this.field_76990_c.func_78713_a((Entity)modelEntity);
                        EntityModel model = modelEntityRenderer.func_217764_d();
                        this.field_76989_e = this.getShadowSize((LivingRenderer<LivingEntity, EntityModel<LivingEntity>>)modelEntityRenderer);
                        if (npc.getSettings().func_74767_n("IsChild")) {
                            this.field_76989_e *= 0.5f;
                        }
                        CustomLivingRenderer customRenderer = new CustomLivingRenderer(this.field_76990_c, (EntityModel<LivingEntity>)model, npc, this.getLayers(modelEntityRenderer, npc));
                        customRenderer.func_225623_a_(modelEntity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                    }
                }
            });
        }
    }

    private LivingEntity copyEntityData(LivingEntity modelEntity, CosmicNPCEntity npc) {
        modelEntity.field_184622_au = npc.field_184622_au;
        modelEntity.field_70733_aJ = npc.field_70733_aJ;
        modelEntity.field_70732_aI = npc.field_70732_aI;
        modelEntity.field_70173_aa = npc.field_70173_aa;
        modelEntity.func_145769_d(npc.func_145782_y());
        modelEntity.func_70080_a(npc.func_226277_ct_(), npc.func_226278_cu_(), npc.func_226281_cx_(), npc.field_70177_z, npc.field_70125_A);
        modelEntity.field_70126_B = npc.field_70126_B;
        modelEntity.field_70127_C = npc.field_70127_C;
        modelEntity.field_70759_as = npc.field_70759_as;
        modelEntity.field_70758_at = npc.field_70758_at;
        modelEntity.field_70761_aq = npc.field_70761_aq;
        modelEntity.field_70760_ar = npc.field_70760_ar;
        modelEntity.field_184619_aG = npc.field_184619_aG;
        modelEntity.field_70721_aZ = npc.field_70721_aZ;
        modelEntity.field_184618_aE = npc.field_184618_aE;
        modelEntity.field_70737_aN = npc.field_70737_aN;
        modelEntity.func_184201_a(EquipmentSlotType.MAINHAND, npc.func_184614_ca());
        modelEntity.func_184201_a(EquipmentSlotType.OFFHAND, npc.func_184592_cb());
        modelEntity.func_184201_a(EquipmentSlotType.HEAD, npc.func_184582_a(EquipmentSlotType.HEAD));
        modelEntity.func_184201_a(EquipmentSlotType.CHEST, npc.func_184582_a(EquipmentSlotType.CHEST));
        modelEntity.func_184201_a(EquipmentSlotType.LEGS, npc.func_184582_a(EquipmentSlotType.LEGS));
        modelEntity.func_184201_a(EquipmentSlotType.FEET, npc.func_184582_a(EquipmentSlotType.FEET));
        modelEntity.func_213301_b(npc.func_213283_Z());
        modelEntity.func_226284_e_(npc.func_225608_bj_());
        modelEntity.func_200203_b(npc.func_200201_e());
        modelEntity.func_174805_g(npc.func_174833_aM());
        modelEntity.func_82142_c(npc.func_82150_aj());
        VillagerType type = (VillagerType)Registry.field_218369_K.func_82594_a(new ResourceLocation(npc.getSettings().func_74779_i("VillagerType")));
        VillagerProfession profession = Registry.field_218370_L.func_241873_b(new ResourceLocation(npc.getSettings().func_74779_i("Profession"))).orElse(VillagerProfession.field_221152_b);
        int profLevel = npc.getSettings().func_74762_e("ProfessionLevel");
        if (npc.getSettings().func_74779_i("Profession").equals("default") && npc.getSettings().func_74779_i("ProfessionLevel").equals("default")) {
            profession = VillagerProfession.field_221151_a;
        }
        VillagerData data = new VillagerData(type, profession, profLevel);
        if (modelEntity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)modelEntity;
            villager.func_213753_a(data);
            return villager;
        }
        if (modelEntity instanceof ZombieVillagerEntity) {
            ZombieVillagerEntity zVillager = (ZombieVillagerEntity)modelEntity;
            zVillager.func_213792_a(data);
            return zVillager;
        }
        if (modelEntity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)modelEntity;
            mobEntity.func_82227_f(npc.getSettings().func_74767_n("IsChild"));
            if (npc.func_184614_ca().func_77973_b() instanceof BowItem && npc.func_184587_cr()) {
                mobEntity.func_213395_q(true);
            }
            return mobEntity;
        }
        return modelEntity;
    }

    private List<LayerRenderer<LivingEntity, EntityModel<LivingEntity>>> getLayers(LivingRenderer renderer, CosmicNPCEntity npc) {
        List layerRenderers = Lists.newArrayList();
        ArrayList newLayerRenderers = Lists.newArrayList();
        try {
            Field layerRenderersField = null;
            layerRenderersField = LivingRenderer.class.getDeclaredField("layerRenderers");
            layerRenderersField.setAccessible(true);
            layerRenderers = (List)layerRenderersField.get(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < layerRenderers.size(); ++i) {
            SnowManRenderer snowmanRenderer;
            EndermanRenderer endermanRenderer;
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(VillagerLevelPendantLayer.class)) {
                newLayerRenderers.add(new CVillagerLevelPendantLayer(renderer, (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G(), "villager", npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(SheepWoolLayer.class)) {
                SheepRenderer sheepRenderer = (SheepRenderer)renderer;
                newLayerRenderers.add(new CSheepWoolLayer(sheepRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(EndermanEyesLayer.class)) {
                endermanRenderer = (EndermanRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(endermanRenderer, npc, CAbstractEyesLayer.EyeType.ENDERMAN));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(SpiderEyesLayer.class)) {
                SpiderRenderer spiderRenderer = (SpiderRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(spiderRenderer, npc, CAbstractEyesLayer.EyeType.SPIDER));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(PhantomEyesLayer.class)) {
                PhantomRenderer phantomRenderer = (PhantomRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(phantomRenderer, npc, CAbstractEyesLayer.EyeType.PHANTOM));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(StayClothingLayer.class)) {
                StrayRenderer strayRenderer = (StrayRenderer)renderer;
                newLayerRenderers.add(new CStrayClothingLayer(strayRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(DrownedOuterLayer.class)) {
                DrownedRenderer drownedRenderer = (DrownedRenderer)renderer;
                newLayerRenderers.add(new CDrownedOuterLayer(drownedRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(MooshroomMushroomLayer.class)) {
                MooshroomRenderer mooshroomRenderer = (MooshroomRenderer)renderer;
                newLayerRenderers.add(new CMooshroomMushroomLayer(mooshroomRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(LlamaDecorLayer.class)) {
                LlamaRenderer llamaRenderer = (LlamaRenderer)renderer;
                newLayerRenderers.add(new CLlamaDecorLayer((IEntityRenderer<LlamaEntity, LlamaModel<LlamaEntity>>)llamaRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(CatCollarLayer.class)) {
                CatRenderer catRenderer = (CatRenderer)renderer;
                newLayerRenderers.add(new CCatCollarLayer((IEntityRenderer<CatEntity, CatModel<CatEntity>>)catRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(CreeperChargeLayer.class)) {
                CreeperRenderer creeperRenderer = (CreeperRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(creeperRenderer, npc, CEnergyLayer.Type.CREEPER));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(WitherAuraLayer.class)) {
                WitherRenderer witherRenderer = (WitherRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(witherRenderer, npc, CEnergyLayer.Type.WITHER));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(LeatherHorseArmorLayer.class)) {
                HorseRenderer horseRenderer = (HorseRenderer)renderer;
                newLayerRenderers.add(new CLeatherHorseArmorLayer((IEntityRenderer<HorseEntity, HorseModel<HorseEntity>>)horseRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(SaddleLayer.class)) {
                if (renderer instanceof StriderRenderer) {
                    newLayerRenderers.add(new CSaddleLayer(renderer, renderer.func_217764_d(), new ResourceLocation("textures/entity/strider/strider_saddle.png"), npc));
                    continue;
                }
                newLayerRenderers.add(new CSaddleLayer(renderer, renderer.func_217764_d(), new ResourceLocation("textures/entity/pig/pig_saddle.png"), npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(SlimeGelLayer.class)) {
                newLayerRenderers.add(new CSlimeGelLayer(renderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(SnowmanHeadLayer.class)) {
                snowmanRenderer = (SnowManRenderer)renderer;
                newLayerRenderers.add(new CSnowmanHeadLayer((IEntityRenderer<SnowGolemEntity, SnowManModel<SnowGolemEntity>>)snowmanRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(WolfCollarLayer.class)) {
                snowmanRenderer = (WolfRenderer)renderer;
                newLayerRenderers.add(new CWolfCollarLayer((IEntityRenderer<WolfEntity, WolfModel<WolfEntity>>)snowmanRenderer, npc));
                continue;
            }
            if (((LayerRenderer)layerRenderers.get(i)).getClass().equals(HeldBlockLayer.class)) {
                endermanRenderer = (EndermanRenderer)renderer;
                newLayerRenderers.add(new CHeldBlockLayer(endermanRenderer));
                continue;
            }
            newLayerRenderers.add(layerRenderers.get(i));
        }
        return newLayerRenderers;
    }

    private float getShadowSize(LivingRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        float shadowSize = 0.5f;
        try {
            Field shadowSizeField = null;
            shadowSizeField = EntityRenderer.class.getDeclaredField("shadowSize");
            shadowSizeField.setAccessible(true);
            shadowSize = shadowSizeField.getFloat(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return shadowSize;
    }

    private void setModelVisibilities(CosmicNPCEntity clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            playermodel.func_178719_a(true);
            playermodel.field_228270_o_ = clientPlayer.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = CosmicNPCRenderer.func_241741_a_(clientPlayer, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = CosmicNPCRenderer.func_241741_a_(clientPlayer, Hand.OFF_HAND);
            if (bipedmodel$armpose.func_241657_a_()) {
                BipedModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = bipedmodel$armpose;
                playermodel.field_187075_l = bipedmodel$armpose1;
            } else {
                playermodel.field_187076_m = bipedmodel$armpose1;
                playermodel.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    private static BipedModel.ArmPose func_241741_a_(CosmicNPCEntity p_241741_0_, Hand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.func_184586_b(p_241741_1_);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.func_184600_cs() == p_241741_1_ && p_241741_0_.func_184605_cv() > 0) {
            UseAction useaction = itemstack.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && p_241741_1_ == p_241741_0_.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    protected void applyRotations(CosmicNPCEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected boolean canRenderName(CosmicNPCEntity entity) {
        return super.func_177070_b((LivingEntity)entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }
}

