/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CustomLivingRenderer
extends LivingRenderer<LivingEntity, EntityModel<LivingEntity>> {
    CosmicNPCEntity npc;

    public CustomLivingRenderer(EntityRendererManager rendererManager, EntityModel<LivingEntity> model, CosmicNPCEntity npc, List<LayerRenderer<LivingEntity, EntityModel<LivingEntity>>> layerList) {
        super(rendererManager, model, 0.5f);
        this.npc = npc;
        for (int i = 0; i < layerList.size(); ++i) {
            this.func_177094_a(layerList.get(i));
        }
    }

    public ResourceLocation getEntityTexture(LivingEntity entity) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + this.npc.getTextureName() + ".png");
        if (this.npc.getTextureName() != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/main/" + this.npc.getTextureName() + ".png");
        }
        return this.field_76990_c.func_78713_a((Entity)entity).func_110775_a((Entity)entity);
    }

    public void func_225623_a_(LivingEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        LivingRenderer modelRenderer = (LivingRenderer)this.field_76990_c.func_78713_a((Entity)entityIn);
        matrixStackIn.func_227860_a_();
        this.field_77045_g.field_217112_c = this.func_77040_d(entityIn, partialTicks);
        boolean isChild = this.npc.getSettings().func_74767_n("IsChild");
        this.field_77045_g.field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        this.field_77045_g.field_217114_e = isChild;
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStackIn.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = (float)entityIn.field_70173_aa + partialTicks;
        try {
            Method handleRotationFloatMethod = modelRenderer.getClass().getDeclaredMethod("handleRotationFloat", entityIn.getClass(), Float.TYPE);
            handleRotationFloatMethod.setAccessible(true);
            f7 = ((Float)handleRotationFloatMethod.invoke((Object)modelRenderer, entityIn, Float.valueOf(partialTicks))).floatValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException handleRotationFloatMethod) {
            // empty catch block
        }
        try {
            Method applyRotationsMethod = modelRenderer.getClass().getDeclaredMethod("applyRotations", entityIn.getClass(), MatrixStack.class, Float.TYPE, Float.TYPE, Float.TYPE);
            applyRotationsMethod.setAccessible(true);
            applyRotationsMethod.invoke((Object)modelRenderer, entityIn, matrixStackIn, Float.valueOf(f7), Float.valueOf(f), Float.valueOf(partialTicks));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            this.func_225621_a_(entityIn, matrixStackIn, f7, f, partialTicks);
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        try {
            Method preRenderCallbackMethod = modelRenderer.getClass().getDeclaredMethod("preRenderCallback", entityIn.getClass(), MatrixStack.class, Float.TYPE);
            preRenderCallbackMethod.setAccessible(true);
            preRenderCallbackMethod.invoke((Object)modelRenderer, entityIn, matrixStackIn, Float.valueOf(partialTicks));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException preRenderCallbackMethod) {
            // empty catch block
        }
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (isChild) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.field_77045_g.func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        this.field_77045_g.func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = this.func_225622_a_(entityIn);
        boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        boolean flag2 = minecraft.func_238206_b_((Entity)entityIn);
        RenderType rendertype = this.func_230496_a_(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = CustomLivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)this.func_225625_b_(entityIn, partialTicks));
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entityIn.func_175149_v()) {
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.func_227865_b_();
        if (this.func_177070_b(entityIn)) {
            this.func_225629_a_((Entity)entityIn, entityIn.func_145748_c_(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean func_177070_b(LivingEntity entity) {
        return super.func_177070_b(entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }
}

