/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CEnergyLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private final CreeperModel<CreeperEntity> creeperModel = new CreeperModel(2.0f);
    private final WitherModel<WitherEntity> witherModel = new WitherModel(0.5f);
    private Type type;
    private boolean isCharged;
    private String layerTexture;

    public CEnergyLayer(IEntityRenderer<T, M> p_i50947_1_, CosmicNPCEntity npc, Type type) {
        super(p_i50947_1_);
        this.type = type;
        this.isCharged = npc.getSettings().func_74767_n("Charged");
        this.layerTexture = npc.getSettings().func_74779_i("Layer");
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.isCharged) {
            float f = (float)((LivingEntity)entitylivingbaseIn).field_70173_aa + partialTicks;
            EntityModel<T> entitymodel = this.func_225635_b_();
            entitymodel.func_212843_a_(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.func_215332_c().func_217111_a(entitymodel);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.getLayerTexture(), (float)this.func_225634_a_(f), (float)(f * 0.01f)));
            entitymodel.func_225597_a_(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            entitymodel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected float func_225634_a_(float p_225634_1_) {
        if (this.type == Type.WITHER) {
            return MathHelper.func_76134_b((float)(p_225634_1_ * 0.02f)) * 3.0f;
        }
        return p_225634_1_ * 0.01f;
    }

    protected EntityModel<T> func_225635_b_() {
        if (this.type == Type.WITHER) {
            return this.witherModel;
        }
        return this.creeperModel;
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return this.type.getResourceLocation();
    }

    public static enum Type {
        CREEPER(new ResourceLocation("textures/entity/creeper/creeper_armor.png")),
        WITHER(new ResourceLocation("textures/entity/wither/wither_armor.png"));

        private ResourceLocation resourceLocation;

        private Type(ResourceLocation loc) {
            this.resourceLocation = loc;
        }

        private ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

