/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SheepWoolModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CSheepWoolLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    private final M sheepModel = new SheepWoolModel();
    private String layerTexture;
    private String color;
    private boolean sheared;

    public CSheepWoolLayer(IEntityRenderer<T, M> rendererIn, CosmicNPCEntity npc) {
        super(rendererIn);
        this.layerTexture = npc.getSettings().func_74779_i("Layer");
        this.color = npc.getSettings().func_74779_i("Color");
        this.sheared = npc.getSettings().func_74767_n("Sheared");
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.sheared && !entitylivingbaseIn.func_82150_aj()) {
            float f2;
            float f1;
            float f;
            if (entitylivingbaseIn.func_145818_k_() && "jeb_".equals(entitylivingbaseIn.func_200200_C_().func_150261_e()) || this.color.toLowerCase().equals("rainbow")) {
                int i1 = 25;
                int i = ((LivingEntity)entitylivingbaseIn).field_70173_aa / 25 + entitylivingbaseIn.func_145782_y();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f3 = ((float)(((LivingEntity)entitylivingbaseIn).field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)k));
                float[] afloat2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)l));
                f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
                f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
                f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            } else {
                float[] afloat = SheepEntity.func_175513_a((DyeColor)((SheepEntity)entitylivingbaseIn).func_175509_cj());
                for (DyeColor dyeColor : DyeColor.values()) {
                    if (!dyeColor.func_176762_d().equals(this.color)) continue;
                    afloat = SheepEntity.func_175513_a((DyeColor)dyeColor);
                }
                f = afloat[0];
                f1 = afloat[1];
                f2 = afloat[2];
            }
            CSheepWoolLayer.func_229140_a_((EntityModel)this.func_215332_c(), this.sheepModel, (ResourceLocation)this.getLayerTexture(), (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)f, (float)f1, (float)f2);
        }
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return TEXTURE;
    }
}

