/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHeadToggle;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CVillagerLevelPendantLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M>
implements IResourceManagerReloadListener {
    private static final Int2ObjectMap<ResourceLocation> field_215352_a = (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), p_215348_0_ -> {
        p_215348_0_.put(1, (Object)new ResourceLocation("stone"));
        p_215348_0_.put(2, (Object)new ResourceLocation("iron"));
        p_215348_0_.put(3, (Object)new ResourceLocation("gold"));
        p_215348_0_.put(4, (Object)new ResourceLocation("emerald"));
        p_215348_0_.put(5, (Object)new ResourceLocation("diamond"));
    });
    private final Object2ObjectMap<VillagerType, VillagerMetadataSection.HatType> field_215353_b = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetadataSection.HatType> field_215354_c = new Object2ObjectOpenHashMap();
    private final IReloadableResourceManager field_215355_d;
    private final String field_215356_e;
    private String villagerTypeTexture;
    private String professionTexture;
    private String professionLevelTexture;

    public CVillagerLevelPendantLayer(IEntityRenderer<T, M> p_i50955_1_, IReloadableResourceManager p_i50955_2_, String p_i50955_3_, CosmicNPCEntity npc) {
        super(p_i50955_1_);
        this.field_215355_d = p_i50955_2_;
        this.field_215356_e = p_i50955_3_;
        CompoundNBT settings = npc.getSettings();
        this.villagerTypeTexture = settings.func_74779_i("VillagerType");
        this.professionTexture = settings.func_74779_i("Profession");
        this.professionLevelTexture = settings.func_74779_i("ProfessionLevel");
        if (!settings.func_74779_i("Layer").equals("default")) {
            this.villagerTypeTexture = settings.func_74779_i("Layer");
        }
        p_i50955_2_.func_219534_a((IFutureReloadListener)this);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.func_82150_aj()) {
            VillagerData villagerdata = ((IVillagerDataHolder)entitylivingbaseIn).func_213700_eh();
            VillagerType villagertype = villagerdata.func_221129_a();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            VillagerMetadataSection.HatType villagermetadatasection$hattype = this.func_215350_a(this.field_215353_b, "type", Registry.field_218369_K, villagertype);
            VillagerMetadataSection.HatType villagermetadatasection$hattype1 = this.func_215350_a(this.field_215354_c, "profession", Registry.field_218370_L, villagerprofession);
            EntityModel m = this.func_215332_c();
            ((IHeadToggle)m).func_217146_a(villagermetadatasection$hattype1 == VillagerMetadataSection.HatType.NONE || villagermetadatasection$hattype1 == VillagerMetadataSection.HatType.PARTIAL && villagermetadatasection$hattype != VillagerMetadataSection.HatType.FULL);
            ResourceLocation resourcelocation = this.getVillagerTypeTexture(this.villagerTypeTexture, Registry.field_218369_K.func_177774_c((Object)villagertype));
            CVillagerLevelPendantLayer.func_229141_a_((EntityModel)m, (ResourceLocation)resourcelocation, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
            ((IHeadToggle)m).func_217146_a(true);
            if (villagerprofession != VillagerProfession.field_221151_a && !entitylivingbaseIn.func_70631_g_()) {
                ResourceLocation resourcelocation1 = this.getProfessionTexture(this.professionTexture, Registry.field_218370_L.func_177774_c((Object)villagerprofession));
                CVillagerLevelPendantLayer.func_229141_a_((EntityModel)m, (ResourceLocation)resourcelocation1, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                if (villagerprofession != VillagerProfession.field_221162_l) {
                    ResourceLocation resourcelocation2 = this.getProfessionLevelTexture(this.professionLevelTexture, (ResourceLocation)field_215352_a.get(MathHelper.func_76125_a((int)villagerdata.func_221132_c(), (int)1, (int)field_215352_a.size())));
                    CVillagerLevelPendantLayer.func_229141_a_((EntityModel)m, (ResourceLocation)resourcelocation2, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    private ResourceLocation func_215351_a(String p_215351_1_, ResourceLocation p_215351_2_) {
        return new ResourceLocation(p_215351_2_.func_110624_b(), "textures/entity/" + this.field_215356_e + "/" + p_215351_1_ + "/" + p_215351_2_.func_110623_a() + ".png");
    }

    public <K> VillagerMetadataSection.HatType func_215350_a(Object2ObjectMap<K, VillagerMetadataSection.HatType> p_215350_1_, String p_215350_2_, DefaultedRegistry<K> p_215350_3_, K p_215350_4_) {
        return (VillagerMetadataSection.HatType)p_215350_1_.computeIfAbsent(p_215350_4_, p_215349_4_ -> {
            try (IResource iresource = this.field_215355_d.func_199002_a(this.func_215351_a(p_215350_2_, p_215350_3_.func_177774_c(p_215350_4_)));){
                VillagerMetadataSection villagermetadatasection = (VillagerMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                if (villagermetadatasection == null) return VillagerMetadataSection.HatType.NONE;
                VillagerMetadataSection.HatType hatType = villagermetadatasection.func_217826_a();
                return hatType;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return VillagerMetadataSection.HatType.NONE;
        });
    }

    public void func_195410_a(IResourceManager resourceManager) {
        this.field_215354_c.clear();
        this.field_215353_b.clear();
    }

    public ResourceLocation getVillagerTypeTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : Registry.field_218369_K.func_239659_c_()) {
            if (!((VillagerType)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.func_215351_a("type", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.func_215351_a("type", loc);
    }

    public ResourceLocation getProfessionTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : Registry.field_218370_L.func_239659_c_()) {
            if (!((VillagerProfession)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.func_215351_a("profession", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.func_215351_a("profession", loc);
    }

    public ResourceLocation getProfessionLevelTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.func_215351_a("profession_level", loc);
    }
}

