/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NPCPlayCommand {
    static ArrayList<PlayThread> playThreads = new ArrayList();

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)"npc-play").then(Commands.func_197056_a((String)"file", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.REC_FILES).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), new ResourceLocation("minecraft:player"), new CompoundNBT(), (CommandSource)context.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSource>)context, "model"), new CompoundNBT(), (CommandSource)context.getSource()))).then(Commands.func_197056_a((String)"settings", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSource>)context, "model"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"settings"), (CommandSource)context.getSource())))))));
    }

    private static int play(String fileNameIn, String npcName, String textureName, ResourceLocation model, CompoundNBT compound, CommandSource source) {
        File file = null;
        String path = "config/cosmicnpcs";
        file = new File(path + "/recordings/" + fileNameIn + ".ccap");
        if (!file.exists()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Can't find " + fileNameIn + ".ccap file!"));
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yawHead = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            if (magic != -5119) {
                in.close();
                source.func_197021_a((ITextComponent)new StringTextComponent(fileNameIn + " isn't a .ccap file."));
            }
            yawHead = in.readFloat();
            yaw = in.readFloat();
            pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServerWorld world = source.func_197023_e();
        CosmicNPCEntity npc = (CosmicNPCEntity)((EntityType)EntityTypesInit.COSMIC_NPC.get()).func_200721_a((World)world);
        int showNameTagDefaultValue = 0;
        if (model.equals((Object)new ResourceLocation("minecraft:player")) || model.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            showNameTagDefaultValue = 1;
        }
        CompoundNBT settings = npc.getSettings();
        settings.func_74768_a("ShowNameTag", compound.func_74764_b("ShowNameTag") ? compound.func_74762_e("ShowNameTag") : showNameTagDefaultValue);
        settings.func_74757_a("Invulnerable", compound.func_74764_b("Invulnerable") ? compound.func_74767_n("Invulnerable") : false);
        settings.func_74757_a("UseCommands", compound.func_74764_b("UseCommands") ? compound.func_74767_n("UseCommands") : false);
        settings.func_74757_a("IsChild", compound.func_74764_b("IsChild") ? compound.func_74767_n("IsChild") : false);
        settings.func_74778_a("Layer", compound.func_74764_b("Layer") ? compound.func_74779_i("Layer") : "default");
        settings.func_74778_a("VillagerType", compound.func_74764_b("VillagerType") ? compound.func_74779_i("VillagerType") : "default");
        settings.func_74778_a("Profession", compound.func_74764_b("Profession") ? compound.func_74779_i("Profession") : "default");
        settings.func_74778_a("ProfessionLevel", compound.func_74764_b("ProfessionLevel") ? compound.func_74779_i("ProfessionLevel") : "default");
        if (compound.func_150297_b("ProfessionLevel", 99)) {
            settings.func_74768_a("ProfessionLevel", compound.func_74764_b("ProfessionLevel") ? compound.func_74762_e("ProfessionLevel") : 1);
        }
        settings.func_74778_a("Color", compound.func_74764_b("Color") ? compound.func_74779_i("Color") : "default");
        settings.func_74757_a("Sheared", compound.func_74764_b("Sheared") ? compound.func_74767_n("Sheared") : false);
        settings.func_74778_a("MushroomBlock", compound.func_74764_b("MushroomBlock") ? compound.func_74779_i("MushroomBlock") : "default");
        settings.func_74757_a("Charged", compound.func_74764_b("Charged") ? compound.func_74767_n("Charged") : false);
        settings.func_74778_a("Armor", compound.func_74764_b("Armor") ? compound.func_74779_i("Armor") : "default");
        settings.func_74757_a("Saddled", compound.func_74764_b("Saddled") ? compound.func_74767_n("Saddled") : false);
        settings.func_74778_a("Head", compound.func_74764_b("Head") ? compound.func_74779_i("Head") : "default");
        npc.func_70107_b(x, y, z);
        npc.field_70759_as = yawHead;
        npc.field_70177_z = yaw;
        npc.field_70125_A = pitch;
        npc.setNPCName(npcName);
        npc.setTextureName(textureName);
        npc.setModel(model);
        npc.setSettings(settings);
        if (settings.func_74762_e("ShowNameTag") >= 1) {
            npc.func_200203_b((ITextComponent)new StringTextComponent(npcName));
        } else {
            npc.func_200203_b(null);
        }
        if (settings.func_74762_e("ShowNameTag") == 1) {
            npc.func_174805_g(true);
        } else {
            npc.func_174805_g(false);
        }
        npc.func_184224_h(settings.func_74767_n("Invulnerable"));
        world.func_217376_c((Entity)npc);
        Iterator<PlayThread> iterator = playThreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playThreads.add(new PlayThread(npc, fileNameIn));
        return 1;
    }
}

