/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class SuggestionProviders {
    public static final SuggestionProvider<CommandSource> REC_FILES = (context, builder) -> {
        File recFolder = new File("config/cosmicnpcs/recordings");
        if (!recFolder.exists()) {
            recFolder.mkdir();
        }
        String[] filenames = recFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ccap");
            }
        });
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = filenames[i].replaceAll(".ccap", "");
        }
        return ISuggestionProvider.func_197008_a((String[])filenames, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSource> TEXTURE_FILES = (context, builder) -> {
        File recFolder = new File("config/cosmicnpcs/resources/textures/main");
        if (!recFolder.exists()) {
            recFolder.mkdir();
        }
        String[] filenames = recFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".png");
            }
        });
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = filenames[i].replaceAll(".png", "");
        }
        ArrayList<String> models = new ArrayList<String>(Arrays.asList(filenames));
        models.add("default");
        return ISuggestionProvider.func_197005_b(models, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSource> NPC_MODELS = (context, builder) -> {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        models.add(new ResourceLocation("minecraft:player"));
        models.add(new ResourceLocation("minecraft:player_slim"));
        for (ResourceLocation location : Registry.field_212629_r.func_148742_b()) {
            if (location.toString().equals("cosmicnpcs:cosmicnpc") || !(((EntityType)Registry.field_212629_r.func_82594_a(location)).func_200721_a((World)((CommandSource)context.getSource()).func_197023_e()) instanceof LivingEntity)) continue;
            models.add(location);
        }
        return ISuggestionProvider.func_197014_a(models, (SuggestionsBuilder)builder);
    };
}

