/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CosmicNPCEntity
extends LivingEntity {
    public static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntitySize> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.SLEEPING, (Object)field_213377_as).put((Object)Pose.FALL_FLYING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.func_220314_b((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntitySize.func_220311_c((float)0.2f, (float)0.2f)).build();
    private static final DataParameter<String> NPC_NAME = EntityDataManager.func_187226_a(CosmicNPCEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TEXTURE_NAME = EntityDataManager.func_187226_a(CosmicNPCEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> MODEL_NAME = EntityDataManager.func_187226_a(CosmicNPCEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> LAYER_TEXTURE = EntityDataManager.func_187226_a(CosmicNPCEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<CompoundNBT> SETTINGS = EntityDataManager.func_187226_a(CosmicNPCEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    protected ItemStack lastActiveItemStack = ItemStack.field_190927_a;
    public ArrayList<PlayThread> playThreads;
    public String recFile = "";
    public List<NPCAction> eventsList = Collections.synchronizedList(new ArrayList());
    public PlayerEntity npcplayer = new PlayerEntity(this.field_70170_p, this.func_233580_cy_(), 0.0f, new GameProfile(this.field_96093_i, "NPCPlayer")){

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return true;
        }

        public OptionalInt func_213829_a(@Nullable INamedContainerProvider p_213829_1_) {
            Container container;
            if (p_213829_1_ == null) {
                return OptionalInt.empty();
            }
            if (this.field_71070_bA != this.field_71069_bz) {
                this.func_71053_j();
            }
            if ((container = p_213829_1_.createMenu(0, this.field_71071_by, (PlayerEntity)this)) == null) {
                return OptionalInt.empty();
            }
            this.field_71070_bA = container;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)this, this.field_71070_bA));
            return OptionalInt.of(0);
        }
    };
    public final PlayerInventory inventory = new PlayerInventory(this.npcplayer);

    public CosmicNPCEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(NPC_NAME, (Object)"CosmicNPC");
        this.field_70180_af.func_187214_a(TEXTURE_NAME, (Object)"default");
        this.field_70180_af.func_187214_a(MODEL_NAME, (Object)"player");
        this.field_70180_af.func_187214_a(LAYER_TEXTURE, (Object)"default");
        this.field_70180_af.func_187214_a(SETTINGS, (Object)new CompoundNBT());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.1f).func_233814_a_(Attributes.field_233825_h_).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233814_a_(Attributes.field_233824_g_);
    }

    public void setNPCName(String npcName) {
        this.field_70180_af.func_187227_b(NPC_NAME, (Object)npcName);
    }

    public String getNPCName() {
        return (String)this.field_70180_af.func_187225_a(NPC_NAME);
    }

    public void setTextureName(String textureName) {
        this.field_70180_af.func_187227_b(TEXTURE_NAME, (Object)textureName);
    }

    public String getTextureName() {
        return (String)this.field_70180_af.func_187225_a(TEXTURE_NAME);
    }

    public void setModel(ResourceLocation model) {
        this.field_70180_af.func_187227_b(MODEL_NAME, (Object)model.toString());
    }

    public ResourceLocation getModel() {
        return new ResourceLocation((String)this.field_70180_af.func_187225_a(MODEL_NAME));
    }

    public void setSettings(CompoundNBT settings) {
        this.field_70180_af.func_187227_b(SETTINGS, (Object)settings);
    }

    public CompoundNBT getSettings() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(SETTINGS);
    }

    public void setElytraFlying(boolean isElytraFlying) {
        this.func_70052_a(7, isElytraFlying);
    }

    public void startActions(ArrayList<PlayThread> playthreads, String recFile) {
        Iterator<PlayThread> iterator = playthreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playthreads.add(new PlayThread(this, recFile));
    }

    private void replayShootArrow(NPCAction ma) {
        float f = (float)ma.arrowCharge / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        ArrowItem arrow = (ArrowItem)new ItemStack((IItemProvider)Items.field_151032_g).func_77973_b();
        AbstractArrowEntity entityarrow = arrow.func_200887_a(this.field_70170_p, this.func_184607_cu(), (LivingEntity)this);
        entityarrow.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            entityarrow.func_70243_d(true);
        }
        this.field_70170_p.func_217376_c((Entity)entityarrow);
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    private void processActions(NPCAction ma) {
        switch (ma.type) {
            case 1: {
                List temp = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
                for (ServerPlayerEntity player : temp) {
                    StringTextComponent cmp = new StringTextComponent("<" + this.getNPCName() + "> " + ma.message);
                    player.func_145747_a((ITextComponent)cmp, Util.field_240973_b_);
                }
                break;
            }
            case 2: {
                this.func_184609_a(Hand.MAIN_HAND);
                LivingEntity mop = this.GetTargetEntityLiving(5);
                if (mop == null) break;
                this.func_70652_k((Entity)mop);
                this.attackTargetEntityWithCurrentItem((Entity)mop);
                break;
            }
            case 4: {
                if (ma.armorId == -1) {
                    this.func_184201_a(this.getEquipmentSlotById(ma.armorSlot), ItemStack.field_190927_a);
                    break;
                }
                ItemStack loadedEquip = ItemStack.func_199557_a((CompoundNBT)ma.itemData);
                this.func_184201_a(this.getEquipmentSlotById(ma.armorSlot), loadedEquip);
                break;
            }
            case 3: {
                ItemStack droppedItem = ItemStack.func_199557_a((CompoundNBT)ma.itemData);
                double d0 = this.func_226280_cw_() - (double)0.3f;
                ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), d0, this.func_226281_cx_(), droppedItem);
                itementity.func_174867_a(40);
                float f7 = 0.3f;
                float f8 = MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)));
                float f2 = MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
                float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f4 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f5 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f6 = 0.02f * this.field_70146_Z.nextFloat();
                itementity.func_213293_j((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                this.field_70170_p.func_217376_c((Entity)itementity);
                break;
            }
            case 5: {
                this.replayShootArrow(ma);
                break;
            }
            case 8: {
                BlockState block = this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (block == Blocks.field_150350_a.func_176223_P()) break;
                this.field_70170_p.func_217379_c(2001, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Block.func_196246_j((BlockState)block));
                this.field_70170_p.func_175656_a(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Blocks.field_150350_a.func_176223_P());
                block.func_177230_c().func_176208_a(this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block, this.npcplayer);
                break;
            }
            case 7: {
                BlockState block = Block.func_196257_b((int)ma.stateId);
                this.field_70170_p.func_175656_a(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block);
                if (block.func_177230_c() instanceof DoorBlock) {
                    BlockState upperDoor = (BlockState)block.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER);
                    this.field_70170_p.func_175656_a(new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), upperDoor);
                }
                SoundType soundtype = block.func_177230_c().getSoundType(block, (IWorldReader)this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), (Entity)this);
                this.field_70170_p.func_184133_a(null, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                break;
            }
            case 9: {
                Block aBlock = this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord)).func_177230_c();
                if (aBlock == Blocks.field_150350_a) break;
                aBlock.func_225533_a_(this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord)), this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), this.npcplayer, Hand.MAIN_HAND, new BlockRayTraceResult(this.func_70040_Z(), this.func_174811_aO(), this.func_233580_cy_(), false));
                break;
            }
            case 10: {
                this.npcplayer.field_71070_bA.func_75134_a(this.npcplayer);
                this.npcplayer.field_71070_bA = this.npcplayer.field_71069_bz;
                break;
            }
            case 11: {
                this.npcplayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.npcplayer.field_70177_z = this.field_70177_z;
                this.npcplayer.field_70125_A = this.field_70125_A;
                this.npcplayer.field_70759_as = this.field_70759_as;
                this.npcplayer.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.func_199557_a((CompoundNBT)this.func_184614_ca().serializeNBT()));
                this.npcplayer.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.func_199557_a((CompoundNBT)this.func_184592_cb().serializeNBT()));
                this.func_184586_b(ma.handType).func_77973_b().func_77659_a(this.field_70170_p, this.npcplayer, ma.handType);
                this.lastActiveItemStack = this.func_184586_b(ma.handType);
                break;
            }
            case 12: {
                this.lastActiveItemStack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                this.lastActiveItemStack = ItemStack.field_190927_a;
                break;
            }
            case 13: {
                this.npcplayer.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.npcplayer.field_70177_z = this.field_70177_z;
                this.npcplayer.field_70125_A = this.field_70125_A;
                this.npcplayer.field_70759_as = this.field_70759_as;
                this.npcplayer.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.func_199557_a((CompoundNBT)this.func_184614_ca().serializeNBT()));
                this.npcplayer.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.func_199557_a((CompoundNBT)this.func_184592_cb().serializeNBT()));
                this.lastActiveItemStack.func_77973_b().func_77615_a(this.lastActiveItemStack, this.field_70170_p, (LivingEntity)this.npcplayer, 0);
                this.lastActiveItemStack = ItemStack.field_190927_a;
                break;
            }
            case 14: {
                if (!this.getSettings().func_74767_n("UseCommands")) break;
                this.func_184102_h().func_195571_aL().func_197059_a(this.func_195051_bN().func_197031_a().func_197026_b(5), ma.message);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.eventsList.size() > 0) {
            NPCAction ma = this.eventsList.remove(0);
            this.processActions(ma);
        }
        this.updatePose();
        this.func_82168_bl();
        this.npcplayer.field_71070_bA.func_75142_b();
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        switch (poseIn) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return SIZE_BY_POSE.getOrDefault(poseIn, STANDING_SIZE);
    }

    protected void updatePose() {
        if (this.func_213298_c(Pose.SWIMMING)) {
            Pose pose = this.func_184613_cA() ? Pose.FALL_FLYING : (this.func_70608_bn() ? Pose.SLEEPING : (this.func_203007_ba() ? Pose.SWIMMING : (this.func_204805_cN() ? Pose.SPIN_ATTACK : (this.func_225608_bj_() ? Pose.CROUCHING : Pose.STANDING))));
            Pose pose1 = !(this.func_175149_v() || this.func_184218_aH() || this.func_213298_c(pose)) ? (this.func_213298_c(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : pose;
            this.func_213301_b(pose1);
        }
    }

    protected float func_110146_f(float f2, float f3) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(f2 - this.field_70761_aq));
        this.field_70761_aq += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_70761_aq += f1 * 0.2f;
        }
        if (flag) {
            f3 *= -1.0f;
        }
        return f3;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("npc_name", this.getNPCName());
        compound.func_74778_a("texture_name", this.getTextureName());
        compound.func_74778_a("model", this.getModel().toString());
        compound.func_218657_a("settings", (INBT)this.getSettings());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setNPCName(compound.func_74779_i("npc_name"));
        this.setTextureName(compound.func_74779_i("texture_name"));
        this.setModel(new ResourceLocation(compound.func_74779_i("model")));
        this.setSettings(compound.func_74775_l("settings"));
    }

    public LivingEntity GetTargetEntityLiving(int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        LivingEntity target = null;
        AxisAlignedBB area = new AxisAlignedBB(this.func_226277_ct_() - (double)scanRadius, this.func_226278_cu_() - (double)scanRadius, this.func_226281_cx_() - (double)scanRadius, this.func_226277_ct_() + (double)scanRadius, this.func_226278_cu_() + (double)scanRadius, this.func_226281_cx_() + (double)scanRadius);
        List lst = this.field_70170_p.func_72839_b((Entity)this, area);
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (!(ent instanceof LivingEntity) || ent == null || ent.func_174813_aQ() == null) continue;
            float distance = this.func_70032_d(ent) + 0.1f;
            float angle = this.field_70759_as;
            float pitch = this.field_70125_A;
            Vector3d look = this.func_70040_Z();
            Vector3d targetVec = new Vector3d(this.func_226277_ct_() + look.field_72450_a * (double)distance, (double)(this.func_70047_e() / 2.0f) + this.func_226278_cu_() + look.field_72448_b * (double)distance, this.func_226281_cx_() + look.field_72449_c * (double)distance);
            if (!ent.func_174813_aQ().func_72318_a(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (LivingEntity)ent;
        }
        return target;
    }

    public EquipmentSlotType getEquipmentSlotById(int Id) {
        switch (Id) {
            case 0: {
                return EquipmentSlotType.MAINHAND;
            }
            case 1: {
                return EquipmentSlotType.FEET;
            }
            case 2: {
                return EquipmentSlotType.LEGS;
            }
            case 3: {
                return EquipmentSlotType.CHEST;
            }
            case 4: {
                return EquipmentSlotType.HEAD;
            }
            case 5: {
                return EquipmentSlotType.OFFHAND;
            }
        }
        return EquipmentSlotType.LEGS;
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)this)) {
            float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((LivingEntity)this);
                if (this.func_70051_ag() && flag) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(Effects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof LivingEntity;
                flag2 = flag2 && !this.func_70051_ag();
                f += f1;
                boolean flag3 = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (flag && !flag2 && !flag1 && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)this);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d vector3d = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        this.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)this) * f;
                        for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (livingentity == this || livingentity == targetEntity || this.func_184191_r((Entity)livingentity) || livingentity instanceof ArmorStandEntity && ((ArmorStandEntity)livingentity).func_181026_s() || !(this.func_70068_e((Entity)livingentity) < 9.0)) continue;
                            livingentity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            livingentity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f3);
                        }
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(vector3d);
                    }
                    if (flag2) {
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)this, (Entity)targetEntity);
                    ItemStack itemstack1 = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).field_213852_b;
                    }
                    if (!this.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((LivingEntity)entity, this.npcplayer);
                        if (itemstack1.func_190926_b()) {
                            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (this.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.inventory.field_70460_b;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        if (slotIn == EquipmentSlotType.MAINHAND) {
            return this.inventory.func_70448_g();
        }
        if (slotIn == EquipmentSlotType.OFFHAND) {
            return (ItemStack)this.inventory.field_184439_c.get(0);
        }
        return slotIn.func_188453_a() == EquipmentSlotType.Group.ARMOR ? (ItemStack)this.inventory.field_70460_b.get(slotIn.func_188454_b()) : ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlotType.MAINHAND) {
            this.inventory.field_70462_a.set(this.inventory.field_70461_c, (Object)stack);
        } else if (slotIn == EquipmentSlotType.OFFHAND) {
            this.inventory.field_184439_c.set(0, (Object)stack);
        } else if (slotIn.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            this.inventory.field_70460_b.set(slotIn.func_188454_b(), (Object)stack);
        }
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }
}

