/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.events;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmicnpcs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        List<NPCAction> aList;
        if (!event.getWorld().field_72995_K && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(9);
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        List<NPCAction> aList;
        if (!event.getWorld().func_201670_d() && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(8);
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        List<NPCAction> aList;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (!event.getWorld().func_201670_d() && (aList = CosmicNPCs.instance.getActionListForPlayer((PlayerEntity)event.getEntity())) != null) {
            NPCAction ma = new NPCAction(7);
            event.getPlacedBlock().func_177230_c();
            ma.stateId = Block.func_196246_j((BlockState)event.getPlacedBlock());
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getWorld().field_72995_K && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(5);
            ma.arrowCharge = event.getCharge();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getPlayer().field_70170_p.field_72995_K && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(3);
            event.getEntityItem().func_92059_d().func_77955_b(ma.itemData);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onServerChatEvent(ServerChatEvent event) {
        List<NPCAction> aList;
        if (!event.getPlayer().field_70170_p.field_72995_K && (aList = CosmicNPCs.instance.getActionListForPlayer((PlayerEntity)event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(1);
            ma.message = event.getMessage();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onGuiClosing(PlayerContainerEvent.Close event) {
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(10);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        List<NPCAction> aList;
        if (!event.getWorld().field_72995_K && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(11);
            ma.handType = event.getHand();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(12);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(13);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        if (!(((CommandSource)event.getParseResults().getContext().getSource()).func_197022_f() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)((CommandSource)event.getParseResults().getContext().getSource()).func_197022_f();
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
        if (aList != null) {
            NPCAction ma = new NPCAction(14);
            ma.message = event.getParseResults().getReader().getString();
            aList.add(ma);
        }
    }
}

