/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PlayThread
implements Runnable {
    public Thread t;
    CosmicNPCEntity replayEntity;
    DataInputStream in;

    public PlayThread(LivingEntity _player, String recfile) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            String path = "config/cosmicnpcs";
            File file = new File(path + "/recordings");
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                this.in = new DataInputStream(new FileInputStream(file.getAbsolutePath() + "/" + recfile + ".ccap"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            File file = new File("config/cosmicnpcs/recordings");
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                this.in = new DataInputStream(new FileInputStream(file.getAbsolutePath() + "/" + recfile + ".ccap"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
        this.replayEntity = (CosmicNPCEntity)_player;
        this.t = new Thread((Runnable)this, "NPC Playback Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            short magic = this.in.readShort();
            if (magic != -5119) {
                throw new Exception("Not an ccap file.");
            }
            while (true) {
                float yawHead = this.in.readFloat();
                float yaw = this.in.readFloat();
                float pitch = this.in.readFloat();
                double x = this.in.readDouble();
                double y = this.in.readDouble();
                double z = this.in.readDouble();
                double mx = this.in.readDouble();
                double my = this.in.readDouble();
                double mz = this.in.readDouble();
                float fd = this.in.readFloat();
                Boolean iab = this.in.readBoolean();
                Boolean isn = this.in.readBoolean();
                Boolean isp = this.in.readBoolean();
                Boolean iog = this.in.readBoolean();
                Boolean ief = this.in.readBoolean();
                Boolean isSwimming = this.in.readBoolean();
                Boolean isHandActive = this.in.readBoolean();
                Hand handType = Hand.values()[this.in.readInt()];
                Boolean ir = false;
                this.replayEntity.field_70160_al = iab;
                this.replayEntity.func_213293_j(mx, my, mz);
                this.replayEntity.field_70143_R = fd;
                this.replayEntity.func_226284_e_(isn);
                this.replayEntity.func_70031_b(isp);
                this.replayEntity.func_230245_c_(iog);
                this.replayEntity.setElytraFlying(ief);
                this.replayEntity.func_70080_a(x, y, z, yaw, pitch);
                this.replayEntity.func_70034_d(yawHead);
                if (isHandActive.booleanValue()) {
                    this.replayEntity.func_184598_c(handType);
                } else {
                    this.replayEntity.func_184602_cy();
                }
                Boolean hasAction = this.in.readBoolean();
                if (hasAction.booleanValue()) {
                    byte type = this.in.readByte();
                    switch (type) {
                        case 1: {
                            String msg = this.in.readUTF();
                            NPCAction ma = new NPCAction(1);
                            ma.message = msg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 4: {
                            NPCAction ma = new NPCAction(4);
                            int aSlot = this.in.readInt();
                            int aId = this.in.readInt();
                            int aDmg = this.in.readInt();
                            if (aId != -1) {
                                ma.itemData = CompressedStreamTools.func_74794_a((DataInput)this.in);
                            }
                            ma.armorSlot = aSlot;
                            ma.armorId = aId;
                            ma.armorDmg = aDmg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 2: {
                            NPCAction ma = new NPCAction(2);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 3: {
                            NPCAction ma = new NPCAction(3);
                            ma.itemData = CompressedStreamTools.func_74794_a((DataInput)this.in);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 5: {
                            int aCharge = this.in.readInt();
                            NPCAction ma = new NPCAction(5);
                            ma.arrowCharge = aCharge;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 8: {
                            NPCAction ma = new NPCAction(8);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 7: {
                            NPCAction ma = new NPCAction(7);
                            ma.stateId = this.in.readInt();
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 9: {
                            NPCAction ma = new NPCAction(9);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            ma.metaData = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 10: {
                            NPCAction ma = new NPCAction(10);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 11: {
                            NPCAction ma = new NPCAction(11);
                            ma.handType = Hand.values()[this.in.readByte()];
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 12: {
                            NPCAction ma = new NPCAction(12);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 13: {
                            NPCAction ma = new NPCAction(13);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 14: {
                            String msg = this.in.readUTF();
                            NPCAction ma = new NPCAction(14);
                            ma.message = msg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                    }
                }
                Thread.sleep(25L);
            }
        }
        catch (EOFException magic) {
        }
        catch (Exception e) {
            System.out.println("Replay thread interrupted");
            CosmicNPCs.instance.broadcastMsg("Error loading ccap file, not a ccap file.");
            e.printStackTrace();
        }
        this.replayEntity.func_70106_y();
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

