/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class RecordThread
implements Runnable {
    public Thread t;
    PlayerEntity player;
    public Boolean capture = false;
    RandomAccessFile in;
    Boolean lastTickSwipe = false;
    int[] itemsEquipped = new int[6];
    CompoundNBT[] equipedItemsData = new CompoundNBT[6];
    List<NPCAction> eventList;

    public RecordThread(PlayerEntity _player, String capname) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            String path = "config/cosmicnpcs";
            File file = new File(path + "/recordings");
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                this.in = new RandomAccessFile(file.getAbsolutePath() + "/" + capname + ".ccap", "rw");
                this.in.setLength(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            File file = new File("config/cosmicnpcs/recordings");
            if (!file.exists()) {
                file.mkdir();
            }
            try {
                this.in = new RandomAccessFile(file.getAbsolutePath() + "/" + capname + ".ccap", "rw");
                this.in.setLength(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.player = _player;
        this.capture = true;
        this.eventList = CosmicNPCs.instance.getActionListForPlayer(this.player);
        this.t = new Thread((Runnable)this, "NPC Record Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            this.in.writeShort(60417);
            while (this.capture.booleanValue()) {
                this.trackAndWriteMovement();
                this.trackSwing();
                this.trackHeldItem();
                this.trackHeldItemOffhand();
                this.trackArmor();
                this.writeActions();
                Thread.sleep(25L);
                if (!this.player.func_233643_dh_()) continue;
                this.capture = false;
                CosmicNPCs.instance.recordThreads.remove(this.player);
                CosmicNPCs.instance.broadcastMsg("Stopped recording " + this.player.func_145748_c_() + ". RIP.");
            }
            this.in.close();
        }
        catch (InterruptedException e) {
            System.out.println("Child interrupted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Exiting child thread.");
    }

    private void trackAndWriteMovement() throws IOException {
        this.in.writeFloat(this.player.field_70759_as);
        this.in.writeFloat(this.player.field_70177_z);
        this.in.writeFloat(this.player.field_70125_A);
        this.in.writeDouble(this.player.func_226277_ct_());
        this.in.writeDouble(this.player.func_226278_cu_());
        this.in.writeDouble(this.player.func_226281_cx_());
        this.in.writeDouble(this.player.func_213322_ci().field_72450_a);
        this.in.writeDouble(this.player.func_213322_ci().field_72448_b);
        this.in.writeDouble(this.player.func_213322_ci().field_72449_c);
        this.in.writeFloat(this.player.field_70143_R);
        this.in.writeBoolean(this.player.field_70160_al);
        this.in.writeBoolean(this.player.func_225608_bj_());
        this.in.writeBoolean(this.player.func_70051_ag());
        this.in.writeBoolean(this.player.func_233570_aj_());
        this.in.writeBoolean(this.player.func_184613_cA());
        this.in.writeBoolean(this.player.func_203007_ba());
        if (this.player.func_184587_cr()) {
            this.in.writeBoolean(this.player.func_184587_cr());
            this.in.writeInt(this.player.func_184600_cs() == Hand.MAIN_HAND ? 0 : 1);
        } else {
            this.in.writeBoolean(this.player.func_184587_cr());
            this.in.writeInt(0);
        }
    }

    private void trackArmor() {
        for (int ci = 1; ci < 5; ++ci) {
            NPCAction ma;
            ItemStack playerArmorPiece = (ItemStack)this.player.field_71071_by.field_70460_b.get(ci - 1);
            if (playerArmorPiece != null) {
                if (Item.func_150891_b((Item)playerArmorPiece.func_77973_b()) == this.itemsEquipped[ci] && playerArmorPiece.serializeNBT().equals((Object)this.equipedItemsData[ci])) continue;
                this.itemsEquipped[ci] = Item.func_150891_b((Item)playerArmorPiece.func_77973_b());
                this.equipedItemsData[ci] = playerArmorPiece.serializeNBT();
                ma = new NPCAction(4);
                ma.armorSlot = ci;
                ma.armorId = this.itemsEquipped[ci];
                ma.armorDmg = playerArmorPiece.func_77952_i();
                playerArmorPiece.func_77955_b(ma.itemData);
                this.eventList.add(ma);
                continue;
            }
            if (this.itemsEquipped[ci] == -1) continue;
            this.itemsEquipped[ci] = -1;
            this.equipedItemsData[ci] = new CompoundNBT();
            ma = new NPCAction(4);
            ma.armorSlot = ci;
            ma.armorId = this.itemsEquipped[ci];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItem() {
        ItemStack playerHeldItem = this.player.func_184586_b(Hand.MAIN_HAND);
        if (!playerHeldItem.func_190926_b()) {
            if (Item.func_150891_b((Item)playerHeldItem.func_77973_b()) != this.itemsEquipped[0] || !playerHeldItem.serializeNBT().equals((Object)this.equipedItemsData[0])) {
                this.itemsEquipped[0] = Item.func_150891_b((Item)playerHeldItem.func_77973_b());
                this.equipedItemsData[0] = playerHeldItem.serializeNBT();
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 0;
                ma.armorId = this.itemsEquipped[0];
                ma.armorDmg = playerHeldItem.func_77952_i();
                playerHeldItem.func_77955_b(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[0] != -1) {
            this.itemsEquipped[0] = -1;
            this.equipedItemsData[0] = new CompoundNBT();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 0;
            ma.armorId = this.itemsEquipped[0];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItemOffhand() {
        ItemStack playerHeldItem = this.player.func_184586_b(Hand.OFF_HAND);
        if (!playerHeldItem.func_190926_b()) {
            if (Item.func_150891_b((Item)playerHeldItem.func_77973_b()) != this.itemsEquipped[5] || !playerHeldItem.serializeNBT().equals((Object)this.equipedItemsData[5])) {
                this.itemsEquipped[5] = Item.func_150891_b((Item)playerHeldItem.func_77973_b());
                this.equipedItemsData[5] = playerHeldItem.serializeNBT();
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 5;
                ma.armorId = this.itemsEquipped[5];
                ma.armorDmg = playerHeldItem.func_77952_i();
                playerHeldItem.func_77955_b(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[5] != -1) {
            this.itemsEquipped[5] = -1;
            this.equipedItemsData[0] = new CompoundNBT();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 5;
            ma.armorId = this.itemsEquipped[5];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackSwing() {
        if (this.player.field_110158_av == -1) {
            this.eventList.add(new NPCAction(2));
        }
    }

    private void writeActions() throws IOException {
        if (this.eventList.size() > 0) {
            this.in.writeBoolean(true);
            NPCAction ma = this.eventList.get(0);
            this.in.writeByte(ma.type);
            switch (ma.type) {
                case 1: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    CompressedStreamTools.func_74800_a((CompoundNBT)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 4: {
                    this.in.writeInt(ma.armorSlot);
                    this.in.writeInt(ma.armorId);
                    this.in.writeInt(ma.armorDmg);
                    if (ma.armorId == -1) break;
                    CompressedStreamTools.func_74800_a((CompoundNBT)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 5: {
                    this.in.writeInt(ma.arrowCharge);
                    break;
                }
                case 7: {
                    this.in.writeInt(ma.stateId);
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 8: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 9: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    this.in.writeInt(ma.metaData);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.in.writeByte((byte)ma.handType.ordinal());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 6: {
                    CosmicNPCs.instance.recordThreads.remove(this.player);
                    CosmicNPCs.instance.broadcastMsg("Stopped recording " + this.player.func_145748_c_() + ". Bye!");
                    this.capture = false;
                }
            }
            this.eventList.remove(0);
        } else {
            this.in.writeBoolean(false);
        }
    }
}

