/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class NPCPlayCommand {
    static ArrayList<PlayThread> playThreads = new ArrayList();

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"npc-play").then(Commands.m_82129_((String)"file", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.REC_FILES).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), new ResourceLocation("minecraft:player"), new CompoundTag(), (CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSourceStack>)context, "model"), new CompoundTag(), (CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"settings", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSourceStack>)context, "model"), CompoundTagArgument.m_87660_((CommandContext)context, (String)"settings"), (CommandSourceStack)context.getSource())))))));
    }

    private static int play(String fileNameIn, String npcName, String textureName, ResourceLocation model, CompoundTag compound, CommandSourceStack source) {
        File file = null;
        String path = "config/cosmicnpcs";
        file = new File(path + "/recordings/" + fileNameIn + ".ccap");
        if (!file.exists()) {
            source.m_81352_((Component)new TextComponent("Can't find " + fileNameIn + ".ccap file!"));
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yawHead = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            if (magic != -5119) {
                in.close();
                source.m_81352_((Component)new TextComponent(fileNameIn + " isn't a .ccap file."));
            }
            yawHead = in.readFloat();
            yaw = in.readFloat();
            pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServerLevel world = source.m_81372_();
        CosmicNPCEntity npc = (CosmicNPCEntity)((EntityType)EntityTypesInit.COSMIC_NPC.get()).m_20615_((Level)world);
        int showNameTagDefaultValue = 0;
        if (model.equals((Object)new ResourceLocation("minecraft:player")) || model.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            showNameTagDefaultValue = 1;
        }
        CompoundTag settings = npc.getSettings();
        settings.m_128405_("ShowNameTag", compound.m_128441_("ShowNameTag") ? compound.m_128451_("ShowNameTag") : showNameTagDefaultValue);
        settings.m_128379_("Invulnerable", compound.m_128441_("Invulnerable") ? compound.m_128471_("Invulnerable") : false);
        settings.m_128379_("UseCommands", compound.m_128441_("UseCommands") ? compound.m_128471_("UseCommands") : false);
        settings.m_128379_("IsChild", compound.m_128441_("IsChild") ? compound.m_128471_("IsChild") : false);
        settings.m_128359_("Layer", compound.m_128441_("Layer") ? compound.m_128461_("Layer").toLowerCase(Locale.ROOT) : "default");
        settings.m_128359_("VillagerType", compound.m_128441_("VillagerType") ? compound.m_128461_("VillagerType") : "default");
        settings.m_128359_("Profession", compound.m_128441_("Profession") ? compound.m_128461_("Profession") : "default");
        settings.m_128359_("ProfessionLevel", compound.m_128441_("ProfessionLevel") ? compound.m_128461_("ProfessionLevel") : "default");
        if (compound.m_128425_("ProfessionLevel", 99)) {
            settings.m_128405_("ProfessionLevel", compound.m_128441_("ProfessionLevel") ? compound.m_128451_("ProfessionLevel") : 1);
        }
        settings.m_128359_("Color", compound.m_128441_("Color") ? compound.m_128461_("Color") : "default");
        settings.m_128379_("Sheared", compound.m_128441_("Sheared") ? compound.m_128471_("Sheared") : false);
        settings.m_128359_("MushroomBlock", compound.m_128441_("MushroomBlock") ? compound.m_128461_("MushroomBlock") : "default");
        settings.m_128379_("Charged", compound.m_128441_("Charged") ? compound.m_128471_("Charged") : false);
        settings.m_128359_("Armor", compound.m_128441_("Armor") ? compound.m_128461_("Armor") : "default");
        settings.m_128379_("Saddled", compound.m_128441_("Saddled") ? compound.m_128471_("Saddled") : false);
        settings.m_128359_("Head", compound.m_128441_("Head") ? compound.m_128461_("Head") : "default");
        npc.m_6034_(x, y, z);
        npc.f_20885_ = yawHead;
        npc.m_146922_(yaw);
        npc.m_146926_(pitch);
        npc.setNPCName(npcName);
        npc.setTextureName(textureName);
        npc.setModel(model);
        npc.setSettings(settings);
        if (settings.m_128451_("ShowNameTag") >= 1) {
            npc.m_6593_((Component)new TextComponent(npcName));
        } else {
            npc.m_6593_((Component)((BaseComponent)null));
        }
        if (settings.m_128451_("ShowNameTag") == 1) {
            npc.m_20340_(true);
        } else {
            npc.m_20340_(false);
        }
        npc.m_20331_(settings.m_128471_("Invulnerable"));
        world.m_7967_((Entity)npc);
        Iterator<PlayThread> iterator = playThreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playThreads.add(new PlayThread(npc, fileNameIn));
        return 1;
    }
}

