/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class CosmicNPCEntity
extends LivingEntity {
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SLEEPING, (Object)f_20910_).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntityDimensions.m_20398_((float)0.2f, (float)0.2f)).build();
    private static final EntityDataAccessor<String> NPC_NAME = SynchedEntityData.m_135353_(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.m_135353_(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> MODEL_NAME = SynchedEntityData.m_135353_(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> LAYER_TEXTURE = SynchedEntityData.m_135353_(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> SETTINGS = SynchedEntityData.m_135353_(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private FakePlayer fakePlayer;
    protected ItemStack lastActiveItemStack = ItemStack.f_41583_;
    public ArrayList<PlayThread> playThreads;
    public String recFile = "";
    public List<NPCAction> eventsList = Collections.synchronizedList(new ArrayList());
    public final Inventory inventory = new Inventory((Player)this.fakePlayer);

    public CosmicNPCEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
        if (!this.f_19853_.m_5776_()) {
            this.fakePlayer = new FakePlayer((ServerLevel)this.f_19853_, new GameProfile(this.f_19820_, "NPCFakePlayer"));
        }
        this.f_19804_.m_135372_(NPC_NAME, (Object)"CosmicNPC");
        this.f_19804_.m_135372_(TEXTURE_NAME, (Object)"default");
        this.f_19804_.m_135372_(MODEL_NAME, (Object)"player");
        this.f_19804_.m_135372_(LAYER_TEXTURE, (Object)"default");
        this.f_19804_.m_135372_(SETTINGS, (Object)new CompoundTag());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22266_(Attributes.f_22283_).m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_);
    }

    public void setNPCName(String npcName) {
        this.f_19804_.m_135381_(NPC_NAME, (Object)npcName);
    }

    public String getNPCName() {
        return (String)this.f_19804_.m_135370_(NPC_NAME);
    }

    public void setTextureName(String textureName) {
        this.f_19804_.m_135381_(TEXTURE_NAME, (Object)textureName.toLowerCase(Locale.ROOT));
    }

    public String getTextureName() {
        return (String)this.f_19804_.m_135370_(TEXTURE_NAME);
    }

    public void setModel(ResourceLocation model) {
        this.f_19804_.m_135381_(MODEL_NAME, (Object)model.toString());
    }

    public ResourceLocation getModel() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(MODEL_NAME));
    }

    public void setSettings(CompoundTag settings) {
        this.f_19804_.m_135381_(SETTINGS, (Object)settings);
    }

    public CompoundTag getSettings() {
        return (CompoundTag)this.f_19804_.m_135370_(SETTINGS);
    }

    public void setElytraFlying(boolean isElytraFlying) {
        this.m_20115_(7, isElytraFlying);
    }

    public void startActions(ArrayList<PlayThread> playthreads, String recFile) {
        Iterator<PlayThread> iterator = playthreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playthreads.add(new PlayThread(this, recFile));
    }

    private void replayShootArrow(NPCAction ma) {
        float f = (float)ma.arrowCharge / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        ArrowItem arrow = (ArrowItem)new ItemStack((ItemLike)Items.f_42412_).m_41720_();
        AbstractArrow entityarrow = arrow.m_6394_(this.f_19853_, this.m_21211_(), (LivingEntity)this);
        entityarrow.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            entityarrow.m_36762_(true);
        }
        this.f_19853_.m_7967_((Entity)entityarrow);
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (this.f_19796_.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    private void processActions(NPCAction ma) {
        switch (ma.type) {
            case 1: {
                List temp = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
                for (ServerPlayer player : temp) {
                    TextComponent cmp = new TextComponent("<" + this.getNPCName() + "> " + ma.message);
                    player.m_6352_((Component)cmp, Util.f_137441_);
                }
                break;
            }
            case 2: {
                this.m_6674_(InteractionHand.MAIN_HAND);
                LivingEntity mop = this.GetTargetEntityLiving(5);
                if (mop == null) break;
                this.m_7327_((Entity)mop);
                this.attack((Entity)mop);
                break;
            }
            case 4: {
                if (ma.armorId == -1) {
                    this.m_8061_(this.getEquipmentSlotById(ma.armorSlot), ItemStack.f_41583_);
                    break;
                }
                ItemStack loadedEquip = ItemStack.m_41712_((CompoundTag)ma.itemData);
                this.m_8061_(this.getEquipmentSlotById(ma.armorSlot), loadedEquip);
                break;
            }
            case 3: {
                ItemStack droppedItem = ItemStack.m_41712_((CompoundTag)ma.itemData);
                double d0 = this.m_20188_() - (double)0.3f;
                ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), d0, this.m_20189_(), droppedItem);
                itementity.m_32010_(40);
                float f7 = 0.3f;
                float f8 = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float f2 = Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f4 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f5 = this.f_19796_.nextFloat() * ((float)Math.PI * 2);
                float f6 = 0.02f * this.f_19796_.nextFloat();
                itementity.m_20334_((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                this.f_19853_.m_7967_((Entity)itementity);
                break;
            }
            case 5: {
                this.replayShootArrow(ma);
                break;
            }
            case 8: {
                BlockState block = this.f_19853_.m_8055_(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (block == Blocks.f_50016_.m_49966_()) break;
                this.f_19853_.m_46796_(2001, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Block.m_49956_((BlockState)block));
                this.f_19853_.m_46597_(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Blocks.f_50016_.m_49966_());
                block.m_60734_().m_5707_(this.f_19853_, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block, (Player)this.fakePlayer);
                break;
            }
            case 7: {
                BlockEntity blockEntity;
                BlockState block = Block.m_49803_((int)ma.stateId);
                this.f_19853_.m_46597_(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block);
                if (block.m_60734_() instanceof DoorBlock) {
                    BlockState upperDoor = (BlockState)block.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER);
                    this.f_19853_.m_46597_(new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), upperDoor);
                }
                if (block.m_60734_() instanceof SignBlock && (blockEntity = this.f_19853_.m_7702_(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord))) instanceof SignBlockEntity) {
                    SignBlockEntity sign = (SignBlockEntity)blockEntity;
                    sign.m_142466_(ma.itemData);
                }
                SoundType soundtype = block.m_60734_().getSoundType(block, (LevelReader)this.f_19853_, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), (Entity)this);
                this.f_19853_.m_5594_(null, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                break;
            }
            case 9: {
                BlockState aBlock = this.f_19853_.m_8055_(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (aBlock == Blocks.f_50016_.m_49966_()) break;
                aBlock.m_60664_(this.f_19853_, (Player)this.fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(this.m_20154_(), this.m_6350_(), new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), false));
                break;
            }
            case 10: {
                this.fakePlayer.f_36096_.m_6877_((Player)this.fakePlayer);
                this.fakePlayer.f_36096_ = this.fakePlayer.f_36095_;
                break;
            }
            case 11: {
                this.m_21120_(ma.handType).m_41720_().m_7203_(this.f_19853_, (Player)this.fakePlayer, ma.handType);
                this.lastActiveItemStack = this.m_21120_(ma.handType);
                break;
            }
            case 12: {
                this.lastActiveItemStack.m_41671_(this.f_19853_, (LivingEntity)this);
                this.lastActiveItemStack = ItemStack.f_41583_;
                break;
            }
            case 13: {
                this.lastActiveItemStack.m_41720_().m_5551_(this.lastActiveItemStack, this.f_19853_, (LivingEntity)this.fakePlayer, 0);
                this.lastActiveItemStack = ItemStack.f_41583_;
                break;
            }
            case 14: {
                if (!this.getSettings().m_128471_("UseCommands")) break;
                this.m_20194_().m_129892_().m_82117_(this.m_20203_().m_81324_().m_81358_(5), ma.message);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.eventsList.size() > 0) {
            NPCAction ma = this.eventsList.remove(0);
            this.processActions(ma);
        }
        this.updatePose();
        this.m_21203_();
        if (this.fakePlayer != null) {
            this.fakePlayer.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.fakePlayer.m_146922_(this.m_146908_());
            this.fakePlayer.m_146926_(this.m_146909_());
            this.fakePlayer.f_20885_ = this.f_20885_;
            this.fakePlayer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.m_41712_((CompoundTag)this.m_21205_().serializeNBT()));
            this.fakePlayer.m_8061_(EquipmentSlot.OFFHAND, ItemStack.m_41712_((CompoundTag)this.m_21206_().serializeNBT()));
        }
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        switch (poseIn) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return POSES.getOrDefault(poseIn, STANDING_DIMENSIONS);
    }

    protected void updatePose() {
        if (this.m_20175_(Pose.SWIMMING)) {
            Pose pose = this.m_21255_() ? Pose.FALL_FLYING : (this.m_5803_() ? Pose.SLEEPING : (this.m_6069_() ? Pose.SWIMMING : (this.m_21209_() ? Pose.SPIN_ATTACK : (this.m_6144_() ? Pose.CROUCHING : Pose.STANDING))));
            Pose pose1 = !(this.m_5833_() || this.m_20159_() || this.m_20175_(pose)) ? (this.m_20175_(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : pose;
            this.m_20124_(pose1);
        }
    }

    protected float m_5632_(float f2, float f3) {
        boolean flag;
        float f = Mth.m_14177_((float)(f2 - this.f_20883_));
        this.f_20883_ += f * 0.3f;
        float f1 = Mth.m_14177_((float)(this.m_146908_() - this.f_20883_));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.f_20883_ = this.m_146908_() - f1;
        if (f1 * f1 > 2500.0f) {
            this.f_20883_ += f1 * 0.2f;
        }
        if (flag) {
            f3 *= -1.0f;
        }
        return f3;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("npc_name", this.getNPCName());
        compound.m_128359_("texture_name", this.getTextureName());
        compound.m_128359_("model", this.getModel().toString());
        compound.m_128365_("settings", (Tag)this.getSettings());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setNPCName(compound.m_128461_("npc_name"));
        this.setTextureName(compound.m_128461_("texture_name"));
        this.setModel(new ResourceLocation(compound.m_128461_("model")));
        this.setSettings(compound.m_128469_("settings"));
    }

    public LivingEntity GetTargetEntityLiving(int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        LivingEntity target = null;
        AABB area = new AABB(this.m_20185_() - (double)scanRadius, this.m_20186_() - (double)scanRadius, this.m_20189_() - (double)scanRadius, this.m_20185_() + (double)scanRadius, this.m_20186_() + (double)scanRadius, this.m_20189_() + (double)scanRadius);
        List lst = this.f_19853_.m_45933_((Entity)this, area);
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (!(ent instanceof LivingEntity) || ent == null || ent.m_142469_() == null) continue;
            float distance = this.m_20270_(ent) + 0.1f;
            float angle = this.f_20885_;
            float pitch = this.m_146909_();
            Vec3 look = this.m_20154_();
            Vec3 targetVec = new Vec3(this.m_20185_() + look.f_82479_ * (double)distance, (double)(this.m_20192_() / 2.0f) + this.m_20186_() + look.f_82480_ * (double)distance, this.m_20189_() + look.f_82481_ * (double)distance);
            if (!ent.m_142469_().m_82390_(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (LivingEntity)ent;
        }
        return target;
    }

    public EquipmentSlot getEquipmentSlotById(int Id) {
        switch (Id) {
            case 0: {
                return EquipmentSlot.MAINHAND;
            }
            case 1: {
                return EquipmentSlot.FEET;
            }
            case 2: {
                return EquipmentSlot.LEGS;
            }
            case 3: {
                return EquipmentSlot.CHEST;
            }
            case 4: {
                return EquipmentSlot.HEAD;
            }
            case 5: {
                return EquipmentSlot.OFFHAND;
            }
        }
        return EquipmentSlot.LEGS;
    }

    public void attack(Entity targetEntity) {
        if (targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)this)) {
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)MobType.f_21640_);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.m_44894_((LivingEntity)this);
                if (this.m_20142_() && flag) {
                    this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12314_, this.m_5720_(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.f_19789_ > 0.0f && !this.f_19861_ && !this.m_6147_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19610_) && !this.m_20159_() && targetEntity instanceof LivingEntity;
                flag2 = flag2 && !this.m_20142_();
                f += f1;
                boolean flag3 = false;
                double d0 = this.f_19787_ - this.f_19867_;
                if (flag && !flag2 && !flag1 && this.f_19861_ && d0 < (double)this.m_6113_() && (itemstack = this.m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_((LivingEntity)this);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).m_21223_();
                    if (j > 0 && !targetEntity.m_6060_()) {
                        flag4 = true;
                        targetEntity.m_20254_(1);
                    }
                }
                Vec3 vector3d = targetEntity.m_20184_();
                boolean flag5 = targetEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        this.m_6858_(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)this) * f;
                        for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, targetEntity.m_142469_().m_82377_(1.0, 0.25, 1.0))) {
                            if (livingentity == this || livingentity == targetEntity || this.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(this.m_20280_((Entity)livingentity) < 9.0)) continue;
                            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                            livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this), f3);
                        }
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
                    }
                    if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                        ((ServerPlayer)targetEntity).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.f_19864_ = false;
                        targetEntity.m_20256_(vector3d);
                    }
                    if (flag2) {
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, this.m_5720_(), 1.0f, 1.0f);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12316_, this.m_5720_(), 1.0f, 1.0f);
                        } else {
                            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12318_, this.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    this.m_21335_(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)this, (Entity)targetEntity);
                    ItemStack itemstack1 = this.m_21205_();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPart) {
                        entity = ((EnderDragonPart)targetEntity).f_31010_;
                    }
                    if (!this.f_19853_.f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.m_41777_();
                        itemstack1.m_41640_((LivingEntity)entity, (Player)this.fakePlayer);
                        if (itemstack1.m_41619_()) {
                            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).m_21223_();
                        if (j > 0) {
                            targetEntity.m_20254_(j * 4);
                        }
                        if (this.f_19853_ instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.m_20095_();
                    }
                }
            }
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return this.inventory.f_35975_;
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            return this.inventory.m_36056_();
        }
        if (slotIn == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.inventory.f_35976_.get(0);
        }
        return slotIn.m_20743_() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.inventory.f_35975_.get(slotIn.m_20749_()) : ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            this.inventory.f_35974_.set(this.inventory.f_35977_, (Object)stack);
        } else if (slotIn == EquipmentSlot.OFFHAND) {
            this.inventory.f_35976_.set(0, (Object)stack);
        } else if (slotIn.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.inventory.f_35975_.set(slotIn.m_20749_(), (Object)stack);
        }
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }
}

