/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.npcsystem;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.entity.EntityNPC;
import de.namensammler.cosmicnpcs.npcsystem.NPCAction;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.CompressedStreamTools;

public class PlayThread
implements Runnable {
    public Thread t;
    EntityNPC replayEntity;
    DataInputStream in;

    public PlayThread(EntityLiving _player, String recfile) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        try {
            if (side == Side.CLIENT) {
                String path = CosmicNPCs.config.getConfigFile().getAbsolutePath();
                path = path.substring(0, path.length() - 4 - 10);
                File file = new File(path + "/recordings");
                this.in = new DataInputStream(new FileInputStream(file.getAbsolutePath() + "/" + recfile + ".action"));
            } else if (side == Side.SERVER) {
                File file = new File("config/cosmicnpcs/recordings");
                this.in = new DataInputStream(new FileInputStream(file.getAbsolutePath() + "/" + recfile + ".action"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.replayEntity = (EntityNPC)_player;
        this.t = new Thread((Runnable)this, "NPC Playback Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            short magic = this.in.readShort();
            if (magic != -5119) {
                throw new Exception("Not an action file.");
            }
            while (true) {
                float yaw = this.in.readFloat();
                float pitch = this.in.readFloat();
                double x = this.in.readDouble();
                double y = this.in.readDouble();
                double z = this.in.readDouble();
                double mx = this.in.readDouble();
                double my = this.in.readDouble();
                double mz = this.in.readDouble();
                float fd = this.in.readFloat();
                Boolean iab = this.in.readBoolean();
                Boolean isn = this.in.readBoolean();
                Boolean isp = this.in.readBoolean();
                Boolean iog = this.in.readBoolean();
                Boolean ie = this.in.readBoolean();
                this.replayEntity.field_70160_al = iab;
                this.replayEntity.field_70159_w = mx;
                this.replayEntity.field_70181_x = my;
                this.replayEntity.field_70179_y = mz;
                this.replayEntity.field_70143_R = fd;
                this.replayEntity.func_70095_a(isn);
                this.replayEntity.func_70031_b(isp);
                this.replayEntity.field_70122_E = iog;
                this.replayEntity.func_70080_a(x, y, z, yaw, pitch);
                this.replayEntity.func_70019_c(ie);
                Boolean hasAction = this.in.readBoolean();
                if (hasAction.booleanValue()) {
                    byte type = this.in.readByte();
                    switch (type) {
                        case 1: {
                            String msg = this.in.readUTF();
                            NPCAction ma = new NPCAction(1);
                            ma.message = msg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 4: {
                            NPCAction ma = new NPCAction(4);
                            int aSlot = this.in.readInt();
                            int aId = this.in.readInt();
                            int aDmg = this.in.readInt();
                            if (aId != -1) {
                                ma.itemData = CompressedStreamTools.func_74794_a((DataInputStream)this.in);
                            }
                            ma.armorSlot = aSlot;
                            ma.armorId = aId;
                            ma.armorDmg = aDmg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 2: {
                            NPCAction ma = new NPCAction(2);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 3: {
                            NPCAction ma = new NPCAction(3);
                            ma.itemData = CompressedStreamTools.func_74794_a((DataInputStream)this.in);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 5: {
                            int aCharge = this.in.readInt();
                            NPCAction ma = new NPCAction(5);
                            ma.arrowCharge = aCharge;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 8: {
                            NPCAction ma = new NPCAction(8);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 7: {
                            NPCAction ma = new NPCAction(7);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            ma.itemData = CompressedStreamTools.func_74794_a((DataInputStream)this.in);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 9: {
                            NPCAction ma = new NPCAction(9);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            ma.metaData = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                    }
                }
                Thread.sleep(50L);
            }
        }
        catch (EOFException magic) {
        }
        catch (Exception e) {
            System.out.println("Replay thread interrupted.");
            CosmicNPCs.instance.broadcastMsg("Error loading action file, not an action file.");
            e.printStackTrace();
        }
        this.replayEntity.func_70106_y();
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

