/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.client.gui.GuiCommandScreen;
import de.namensammler.cosmicnpcs.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.proxy.ClientProxy;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CosmicEvents {
    public static String[] command = new String[100];
    public static int commandCounter = 1;

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntityPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(9);
            World worldObj = event.getWorld();
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(8);
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(7);
            event.getPlacedBlock().func_177230_c();
            ma.stateId = Block.func_176210_f((IBlockState)event.getPlacedBlock());
            ma.xCoord = event.getPos().func_177958_n();
            ma.yCoord = event.getPos().func_177956_o();
            ma.zCoord = event.getPos().func_177952_p();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent event) throws IOException {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntityPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(5);
            ma.arrowCharge = event.getCharge();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onItemTossEvent(ItemTossEvent event) throws IOException {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(3);
            event.getEntityItem().func_92059_d().func_77955_b(ma.itemData);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer((EntityPlayer)event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(1);
            ma.message = event.getMessage();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onGuiClosing(PlayerContainerEvent.Close event) {
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntityPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(10);
            System.out.println("Blub");
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntityPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(11);
            ma.handType = event.getHand();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
        if (aList != null) {
            NPCAction ma = new NPCAction(12);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side != Side.SERVER) {
            return;
        }
        if (!(event.getSender() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSender();
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
        if (aList != null) {
            NPCAction ma = new NPCAction(13);
            String command = "/" + event.getCommand().func_71517_b();
            for (String value : event.getParameters()) {
                command = command + " " + value;
            }
            ma.message = command;
            aList.add(ma);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onEvent(InputEvent.KeyInputEvent event) {
        KeyBinding[] keyBindings = ClientProxy.keyBindings;
        if (keyBindings[0].func_151468_f() && command[commandCounter] != null) {
            if (command[commandCounter].startsWith("/")) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(command[commandCounter]);
                ++commandCounter;
            } else {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/" + command[commandCounter]);
                ++commandCounter;
            }
        }
        if (keyBindings[1].func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCommandScreen());
        }
    }
}

