/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.command;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPC;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPCChicken;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPCSlim;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPCVex;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPCVillager;
import de.namensammler.cosmicnpcs.entity.EntityCosmicNPCWitch;
import de.namensammler.cosmicnpcs.npcsystem.PlayThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class CommandNPCPlay
extends CommandBase {
    ArrayList<PlayThread> playThreads = new ArrayList();

    public String func_71517_b() {
        return "npc-play";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /npc-play <file> <name> <texture> [model], eg: /npc-play leyla1 Leyla leyla";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            CosmicNPCs.instance.broadcastMsg(this.func_71518_a(sender));
            return;
        }
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        File file = null;
        if (side == Side.CLIENT) {
            String path = CosmicNPCs.config.getConfigFile().getAbsolutePath();
            file = new File((path = path.substring(0, path.length() - 4 - 10)) + "/recordings/" + args[0] + ".ccap");
            if (!file.exists()) {
                CosmicNPCs.instance.broadcastMsg("Can't find " + args[0] + ".ccap file!");
                return;
            }
        } else if (side == Side.SERVER && !(file = new File("config/cosmicnpcs/recordings/" + args[0] + ".ccap")).exists()) {
            CosmicNPCs.instance.broadcastMsg("Can't find " + args[0] + ".ccap file!");
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            if (magic != -5119) {
                CosmicNPCs.instance.broadcastMsg(args[0] + " isn't a .ccap file.");
                in.close();
                return;
            }
            float yawHead = in.readFloat();
            float yaw = in.readFloat();
            float pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        World world = sender.func_130014_f_();
        if (args[1] != null && args[2] != null) {
            EntityCosmicNPC entity = new EntityCosmicNPC(world);
            int showNameTag = 1;
            boolean invulnerable = false;
            if (args.length > 3) {
                String subArgs;
                if (args.length > 4 && (subArgs = args[4]).startsWith("{") && subArgs.endsWith("}")) {
                    int i;
                    subArgs = subArgs.substring(1);
                    int subArgLength = subArgs.length() - subArgs.replace(",", "").length() + 1;
                    String[] subArgsArray = new String[subArgLength];
                    for (i = 0; i < subArgLength; ++i) {
                        int subArgIndex = subArgs.indexOf(",");
                        if (i == subArgLength - 1) {
                            subArgIndex = subArgs.indexOf("}");
                        }
                        subArgsArray[i] = subArgs.substring(0, subArgIndex);
                        subArgs = subArgs.substring(subArgIndex);
                        subArgs = subArgs.substring(1);
                    }
                    block28: for (i = 0; i < subArgsArray.length; ++i) {
                        int splitIndex = subArgsArray[i].indexOf(":");
                        if (splitIndex < 0) {
                            CosmicNPCs.instance.broadcastMsg("Error: Unknown Sub Arguments '" + args[4] + "'");
                            return;
                        }
                        String tag = subArgsArray[i].substring(0, splitIndex);
                        String setting = subArgsArray[i].substring(splitIndex + 1);
                        switch (tag) {
                            case "ShowNameTag": {
                                if (setting.equals("1")) {
                                    showNameTag = 1;
                                    continue block28;
                                }
                                if (setting.equals("0")) {
                                    showNameTag = 0;
                                    continue block28;
                                }
                                if (!setting.equals("2")) continue block28;
                                showNameTag = 2;
                                continue block28;
                            }
                            case "Invulnerable": {
                                if (setting.equals("1")) {
                                    invulnerable = true;
                                    continue block28;
                                }
                                if (!setting.equals("1")) continue block28;
                                invulnerable = false;
                            }
                        }
                    }
                }
                switch (args[3]) {
                    case "Player": {
                        EntityCosmicNPC entity1 = new EntityCosmicNPC(world);
                        this.initNPC(entity1, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    case "PlayerSlim": {
                        EntityCosmicNPCSlim entity2 = new EntityCosmicNPCSlim(world);
                        this.initNPC(entity2, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    case "Witch": {
                        EntityCosmicNPCWitch entity3 = new EntityCosmicNPCWitch(world);
                        this.initNPC(entity3, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    case "Villager": {
                        EntityCosmicNPCVillager entity4 = new EntityCosmicNPCVillager(world);
                        this.initNPC(entity4, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    case "Vex": {
                        EntityCosmicNPCVex entity5 = new EntityCosmicNPCVex(world);
                        this.initNPC(entity5, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    case "Chicken": {
                        EntityCosmicNPCChicken entity6 = new EntityCosmicNPCChicken(world);
                        this.initNPC(entity6, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                    default: {
                        EntityCosmicNPC entitydefault = new EntityCosmicNPC(world);
                        this.initNPC(entitydefault, args, x, y, z, showNameTag, invulnerable);
                        break;
                    }
                }
            } else {
                this.initNPC(entity, args, x, y, z, showNameTag, invulnerable);
            }
        }
    }

    public void initNPC(EntityCosmicNPC npc, String[] args, double x, double y, double z, int showNameTag, boolean invulnerable) {
        npc.func_70107_b(x, y, z);
        if (showNameTag >= 1) {
            npc.func_96094_a(args[1]);
        }
        if (showNameTag == 1) {
            npc.func_174805_g(true);
        } else {
            npc.func_174805_g(false);
        }
        npc.setTextureName(args[2]);
        npc.func_184224_h(invulnerable);
        npc.field_70170_p.func_72838_d((Entity)npc);
        Iterator<PlayThread> iterator = this.playThreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        this.playThreads.add(new PlayThread(npc, args[0]));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (!(sender instanceof EntityPlayer)) {
            return sender.func_70003_b(0, this.func_71517_b());
        }
        return sender.func_70003_b(this.func_82362_a(), this.func_71517_b());
    }

    public int func_82362_a() {
        return 2;
    }
}

