/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.entity;

import com.mojang.authlib.GameProfile;
import de.namensammler.cosmicnpcs.npcsystem.NPCAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityCosmicNPC
extends EntityLiving {
    private static final DataParameter<String> TEXTURE_NAME = EntityDataManager.func_187226_a(EntityCosmicNPC.class, (DataSerializer)DataSerializers.field_187194_d);
    protected ItemStack lastActiveItemStack = ItemStack.field_190927_a;
    public List<NPCAction> eventsList = Collections.synchronizedList(new ArrayList());
    public EntityPlayer npcplayer = new EntityPlayer(this.field_70170_p, new GameProfile(this.field_96093_i, "NPCPlayer")){

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return true;
        }

        public void func_71007_a(IInventory chestInventory) {
            this.field_71070_bA = ((IInteractionObject)chestInventory).func_174876_a(this.field_71071_by, (EntityPlayer)this);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)this, this.field_71070_bA));
        }
    };

    public EntityCosmicNPC(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        this.func_70105_a(0.6f, 1.8f);
        this.field_70180_af.func_187214_a(TEXTURE_NAME, (Object)"");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.1f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public void setTextureName(String textureName) {
        this.field_70180_af.func_187227_b(TEXTURE_NAME, (Object)textureName);
    }

    public String getTextureName() {
        return (String)this.field_70180_af.func_187225_a(TEXTURE_NAME);
    }

    public boolean func_175446_cd() {
        return true;
    }

    private void replayShootArrow(NPCAction ma) {
        float f = (float)ma.arrowCharge / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        ItemArrow arrow = (ItemArrow)new ItemStack(Items.field_151032_g).func_77973_b();
        EntityArrow entityarrow = arrow.func_185052_a(this.field_70170_p, this.func_184607_cu(), (EntityLivingBase)this);
        entityarrow.func_184547_a((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            entityarrow.func_70243_d(true);
        }
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    private void processActions(NPCAction ma) {
        switch (ma.type) {
            case 1: {
                ArrayList temp = (ArrayList)FMLCommonHandler.instance().getSidedDelegate().getServer().func_184103_al().func_181057_v();
                for (EntityPlayerMP player : temp) {
                    TextComponentString cmp = new TextComponentString("<" + this.func_95999_t() + "> " + ma.message);
                    player.func_145747_a((ITextComponent)cmp);
                }
                break;
            }
            case 2: {
                this.func_184609_a(EnumHand.MAIN_HAND);
                EntityLivingBase mop = this.GetTargetEntityLiving(5);
                if (mop == null) break;
                this.func_70652_k((Entity)mop);
                this.attackTargetEntityWithCurrentItem((Entity)mop);
                break;
            }
            case 4: {
                if (ma.armorId == -1) {
                    this.func_184201_a(this.getEquipmentSlotById(ma.armorSlot), ItemStack.field_190927_a);
                    break;
                }
                ItemStack loadedEquip = new ItemStack(ma.itemData);
                this.func_184201_a(this.getEquipmentSlotById(ma.armorSlot), loadedEquip);
                break;
            }
            case 3: {
                ItemStack foo = new ItemStack(ma.itemData);
                EntityItem ea = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u - (double)0.3f + (double)this.func_70047_e(), this.field_70161_v, foo);
                Random rand = new Random();
                float f = 0.3f;
                ea.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
                ea.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
                ea.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
                f = 0.02f;
                float f1 = rand.nextFloat() * (float)Math.PI * 2.0f;
                ea.field_70159_w += Math.cos(f1) * (double)(f *= rand.nextFloat());
                ea.field_70181_x += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ea.field_70179_y += Math.sin(f1) * (double)f;
                this.field_70170_p.func_72838_d((Entity)ea);
                break;
            }
            case 5: {
                this.replayShootArrow(ma);
                break;
            }
            case 8: {
                IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (block == Blocks.field_150350_a.func_176223_P()) break;
                this.field_70170_p.func_175718_b(2001, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Block.func_176210_f((IBlockState)block));
                this.field_70170_p.func_175698_g(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                block.func_177230_c().func_176206_d(this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block);
                break;
            }
            case 7: {
                IBlockState block = Block.func_176220_d((int)ma.stateId);
                this.field_70170_p.func_175656_a(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block);
                if (block.func_177230_c() instanceof BlockDoor) {
                    IBlockState upperDoor = block.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
                    this.field_70170_p.func_175656_a(new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), upperDoor);
                }
                SoundType soundtype = block.func_177230_c().getSoundType(block, this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), (Entity)this);
                this.field_70170_p.func_184133_a(null, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                break;
            }
            case 9: {
                Block aBlock = this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord)).func_177230_c();
                if (aBlock == Blocks.field_150350_a) break;
                aBlock.func_180639_a(this.field_70170_p, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), this.field_70170_p.func_180495_p(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord)), this.npcplayer, EnumHand.MAIN_HAND, null, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 10: {
                this.npcplayer.field_71070_bA.func_75134_a(this.npcplayer);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Close(this.npcplayer, this.npcplayer.field_71070_bA));
                this.npcplayer.field_71070_bA = this.npcplayer.field_71069_bz;
                break;
            }
            case 11: {
                this.npcplayer.field_70165_t = this.field_70165_t;
                this.npcplayer.field_70163_u = this.field_70163_u;
                this.npcplayer.field_70161_v = this.field_70161_v;
                this.npcplayer.field_70177_z = this.field_70177_z;
                this.npcplayer.field_70125_A = this.field_70125_A;
                this.npcplayer.func_184201_a(EntityEquipmentSlot.MAINHAND, this.func_184614_ca());
                this.npcplayer.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_184592_cb());
                this.npcplayer.field_71075_bZ.field_75098_d = true;
                this.func_184586_b(ma.handType).func_77973_b().func_77659_a(this.field_70170_p, this.npcplayer, ma.handType);
                this.lastActiveItemStack = this.func_184586_b(ma.handType);
                break;
            }
            case 12: {
                this.lastActiveItemStack.func_77950_b(this.field_70170_p, (EntityLivingBase)this);
                this.lastActiveItemStack = ItemStack.field_190927_a;
                break;
            }
            case 13: {
                System.out.println(ma.message);
                Minecraft.func_71410_x().func_71401_C().func_184102_h().field_71321_q.func_71556_a((ICommandSender)this, ma.message);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.eventsList.size() > 0) {
            NPCAction ma = this.eventsList.remove(0);
            this.processActions(ma);
        }
        this.func_82168_bl();
        this.npcplayer.field_71070_bA.func_75142_b();
    }

    protected float func_110146_f(float f2, float f3) {
        boolean flag;
        float f = MathHelper.func_76142_g((float)(f2 - this.field_70761_aq));
        this.field_70761_aq += f * 0.3f;
        float f1 = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_70761_aq = this.field_70177_z - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_70761_aq += f1 * 0.2f;
        }
        if (flag) {
            f3 *= -1.0f;
        }
        return f3;
    }

    public EntityLivingBase GetTargetEntityLiving(int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        EntityLivingBase target = null;
        AxisAlignedBB area = new AxisAlignedBB(this.field_70165_t - (double)scanRadius, this.field_70163_u - (double)scanRadius, this.field_70161_v - (double)scanRadius, this.field_70165_t + (double)scanRadius, this.field_70163_u + (double)scanRadius, this.field_70161_v + (double)scanRadius);
        List lst = this.field_70170_p.func_72839_b((Entity)this, area);
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (!(ent instanceof EntityLivingBase) || ent == null || ent.func_174813_aQ() == null) continue;
            float distance = this.func_70032_d(ent) + 0.1f;
            float angle = this.field_70759_as;
            float pitch = this.field_70125_A;
            Vec3d look = this.func_70040_Z();
            Vec3d targetVec = new Vec3d(this.field_70165_t + look.field_72450_a * (double)distance, (double)(this.func_70047_e() / 2.0f) + this.field_70163_u + look.field_72448_b * (double)distance, this.field_70161_v + look.field_72449_c * (double)distance);
            if (!ent.func_174813_aQ().func_72318_a(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (EntityLivingBase)ent;
        }
        return target;
    }

    public EntityEquipmentSlot getEquipmentSlotById(int Id) {
        switch (Id) {
            case 0: {
                return EntityEquipmentSlot.MAINHAND;
            }
            case 1: {
                return EntityEquipmentSlot.FEET;
            }
            case 2: {
                return EntityEquipmentSlot.LEGS;
            }
            case 3: {
                return EntityEquipmentSlot.CHEST;
            }
            case 4: {
                return EntityEquipmentSlot.HEAD;
            }
            case 5: {
                return EntityEquipmentSlot.OFFHAND;
            }
        }
        return EntityEquipmentSlot.LEGS;
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity) {
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)this)) {
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
                if (this.func_70051_ag() && flag) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(MobEffects.field_76440_q) && !this.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                flag2 = flag2 && !this.func_70051_ag();
                f += f1;
                boolean flag3 = false;
                double d0 = this.field_70140_Q - this.field_70141_P;
                if (flag && !flag2 && !flag1 && this.field_70122_E && d0 < (double)this.func_70689_ay() && (itemstack = this.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
                if (targetEntity instanceof EntityLivingBase) {
                    f4 = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double d1 = targetEntity.field_70159_w;
                double d2 = targetEntity.field_70181_x;
                double d3 = targetEntity.field_70179_y;
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
                if (flag5) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        this.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a((EntityLivingBase)this) * f;
                        for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == this || entitylivingbase == targetEntity || this.func_184191_r((Entity)entitylivingbase) || !(this.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a((Entity)this, 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f3);
                        }
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                        double dd0 = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        double dd1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        if (this.field_70170_p instanceof WorldServer) {
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.field_70165_t + dd0, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v + dd1, 0, dd0, 0.0, dd1, 0.0, new int[0]);
                        }
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = d1;
                        targetEntity.field_70181_x = d2;
                        targetEntity.field_70179_y = d3;
                    }
                    if (flag2) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    this.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
                    ItemStack itemstack1 = this.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!itemstack1.func_190926_b() && entity instanceof EntityLivingBase) {
                        ItemStack beforeHitCopy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((EntityLivingBase)entity, this.npcplayer);
                        if (itemstack1.func_190926_b()) {
                            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = f4 - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (this.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                } else {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }
}

