/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.npcsystem.NPCAction;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class RecordThread
implements Runnable {
    public Thread t;
    EntityPlayer player;
    public Boolean capture = false;
    RandomAccessFile in;
    Boolean lastTickSwipe = false;
    int[] itemsEquipped = new int[6];
    List<NPCAction> eventList;

    public RecordThread(EntityPlayer _player, String capname) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        try {
            if (side == Side.CLIENT) {
                String path = CosmicNPCs.config.getConfigFile().getAbsolutePath();
                File file = new File((path = path.substring(0, path.length() - 4 - 10)) + "/recordings");
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.in = new RandomAccessFile(file.getAbsolutePath() + "/" + capname + ".ccap", "rw");
                this.in.setLength(0L);
            } else if (side == Side.SERVER) {
                File file = new File("config/cosmicnpcs/recordings");
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.in = new RandomAccessFile(file.getAbsolutePath() + "/" + capname + ".ccap", "rw");
                this.in.setLength(0L);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.player = _player;
        this.capture = true;
        this.eventList = CosmicNPCs.instance.getActionListForPlayer(this.player);
        this.t = new Thread((Runnable)this, "NPC Record Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            this.in.writeShort(60417);
            while (this.capture.booleanValue()) {
                this.trackAndWriteMovement();
                this.trackSwing();
                this.trackHeldItem();
                this.trackHeldItemOffhand();
                this.trackArmor();
                this.writeActions();
                Thread.sleep(25L);
                if (!this.player.field_70128_L) continue;
                this.capture = false;
                CosmicNPCs.instance.recordThreads.remove(this.player);
                CosmicNPCs.instance.broadcastMsg("Stopped recording " + this.player.func_145748_c_() + ". RIP.");
            }
            this.in.close();
        }
        catch (InterruptedException e) {
            System.out.println("Child interrupted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Exiting child thread.");
    }

    private void trackAndWriteMovement() throws IOException {
        this.in.writeFloat(this.player.field_70759_as);
        this.in.writeFloat(this.player.field_70177_z);
        this.in.writeFloat(this.player.field_70125_A);
        this.in.writeDouble(this.player.field_70165_t);
        this.in.writeDouble(this.player.field_70163_u);
        this.in.writeDouble(this.player.field_70161_v);
        this.in.writeDouble(this.player.field_70159_w);
        this.in.writeDouble(this.player.field_70181_x);
        this.in.writeDouble(this.player.field_70179_y);
        this.in.writeFloat(this.player.field_70143_R);
        this.in.writeBoolean(this.player.field_70160_al);
        this.in.writeBoolean(this.player.func_70093_af());
        this.in.writeBoolean(this.player.func_70051_ag());
        this.in.writeBoolean(this.player.field_70122_E);
        if (this.player.func_184587_cr()) {
            this.in.writeBoolean(this.player.func_184587_cr());
            this.in.writeByte((byte)this.player.func_184600_cs().ordinal());
        } else {
            this.in.writeBoolean(this.player.func_184587_cr());
            this.in.writeByte((byte)EnumHand.MAIN_HAND.ordinal());
        }
    }

    private void trackArmor() {
        for (int ci = 1; ci < 5; ++ci) {
            NPCAction ma;
            if (this.player.field_71071_by.field_70460_b.get(ci - 1) != null) {
                if (Item.func_150891_b((Item)((ItemStack)this.player.field_71071_by.field_70460_b.get(ci - 1)).func_77973_b()) == this.itemsEquipped[ci]) continue;
                this.itemsEquipped[ci] = Item.func_150891_b((Item)((ItemStack)this.player.field_71071_by.field_70460_b.get(ci - 1)).func_77973_b());
                ma = new NPCAction(4);
                ma.armorSlot = ci;
                ma.armorId = this.itemsEquipped[ci];
                ma.armorDmg = ((ItemStack)this.player.field_71071_by.field_70460_b.get(ci - 1)).func_77952_i();
                ((ItemStack)this.player.field_71071_by.field_70460_b.get(ci - 1)).func_77955_b(ma.itemData);
                this.eventList.add(ma);
                continue;
            }
            if (this.itemsEquipped[ci] == -1) continue;
            this.itemsEquipped[ci] = -1;
            ma = new NPCAction(4);
            ma.armorSlot = ci;
            ma.armorId = this.itemsEquipped[ci];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItem() {
        if (!this.player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            if (Item.func_150891_b((Item)this.player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()) != this.itemsEquipped[0]) {
                this.itemsEquipped[0] = Item.func_150891_b((Item)this.player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b());
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 0;
                ma.armorId = this.itemsEquipped[0];
                ma.armorDmg = this.player.func_184586_b(EnumHand.MAIN_HAND).func_77952_i();
                this.player.func_184586_b(EnumHand.MAIN_HAND).func_77955_b(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[0] != -1) {
            this.itemsEquipped[0] = -1;
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 0;
            ma.armorId = this.itemsEquipped[0];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItemOffhand() {
        if (!this.player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
            if (Item.func_150891_b((Item)this.player.func_184586_b(EnumHand.OFF_HAND).func_77973_b()) != this.itemsEquipped[5]) {
                this.itemsEquipped[5] = Item.func_150891_b((Item)this.player.func_184586_b(EnumHand.OFF_HAND).func_77973_b());
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 5;
                ma.armorId = this.itemsEquipped[5];
                ma.armorDmg = this.player.func_184586_b(EnumHand.OFF_HAND).func_77952_i();
                this.player.func_184586_b(EnumHand.OFF_HAND).func_77955_b(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[5] != -1) {
            this.itemsEquipped[5] = -1;
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 5;
            ma.armorId = this.itemsEquipped[5];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackSwing() {
        if (this.player.field_82175_bq) {
            if (!this.lastTickSwipe.booleanValue()) {
                this.lastTickSwipe = true;
                this.eventList.add(new NPCAction(2));
            }
        } else {
            this.lastTickSwipe = false;
        }
    }

    private void writeActions() throws IOException {
        if (this.eventList.size() > 0) {
            this.in.writeBoolean(true);
            NPCAction ma = this.eventList.get(0);
            this.in.writeByte(ma.type);
            switch (ma.type) {
                case 1: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 4: {
                    this.in.writeInt(ma.armorSlot);
                    this.in.writeInt(ma.armorId);
                    this.in.writeInt(ma.armorDmg);
                    if (ma.armorId == -1) break;
                    CompressedStreamTools.func_74800_a((NBTTagCompound)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 5: {
                    this.in.writeInt(ma.arrowCharge);
                    break;
                }
                case 7: {
                    this.in.writeInt(ma.stateId);
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 8: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 9: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    this.in.writeInt(ma.metaData);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.in.writeByte((byte)ma.handType.ordinal());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 6: {
                    CosmicNPCs.instance.recordThreads.remove(this.player);
                    CosmicNPCs.instance.broadcastMsg("Stopped recording " + this.player.func_145748_c_() + ". Bye!");
                    this.capture = false;
                }
            }
            this.eventList.remove(0);
        } else {
            this.in.writeBoolean(false);
        }
    }
}

