/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllSoundEvents {
    public static Map<ResourceLocation, SoundEntry> entries = Maps.newHashMap();
    public static final SoundEntry SCHEMATICANNON_LAUNCH_BLOCK = AllSoundEvents.create("schematicannon_launch_block").subtitle("Schematicannon fires").playExisting(SoundEvents.field_187539_bB, 0.1f, 1.1f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SCHEMATICANNON_FINISH = AllSoundEvents.create("schematicannon_finish").subtitle("Schematicannon dings").playExisting(SoundEvents.field_193807_ew, 1.0f, 0.7f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry DEPOT_SLIDE = AllSoundEvents.create("depot_slide").subtitle("Item slides").playExisting(SoundEvents.field_187747_eB, 0.125f, 1.5f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry DEPOT_PLOP = AllSoundEvents.create("depot_plop").subtitle("Item lands").playExisting(SoundEvents.field_187620_cL, 0.25f, 1.25f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry FUNNEL_FLAP = AllSoundEvents.create("funnel_flap").subtitle("Funnel Flaps").playExisting(SoundEvents.field_187632_cP, 0.125f, 1.5f).playExisting(SoundEvents.field_187546_ae, 0.0425f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SLIME_ADDED = AllSoundEvents.create("slime_added").subtitle("Slime squishes").playExisting(SoundEvents.field_187884_fr).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION = AllSoundEvents.create("mechanical_press_activation").subtitle("Mechanical Press clangs").playExisting(SoundEvents.field_187689_f, 0.125f, 1.0f).playExisting(SoundEvents.field_187635_cQ, 0.5f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION_ON_BELT = AllSoundEvents.create("mechanical_press_activation_belt").subtitle("Mechanical Press bonks").playExisting(SoundEvents.field_187550_ag, 0.75f, 1.0f).playExisting(SoundEvents.field_187635_cQ, 0.15f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry MIXING = AllSoundEvents.create("mixing").subtitle("Mixing Noises").playExisting(SoundEvents.field_232707_eX_, 0.125f, 0.5f).playExisting(SoundEvents.field_232780_jk_, 0.125f, 0.5f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRANKING = AllSoundEvents.create("cranking").subtitle("Hand Crank turns").playExisting(SoundEvents.field_187891_gV, 0.075f, 0.5f).playExisting(SoundEvents.field_187883_gR, 0.025f, 0.5f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry WORLDSHAPER_PLACE = AllSoundEvents.create("worldshaper_place").subtitle("Worldshaper zaps").playExisting(SoundEvents.field_187676_dE).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry SCROLL_VALUE = AllSoundEvents.create("scroll_value").subtitle("Scroll-input clicks").playExisting(SoundEvents.field_187685_dH, 0.124f, 1.0f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry CONFIRM = AllSoundEvents.create("confirm").subtitle("Affirmative ding").playExisting(SoundEvents.field_193807_ew, 0.5f, 0.8f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry DENY = AllSoundEvents.create("deny").subtitle("Declining boop").playExisting(SoundEvents.field_187679_dF, 1.0f, 0.5f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry COGS = AllSoundEvents.create("cogs").subtitle("Cogwheels rumble").category(SoundCategory.BLOCKS).build();
    public static final SoundEntry FWOOMP = AllSoundEvents.create("fwoomp").subtitle("Potato Launcher fwoomps").category(SoundCategory.PLAYERS).build();
    public static final SoundEntry POTATO_HIT = AllSoundEvents.create("potato_hit").subtitle("Vegetable impacts").playExisting(SoundEvents.field_187623_cM, 0.75f, 0.75f).playExisting(SoundEvents.field_232753_iV_, 0.75f, 1.25f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry CONTRAPTION_ASSEMBLE = AllSoundEvents.create("contraption_assemble").subtitle("Contraption moves").playExisting(SoundEvents.field_187879_gP, 0.5f, 0.5f).playExisting(SoundEvents.field_187657_V, 0.045f, 0.74f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CONTRAPTION_DISASSEMBLE = AllSoundEvents.create("contraption_disassemble").subtitle("Contraption stops").playExisting(SoundEvents.field_187614_cJ, 0.35f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry WRENCH_ROTATE = AllSoundEvents.create("wrench_rotate").subtitle("Wrench used").playExisting(SoundEvents.field_187877_gO, 0.25f, 1.25f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry WRENCH_REMOVE = AllSoundEvents.create("wrench_remove").subtitle("Component breaks").playExisting(SoundEvents.field_187638_cR, 0.25f, 0.75f).playExisting(SoundEvents.field_232778_ji_, 0.25f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRAFTER_CLICK = AllSoundEvents.create("crafter_click").subtitle("Crafter clicks").playExisting(SoundEvents.field_232778_ji_, 0.25f, 1.0f).playExisting(SoundEvents.field_187879_gP, 0.125f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRAFTER_CRAFT = AllSoundEvents.create("crafter_craft").subtitle("Crafter crafts").playExisting(SoundEvents.field_187635_cQ, 0.125f, 0.75f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry COPPER_ARMOR_EQUIP = AllSoundEvents.create("copper_armor_equip").subtitle("Diving equipment clinks").playExisting(SoundEvents.field_187722_q, 1.0f, 1.0f).category(SoundCategory.PLAYERS).build();
    public static final SoundEntry AUTO_POLISH = AllSoundEvents.create("deployer_polish").subtitle("Deployer applies polish").playExisting(SoundEvents.field_219719_ml, 1.0f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CONTROLLER_CLICK = AllSoundEvents.create("controller_click").subtitle("Controller clicks").playExisting(SoundEvents.field_187620_cL, 0.35f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CONTROLLER_PUT = AllSoundEvents.create("controller_put").subtitle("Controller thumps").playExisting(SoundEvents.field_219618_ai, 1.0f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CONTROLLER_TAKE = AllSoundEvents.create("controller_take").subtitle("Lectern empties").playExisting(SoundEvents.field_187629_cO, 1.0f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SAW_ACTIVATE_WOOD = AllSoundEvents.create("saw_activate_wood").subtitle("Mechanical Saw activates").playExisting(SoundEvents.field_193778_H, 0.75f, 1.5f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry SAW_ACTIVATE_STONE = AllSoundEvents.create("saw_activate_stone").subtitle("Mechanical Saw activates").playExisting(SoundEvents.field_219719_ml, 0.125f, 1.25f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry BLAZE_MUNCH = AllSoundEvents.create("blaze_munch").subtitle("Blaze Burner munches").playExisting(SoundEvents.field_187537_bA, 0.5f, 1.0f).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRUSHING_1 = AllSoundEvents.create("crushing_1").subtitle("Crushing noises").playExisting(SoundEvents.field_232783_jn_).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRUSHING_2 = AllSoundEvents.create("crushing_2").noSubtitle().playExisting(SoundEvents.field_187587_bZ).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry CRUSHING_3 = AllSoundEvents.create("crushing_3").noSubtitle().playExisting(SoundEvents.field_232775_jf_).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry PECULIAR_BELL_USE = AllSoundEvents.create("peculiar_bell_use").subtitle("Peculiar Bell tolls").playExisting(SoundEvents.field_219603_Y).category(SoundCategory.BLOCKS).build();
    public static final SoundEntry HAUNTED_BELL_CONVERT = AllSoundEvents.create("haunted_bell_convert").subtitle("Haunted Bell awakens").category(SoundCategory.BLOCKS).build();
    public static final SoundEntry HAUNTED_BELL_USE = AllSoundEvents.create("haunted_bell_use").subtitle("Haunted Bell tolls").category(SoundCategory.BLOCKS).build();

    public static SoundEntryBuilder create(String id) {
        return new SoundEntryBuilder(id);
    }

    public static void register(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        for (SoundEntry entry : entries.values()) {
            entry.register((IForgeRegistry<SoundEvent>)registry);
        }
    }

    public static void prepare() {
        for (SoundEntry entry : entries.values()) {
            entry.prepare();
        }
    }

    public static JsonElement provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : entries.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    static class CustomSoundEntry
    extends SoundEntry {
        protected SoundEvent event;

        public CustomSoundEntry(String id, String subtitle, SoundCategory category) {
            super(id, subtitle, category);
        }

        @Override
        public void prepare() {
            ResourceLocation location = this.getLocation();
            this.event = (SoundEvent)new SoundEvent(location).setRegistryName(location);
        }

        @Override
        public void register(IForgeRegistry<SoundEvent> registry) {
            registry.register((IForgeRegistryEntry)this.event);
        }

        @Override
        public SoundEvent getMainEvent() {
            return this.event;
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            list.add(this.getLocation().toString());
            entry.add("sounds", (JsonElement)list);
            entry.addProperty("subtitle", this.getSubtitleKey());
            json.add(this.id, (JsonElement)entry);
        }

        @Override
        public void play(World world, PlayerEntity entity, double x, double y, double z, float volume, float pitch) {
            world.func_184148_a(entity, x, y, z, this.event, this.category, volume, pitch);
        }

        @Override
        public void playAt(World world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.func_184134_a(x, y, z, this.event, this.category, volume, pitch, fade);
        }
    }

    static class WrappedSoundEntry
    extends SoundEntry {
        private List<Pair<SoundEvent, Couple<Float>>> wrappedEvents;
        private List<Pair<SoundEvent, Couple<Float>>> compiledEvents;

        public WrappedSoundEntry(String id, String subtitle, List<Pair<SoundEvent, Couple<Float>>> wrappedEvents, SoundCategory category) {
            super(id, subtitle, category);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = Lists.newArrayList();
        }

        @Override
        public void prepare() {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ResourceLocation location = Create.asResource(this.getIdOf(i));
                SoundEvent sound = (SoundEvent)new SoundEvent(location).setRegistryName(location);
                this.compiledEvents.add(Pair.of(sound, this.wrappedEvents.get(i).getSecond()));
            }
        }

        @Override
        public void register(IForgeRegistry<SoundEvent> registry) {
            for (Pair<SoundEvent, Couple<Float>> pair : this.compiledEvents) {
                registry.register((IForgeRegistryEntry)pair.getFirst());
            }
        }

        @Override
        public SoundEvent getMainEvent() {
            return this.compiledEvents.get(0).getFirst();
        }

        protected String getIdOf(int i) {
            return i == 0 ? this.id : this.id + "_compounded_" + i;
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                Pair<SoundEvent, Couple<Float>> pair = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", pair.getFirst().func_187503_a().toString());
                s.addProperty("type", "event");
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i), (JsonElement)entry);
            }
        }

        @Override
        public void play(World world, PlayerEntity entity, double x, double y, double z, float volume, float pitch) {
            for (Pair<SoundEvent, Couple<Float>> pair : this.compiledEvents) {
                Couple<Float> volPitch = pair.getSecond();
                world.func_184148_a(entity, x, y, z, pair.getFirst(), this.category, ((Float)volPitch.getFirst()).floatValue() * volume, ((Float)volPitch.getSecond()).floatValue() * pitch);
            }
        }

        @Override
        public void playAt(World world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (Pair<SoundEvent, Couple<Float>> pair : this.compiledEvents) {
                Couple<Float> volPitch = pair.getSecond();
                world.func_184134_a(x, y, z, pair.getFirst(), this.category, ((Float)volPitch.getFirst()).floatValue() * volume, ((Float)volPitch.getSecond()).floatValue() * pitch, fade);
            }
        }
    }

    public static abstract class SoundEntry {
        protected String id;
        protected String subtitle;
        protected SoundCategory category;

        public SoundEntry(String id, String subtitle, SoundCategory category) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
        }

        public abstract void prepare();

        public abstract void register(IForgeRegistry<SoundEvent> var1);

        public abstract void write(JsonObject var1);

        public abstract SoundEvent getMainEvent();

        public String getSubtitleKey() {
            return "create.subtitle." + this.id;
        }

        public String getId() {
            return this.id;
        }

        public ResourceLocation getLocation() {
            return Create.asResource(this.id);
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(World world, BlockPos pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(World world, BlockPos pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(World world, PlayerEntity entity, BlockPos pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.func_174814_R()) {
                this.play(entity.field_70170_p, null, entity.func_233580_cy_(), volume, pitch);
            }
        }

        public void play(World world, PlayerEntity entity, BlockPos pos, float volume, float pitch) {
            this.play(world, entity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), volume, pitch);
        }

        public void play(World world, PlayerEntity entity, Vector3d pos, float volume, float pitch) {
            this.play(world, entity, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), volume, pitch);
        }

        public abstract void play(World var1, PlayerEntity var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(World world, BlockPos pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, volume, pitch, fade);
        }

        public void playAt(World world, Vector3d pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), volume, pitch, fade);
        }

        public abstract void playAt(World var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    static class SoundEntryBuilder {
        protected String id;
        protected String subtitle = "unregistered";
        protected SoundCategory category = SoundCategory.BLOCKS;
        List<Pair<SoundEvent, Couple<Float>>> wrappedEvents = Lists.newArrayList();

        public SoundEntryBuilder(String id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(SoundCategory category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            this.wrappedEvents.add(Pair.of(event, Couple.create(Float.valueOf(volume), Float.valueOf(pitch))));
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.subtitle, this.category) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category);
            entries.put(entry.getLocation(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements IDataProvider {
        private DataGenerator generator;

        public SoundEntryProvider(DataGenerator generator) {
            this.generator = generator;
        }

        public void func_200398_a(DirectoryCache cache) throws IOException {
            this.generate(this.generator.func_200391_b(), cache);
        }

        public String func_200397_b() {
            return "Create's Custom Sounds";
        }

        public void generate(Path path, DirectoryCache cache) {
            Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            path = path.resolve("assets/create");
            try {
                JsonObject json = new JsonObject();
                entries.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

