/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.backend.instancing.InstanceMaterial;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.actors.ActorData;
import com.simibubi.create.content.contraptions.components.actors.DrillBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;

public class DrillActorInstance
extends ActorInstance {
    ActorData drillHead;
    private final Direction facing;

    public DrillActorInstance(MaterialManager<?> materialManager, PlacementSimulationWorld contraption, MovementContext context) {
        super(materialManager, contraption, context);
        InstanceMaterial instanceMaterial = materialManager.getMaterial(AllMaterialSpecs.ACTORS);
        BlockState state = context.state;
        this.facing = (Direction)state.func_177229_b((Property)DrillBlock.FACING);
        Direction.Axis axis = this.facing.func_176740_k();
        float eulerX = AngleHelper.verticalAngle(this.facing);
        float eulerY = axis == Direction.Axis.Y ? 0.0f : this.facing.func_185119_l() + (float)(axis == Direction.Axis.X ? 180 : 0);
        this.drillHead = (ActorData)instanceMaterial.getModel(AllBlockPartials.DRILL_HEAD, state).createInstance();
        this.drillHead.setPosition(context.localPos).setBlockLight(this.localBlockLight()).setRotationOffset(0.0f).setRotationAxis(0.0f, 0.0f, 1.0f).setLocalRotation(new Quaternion(eulerX, eulerY, 0.0f, true)).setSpeed(this.getSpeed(this.facing));
    }

    @Override
    public void beginFrame() {
        this.drillHead.setSpeed(this.getSpeed(this.facing));
    }

    protected float getSpeed(Direction facing) {
        if (this.context.contraption.stalled || !VecHelper.isVecPointingTowards(this.context.relativeMotion, facing.func_176734_d())) {
            return this.context.getAnimationSpeed();
        }
        return 0.0f;
    }
}

