/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.base.SingleRotatingInstance;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.block.Block;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;

public class HandCrankInstance
extends SingleRotatingInstance
implements IDynamicInstance {
    private final HandCrankTileEntity tile;
    private ModelData crank;
    private Direction facing;

    public HandCrankInstance(MaterialManager<?> modelManager, HandCrankTileEntity tile) {
        super(modelManager, tile);
        this.tile = tile;
        Block block = this.blockState.func_177230_c();
        PartialModel renderedHandle = null;
        if (block instanceof HandCrankBlock) {
            renderedHandle = ((HandCrankBlock)block).getRenderedHandle();
        }
        if (renderedHandle == null) {
            return;
        }
        this.facing = (Direction)this.blockState.func_177229_b((Property)BlockStateProperties.field_208155_H);
        Direction opposite = this.facing.func_176734_d();
        Instancer model = this.getTransformMaterial().getModel(renderedHandle, this.blockState, opposite);
        this.crank = (ModelData)model.createInstance();
        this.rotateCrank();
    }

    public void beginFrame() {
        if (this.crank == null) {
            return;
        }
        this.rotateCrank();
    }

    private void rotateCrank() {
        Direction.Axis axis = this.facing.func_176740_k();
        float angle = (this.tile.independentAngle + AnimationTickHolder.getPartialTicks() * this.tile.chasingVelocity) / 360.0f;
        MatrixStack ms = new MatrixStack();
        MatrixStacker.of(ms).translate((Vector3i)this.getInstancePosition()).centre().rotate(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle).unCentre();
        this.crank.setTransform(ms);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.crank != null) {
            this.crank.delete();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        if (this.crank != null) {
            this.relight(this.pos, new IFlatLight[]{this.crank});
        }
    }
}

