/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import com.simibubi.create.foundation.utility.Lang;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class DeployerFakePlayer
extends FakePlayer {
    private static final NetworkManager NETWORK_MANAGER = new NetworkManager(PacketDirection.CLIENTBOUND);
    public static final GameProfile DEPLOYER_PROFILE = new GameProfile(UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d"), "Deployer");
    Pair<BlockPos, Float> blockBreakingProgress;
    ItemStack spawnedItemEffects;

    public DeployerFakePlayer(ServerWorld world) {
        super(world, DEPLOYER_PROFILE);
        this.field_71135_a = new FakePlayNetHandler(world.func_73046_m(), (ServerPlayerEntity)this);
    }

    public OptionalInt func_213829_a(INamedContainerProvider container) {
        return OptionalInt.empty();
    }

    public ITextComponent func_145748_c_() {
        return Lang.translate("block.deployer.damage_source_name", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213307_e(Pose poseIn) {
        return 0.0f;
    }

    public Vector3d func_213303_ch() {
        return new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public float func_184818_cX() {
        return 0.015625f;
    }

    public boolean func_71043_e(boolean ignoreHunger) {
        return false;
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        stack.func_190918_g(1);
        return stack;
    }

    @SubscribeEvent
    public static void deployerHasEyesOnHisFeet(EntityEvent.Size event) {
        if (event.getEntity() instanceof DeployerFakePlayer) {
            event.setNewEyeHeight(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void deployerCollectsDropsFromKilledEntities(LivingDropsEvent event) {
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        EntityDamageSource source = (EntityDamageSource)event.getSource();
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && trueSource instanceof DeployerFakePlayer) {
            DeployerFakePlayer fakePlayer = (DeployerFakePlayer)trueSource;
            event.getDrops().forEach(stack -> fakePlayer.field_71071_by.func_191975_a(trueSource.field_70170_p, stack.func_92059_d()));
            event.setCanceled(true);
        }
    }

    protected void func_184606_a_(ItemStack p_184606_1_) {
    }

    public void remove(boolean keepData) {
        if (this.blockBreakingProgress != null && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175715_c(this.func_145782_y(), (BlockPos)this.blockBreakingProgress.getKey(), -1);
        }
        super.remove(keepData);
    }

    @SubscribeEvent
    public static void deployerKillsDoNotSpawnXP(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof DeployerFakePlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entitiesDontRetaliate(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof DeployerFakePlayer)) {
            return;
        }
        LivingEntity entityLiving = event.getEntityLiving();
        if (!(entityLiving instanceof MobEntity)) {
            return;
        }
        MobEntity mob = (MobEntity)entityLiving;
        CKinetics.DeployerAggroSetting setting = (CKinetics.DeployerAggroSetting)((Object)AllConfigs.SERVER.kinetics.ignoreDeployerAttacks.get());
        switch (setting) {
            case ALL: {
                mob.func_70624_b(null);
                break;
            }
            case CREEPERS: {
                if (!(mob instanceof CreeperEntity)) break;
                mob.func_70624_b(null);
                break;
            }
        }
    }

    private static class FakePlayNetHandler
    extends ServerPlayNetHandler {
        public FakePlayNetHandler(MinecraftServer server, ServerPlayerEntity playerIn) {
            super(server, NETWORK_MANAGER, playerIn);
        }

        public void func_147359_a(IPacket<?> packetIn) {
        }

        public void func_211148_a(IPacket<?> packetIn, GenericFutureListener<? extends Future<? super Void>> futureListeners) {
        }
    }
}

