/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.ITickableInstance;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;

public class DeployerInstance
extends ShaftInstance
implements IDynamicInstance,
ITickableInstance {
    final DeployerTileEntity tile;
    final Direction facing;
    final float yRot;
    final float zRot;
    final float zRotPole;
    protected final OrientedData pole;
    protected OrientedData hand;
    PartialModel currentHand;
    float progress;
    private boolean newHand = false;

    public DeployerInstance(MaterialManager<?> dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.tile = (DeployerTileEntity)((ShaftInstance)this).tile;
        this.facing = (Direction)this.blockState.func_177229_b((Property)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)this.blockState.func_177229_b((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.func_176740_k() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.zRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRotPole = rotatePole ? 90.0f : 0.0f;
        this.pole = (OrientedData)this.getOrientedMaterial().getModel(AllBlockPartials.DEPLOYER_POLE, this.blockState).createInstance();
        this.updateHandPose();
        this.relight(this.pos, new IFlatLight[]{this.pole});
        this.progress = this.getProgress(AnimationTickHolder.getPartialTicks());
        DeployerInstance.updateRotation(this.pole, this.hand, this.yRot, this.zRot, this.zRotPole);
        this.updatePosition();
    }

    public void tick() {
        this.newHand = this.updateHandPose();
    }

    public void beginFrame() {
        float newProgress = this.getProgress(AnimationTickHolder.getPartialTicks());
        if (!this.newHand && MathHelper.func_180185_a((float)newProgress, (float)this.progress)) {
            return;
        }
        this.progress = newProgress;
        this.newHand = false;
        this.updatePosition();
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.hand, this.pole});
    }

    @Override
    public void remove() {
        super.remove();
        this.hand.delete();
        this.pole.delete();
    }

    private boolean updateHandPose() {
        PartialModel handPose = this.tile.getHandPose();
        if (this.currentHand == handPose) {
            return false;
        }
        this.currentHand = handPose;
        if (this.hand != null) {
            this.hand.delete();
        }
        this.hand = (OrientedData)this.getOrientedMaterial().getModel(this.currentHand, this.blockState).createInstance();
        this.relight(this.pos, new IFlatLight[]{this.hand});
        DeployerInstance.updateRotation(this.pole, this.hand, this.yRot, this.zRot, this.zRotPole);
        this.updatePosition();
        return true;
    }

    private float getProgress(float partialTicks) {
        if (this.tile.state == DeployerTileEntity.State.EXPANDING) {
            return 1.0f - ((float)this.tile.timer - partialTicks * (float)this.tile.getTimerSpeed()) / 1000.0f;
        }
        if (this.tile.state == DeployerTileEntity.State.RETRACTING) {
            return ((float)this.tile.timer - partialTicks * (float)this.tile.getTimerSpeed()) / 1000.0f;
        }
        return 0.0f;
    }

    private void updatePosition() {
        float handLength = this.currentHand == AllBlockPartials.DEPLOYER_HAND_POINTING ? 0.0f : (this.currentHand == AllBlockPartials.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(MathHelper.func_76131_a((float)this.progress, (float)0.0f, (float)1.0f) * (this.tile.reach + handLength), 1.3125f);
        Vector3i facingVec = this.facing.func_176730_m();
        BlockPos blockPos = this.getInstancePosition();
        float x = (float)blockPos.func_177958_n() + (float)facingVec.func_177958_n() * distance;
        float y = (float)blockPos.func_177956_o() + (float)facingVec.func_177956_o() * distance;
        float z = (float)blockPos.func_177952_p() + (float)facingVec.func_177952_p() * distance;
        this.pole.setPosition(x, y, z);
        this.hand.setPosition(x, y, z);
    }

    static void updateRotation(OrientedData pole, OrientedData hand, float yRot, float zRot, float zRotPole) {
        Quaternion q = Direction.SOUTH.func_229386_k_().func_229187_a_(zRot);
        q.func_195890_a(Direction.UP.func_229386_k_().func_229187_a_(yRot));
        hand.setRotation(q);
        q.func_195890_a(Direction.SOUTH.func_229386_k_().func_229187_a_(zRotPole));
        pole.setRotation(q);
    }
}

