/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.deployer.DeployerActorInstance;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerHandler;
import com.simibubi.create.content.contraptions.components.deployer.DeployerRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
extends MovementBehaviour {
    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        return Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)DeployerBlock.FACING)).func_176730_m()).func_186678_a(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.field_72995_K) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        if (mode == DeployerTileEntity.Mode.USE && !DeployerHandler.shouldActivate(player.func_184614_ca(), context.world, pos, null)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.tryDisposeOfExcess(context);
        context.stall = player.blockBreakingProgress != null;
    }

    public void activate(MovementContext context, BlockPos pos, DeployerFakePlayer player, DeployerTileEntity.Mode mode) {
        World world = context.world;
        ItemStack filter = this.getFilter(context);
        if (AllItems.SCHEMATIC.isIn(filter)) {
            this.activateAsSchematicPrinter(context, pos, player, world, filter);
        }
        Vector3d facingVec = Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)DeployerBlock.FACING)).func_176730_m());
        facingVec = (Vector3d)context.rotation.apply(facingVec);
        Vector3d vec = context.position.func_178788_d(facingVec.func_186678_a(2.0));
        player.field_70177_z = AbstractContraptionEntity.yawFromVector(facingVec);
        player.field_70125_A = AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f;
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void activateAsSchematicPrinter(MovementContext context, BlockPos pos, DeployerFakePlayer player, World world, ItemStack filter) {
        TileEntity tile;
        ItemStack firstRequired;
        if (!filter.func_77942_o()) {
            return;
        }
        if (!world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return;
        }
        CompoundNBT tag = filter.func_77978_p();
        if (!tag.func_74767_n("Deployed")) {
            return;
        }
        SchematicWorld schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null) {
            return;
        }
        if (!schematicWorld.getBounds().func_175898_b((Vector3i)pos.func_177973_b((Vector3i)schematicWorld.anchor))) {
            return;
        }
        BlockState blockState = schematicWorld.func_180495_p(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.func_175625_s(pos));
        if (requirement.isInvalid() || requirement.isEmpty()) {
            return;
        }
        if (AllBlocks.BELT.has(blockState)) {
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        ItemStack itemStack = firstRequired = requiredItems.isEmpty() ? ItemStack.field_190927_a : requiredItems.get((int)0).item;
        if (!context.contraption.hasUniversalCreativeCrate) {
            Contraption.ContraptionInvWrapper iItemHandler = context.contraption.inventory;
            for (ItemRequirement.StackRequirement required : requiredItems) {
                int amountFound = ItemHelper.extract((IItemHandler)iItemHandler, s -> ItemRequirement.validate(required.item, s), ItemHelper.ExtractionCountMode.UPTO, required.item.func_190916_E(), true).func_190916_E();
                if (amountFound >= required.item.func_190916_E()) continue;
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                ItemHelper.extract((IItemHandler)iItemHandler, s -> ItemRequirement.validate(required.item, s), ItemHelper.ExtractionCountMode.UPTO, required.item.func_190916_E(), false);
            }
        }
        CompoundNBT data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState) && (tile = schematicWorld.func_175625_s(pos)) != null) {
            data = tile.func_189515_b(new CompoundNBT());
            data = NBTProcessors.process(tile, data, true);
        }
        BlockSnapshot blocksnapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos);
        BlockHelper.placeSchematicBlock(world, blockState, pos, firstRequired, data);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(true, false);
        }
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_72995_K) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerTileEntity.Mode mode = this.getMode(context);
        Pair<BlockPos, Float> blockBreakingProgress = player.blockBreakingProgress;
        if (blockBreakingProgress != null) {
            int timer = context.data.func_74762_e("Timer");
            if (timer < 20) {
                context.data.func_74768_a("Timer", ++timer);
                return;
            }
            context.data.func_82580_o("Timer");
            this.activate(context, (BlockPos)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.blockBreakingProgress != null;
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.field_72995_K) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.tileData.func_218657_a("Inventory", (INBT)player.field_71071_by.func_70442_a(new ListNBT()));
        player.func_70106_y();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.func_184614_ca().func_190926_b()) {
            ItemStack filter = this.getFilter(context);
            if (AllItems.SCHEMATIC.isIn(filter)) {
                return;
            }
            ItemStack held = ItemHelper.extract((IItemHandler)context.contraption.inventory, stack -> FilterItem.test(context.world, stack, filter), 1, false);
            player.func_184611_a(Hand.MAIN_HAND, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        PlayerInventory inv = player.field_71071_by;
        ItemStack filter = this.getFilter(context);
        for (List list : Arrays.asList(inv.field_70460_b, inv.field_184439_c, inv.field_70462_a)) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.func_190926_b() || list == inv.field_70462_a && i == inv.field_70461_c && FilterItem.test(context.world, itemstack, filter)) continue;
                this.dropItem(context, itemstack);
                list.set(i, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.data.func_218657_a("HeldItem", (INBT)player.func_184614_ca().serializeNBT());
    }

    private DeployerFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerFakePlayer) && context.world instanceof ServerWorld) {
            DeployerFakePlayer deployerFakePlayer = new DeployerFakePlayer((ServerWorld)context.world);
            deployerFakePlayer.field_71071_by.func_70443_b(context.tileData.func_150295_c("Inventory", 10));
            if (context.data.func_74764_b("HeldItem")) {
                deployerFakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.func_199557_a((CompoundNBT)context.data.func_74775_l("HeldItem")));
            }
            context.tileData.func_82580_o("Inventory");
            context.temporaryData = deployerFakePlayer;
        }
        return (DeployerFakePlayer)((Object)context.temporaryData);
    }

    private ItemStack getFilter(MovementContext context) {
        return ItemStack.func_199557_a((CompoundNBT)context.tileData.func_74775_l("Filter"));
    }

    private DeployerTileEntity.Mode getMode(MovementContext context) {
        return NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
    }

    @Override
    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffers) {
        if (!Backend.getInstance().canUseInstancing()) {
            DeployerRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager<?> materialManager, PlacementSimulationWorld simulationWorld, MovementContext context) {
        return new DeployerActorInstance(materialManager, simulationWorld, context);
    }
}

