/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DeployerRenderer
extends SafeTileEntityRenderer<DeployerTileEntity> {
    public DeployerRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderItem(te, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        this.renderComponents(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        boolean isBlockItem;
        if (te.heldItem.func_190926_b()) {
            return;
        }
        BlockState deployerState = te.func_195044_w();
        Vector3d offset = this.getHandOffset(te, partialTicks, deployerState).func_178787_e(VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a));
        ms.func_227860_a_();
        ms.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        Direction facing = (Direction)deployerState.func_177229_b((Property)DirectionalKineticBlock.FACING);
        boolean punching = te.mode == DeployerTileEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float zRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        boolean displayMode = facing == Direction.UP && te.getSpeed() == 0.0f && !punching;
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot));
        if (!displayMode) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(zRot));
            ms.func_227861_a_(0.0, 0.0, -0.6875);
        }
        if (punching) {
            ms.func_227861_a_(0.0, 0.125, -0.0625);
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;
        boolean bl = isBlockItem = te.heldItem.func_77973_b() instanceof BlockItem && itemRenderer.func_184393_a(te.heldItem, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.func_227861_a_(0.0, isBlockItem ? 0.5625 : 0.6875, 0.0);
            ms.func_227862_a_(scale, scale, scale);
            transform = ItemCameraTransforms.TransformType.GROUND;
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.func_227862_a_(scale, scale, scale);
            transform = punching ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIXED;
        }
        itemRenderer.func_229110_a_(te.heldItem, transform, light, overlay, ms, buffer);
        ms.func_227865_b_();
    }

    protected void renderComponents(DeployerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (!Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            KineticTileEntityRenderer.renderRotatingKineticBlock(te, this.getRenderedBlockState(te), ms, vb, light);
        }
        BlockState blockState = te.func_195044_w();
        BlockPos pos = te.func_174877_v();
        Vector3d offset = this.getHandOffset(te, partialTicks, blockState);
        SuperByteBuffer pole = PartialBufferer.get(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = PartialBufferer.get(te.getHandPose(), blockState);
        DeployerRenderer.transform(te.func_145831_w(), pole.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c), blockState, pos, true).renderInto(ms, vb);
        DeployerRenderer.transform(te.func_145831_w(), hand.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c), blockState, pos, false).renderInto(ms, vb);
    }

    protected Vector3d getHandOffset(DeployerTileEntity te, float partialTicks, BlockState blockState) {
        float distance = te.getHandOffset(partialTicks);
        return Vector3d.func_237491_b_((Vector3i)((Direction)blockState.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a((double)distance);
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }

    private static SuperByteBuffer transform(World world, SuperByteBuffer buffer, BlockState deployerState, BlockPos pos, boolean axisDirectionMatters) {
        Direction facing = (Direction)deployerState.func_177229_b((Property)DirectionalKineticBlock.FACING);
        float zRotLast = axisDirectionMatters && (Boolean)deployerState.func_177229_b((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.func_176740_k() == Direction.Axis.Z ? 90.0f : 0.0f;
        float yRot = AngleHelper.horizontalAngle(facing);
        float zRot = facing == Direction.UP ? 270.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRotLast / 180.0f) * Math.PI));
        buffer.light(WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)deployerState, (BlockPos)pos));
        return buffer;
    }

    public static void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        double factor;
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        BlockState blockState = context.state;
        BlockPos pos = BlockPos.field_177992_a;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData, "Mode", DeployerTileEntity.Mode.class);
        World world = context.world;
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        SuperByteBuffer pole = PartialBufferer.get(AllBlockPartials.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = PartialBufferer.get(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.func_74764_b("StationaryTimer")) {
            factor = MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vector3d center = VecHelper.getCenterOf((Vector3i)new BlockPos(context.position));
            double distance = context.position.func_72438_d(center);
            double nextDistance = context.position.func_178787_e(context.motion).func_72438_d(center);
            factor = 0.5 - MathHelper.func_151237_a((double)MathHelper.func_219803_d((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vector3d offset = Vector3d.func_237491_b_((Vector3i)((Direction)blockState.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a(factor);
        MatrixStack m = matrices.contraptionStack;
        m.func_227860_a_();
        m.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        pole.transform(m);
        hand.transform(m);
        pole = DeployerRenderer.transform(world, pole, blockState, pos, true);
        hand = DeployerRenderer.transform(world, hand, blockState, pos, false);
        pole.light(matrices.entityMatrix, ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.entityStack, builder);
        hand.light(matrices.entityMatrix, ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.entityStack, builder);
        m.func_227865_b_();
    }

    static PartialModel getHandPose(DeployerTileEntity.Mode mode) {
        return mode == DeployerTileEntity.Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : AllBlockPartials.DEPLOYER_HAND_POINTING;
    }
}

