/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.fan.AirCurrentSound;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AirCurrent {
    private static final DamageSource damageSourceFire = new DamageSource("create.fan_fire").func_76351_m().func_76361_j();
    private static final DamageSource damageSourceLava = new DamageSource("create.fan_lava").func_76351_m().func_76361_j();
    public final IAirCurrentSource source;
    public AxisAlignedBB bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public Direction direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>> affectedItemHandlers = new ArrayList<Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>>();
    protected List<Entity> caughtEntities = new ArrayList<Entity>();
    static boolean isClientPlayerInAirCurrent;
    @OnlyIn(value=Dist.CLIENT)
    static AirCurrentSound flyingSound;

    public AirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        if (this.direction == null) {
            this.rebuild();
        }
        World world = this.source.getAirCurrentWorld();
        Direction facing = this.direction;
        if (world != null && world.field_72995_K) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            Vector3d pos = VecHelper.getCenterOf((Vector3i)this.source.getAirCurrentPos()).func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a((double)offset));
            if ((double)world.field_73012_v.nextFloat() < (Double)AllConfigs.CLIENT.fanParticleDensity.get()) {
                world.func_195594_a((IParticleData)new AirFlowParticleData((Vector3i)this.source.getAirCurrentPos()), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world, facing);
        this.tickAffectedHandlers();
    }

    protected void tickAffectedEntities(World world, Direction facing) {
        Iterator<Entity> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!entity.func_70089_S() || !entity.func_174813_aQ().func_72326_a(this.bounds) || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            Vector3d center = VecHelper.getCenterOf((Vector3i)this.source.getAirCurrentPos());
            Vector3i flow = (this.pushing ? facing : facing.func_176734_d()).func_176730_m();
            float sneakModifier = entity.func_225608_bj_() ? 4096.0f : 512.0f;
            float speed = Math.abs(this.source.getSpeed());
            double entityDistance = entity.func_213303_ch().func_72438_d(center);
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistance / (double)this.maxDistance));
            Vector3d previousMotion = entity.func_213322_ci();
            float maxAcceleration = 5.0f;
            double xIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177958_n() * acceleration) - previousMotion.field_72450_a), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177956_o() * acceleration) - previousMotion.field_72448_b), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177952_p() * acceleration) - previousMotion.field_72449_c), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.func_213317_d(previousMotion.func_178787_e(new Vector3d(xIn, yIn, zIn).func_186678_a(0.125)));
            entity.field_70143_R = 0.0f;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AirCurrent.enableClientPlayerSound(entity, MathHelper.func_76131_a((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.field_147365_f = 0;
            }
            InWorldProcessing.Type processingType = this.getSegmentAt((float)(entityDistance -= 0.5));
            if (entity instanceof ServerPlayerEntity) {
                AllTriggers.triggerFor(AllTriggers.FAN_PROCESSING.constructTriggerFor(processingType), (PlayerEntity)entity);
            }
            if (processingType == null || processingType == InWorldProcessing.Type.NONE) continue;
            if (entity instanceof ItemEntity) {
                InWorldProcessing.spawnParticlesForProcessing(world, entity.func_213303_ch(), processingType);
                ItemEntity itemEntity = (ItemEntity)entity;
                if (world.field_72995_K || !InWorldProcessing.canProcess(itemEntity, processingType)) continue;
                InWorldProcessing.applyProcessing(itemEntity, processingType);
                continue;
            }
            if (world.field_72995_K) continue;
            switch (processingType) {
                case BLASTING: {
                    if (entity.func_230279_az_()) break;
                    entity.func_70015_d(10);
                    entity.func_70097_a(damageSourceLava, 4.0f);
                    break;
                }
                case SMOKING: {
                    if (entity.func_230279_az_()) break;
                    entity.func_70015_d(2);
                    entity.func_70097_a(damageSourceFire, 2.0f);
                    break;
                }
                case SPLASHING: {
                    if (entity instanceof EndermanEntity || entity.func_200600_R() == EntityType.field_200745_ak || entity.func_200600_R() == EntityType.field_200792_f) {
                        entity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                    if (!entity.func_70027_ad()) break;
                    entity.func_70066_B();
                    world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187541_bC, SoundCategory.NEUTRAL, 0.7f, 1.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    break;
                }
            }
        }
    }

    public void rebuild() {
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.direction = this.source.getAirflowOriginSide();
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        this.maxDistance = this.source.getMaxDistance();
        World world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        float max = this.maxDistance;
        Direction facing = this.direction;
        Vector3d directionVec = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m());
        this.maxDistance = AirCurrent.getFlowLimit(world, start, max, facing);
        AirCurrentSegment currentSegment = new AirCurrentSegment();
        this.segments.clear();
        currentSegment.startOffset = 0;
        InWorldProcessing.Type type = InWorldProcessing.Type.NONE;
        int limit = (int)(this.maxDistance + 0.5f);
        int searchStart = this.pushing ? 0 : limit;
        int searchEnd = this.pushing ? limit : 0;
        int searchStep = this.pushing ? 1 : -1;
        int i = searchStart;
        while (i * searchStep <= searchEnd * searchStep) {
            BlockPos currentPos = start.func_177967_a(this.direction, i);
            InWorldProcessing.Type newType = InWorldProcessing.Type.byBlock((IBlockReader)world, currentPos);
            if (newType != InWorldProcessing.Type.NONE) {
                type = newType;
            }
            if (currentSegment.type != type || currentSegment.startOffset == 0) {
                currentSegment.endOffset = i;
                if (currentSegment.startOffset != 0) {
                    this.segments.add(currentSegment);
                }
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i;
                currentSegment.type = type;
            }
            i += searchStep;
        }
        currentSegment.endOffset = searchEnd + searchStep;
        this.segments.add(currentSegment);
        if (this.maxDistance < 0.25f) {
            this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            Vector3d scale = directionVec.func_186678_a((double)factor);
            this.bounds = factor > 0.0f ? new AxisAlignedBB(start.func_177972_a(this.direction)).func_216361_a(scale) : new AxisAlignedBB(start.func_177972_a(this.direction)).func_191195_a(scale.field_72450_a, scale.field_72448_b, scale.field_72449_c).func_191194_a(scale);
        }
        this.findAffectedHandlers();
    }

    public static float getFlowLimit(World world, BlockPos start, float max, Direction facing) {
        BlockPos currentPos;
        Vector3d directionVec = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m());
        Vector3d planeVec = VecHelper.axisAlingedPlaneOf(directionVec);
        float offsetDistance = 0.25f;
        Vector3d[] offsets = new Vector3d[]{planeVec.func_216372_d((double)offsetDistance, (double)offsetDistance, (double)offsetDistance), planeVec.func_216372_d((double)(-offsetDistance), (double)(-offsetDistance), (double)offsetDistance), planeVec.func_216372_d((double)offsetDistance, (double)(-offsetDistance), (double)(-offsetDistance)), planeVec.func_216372_d((double)(-offsetDistance), (double)offsetDistance, (double)(-offsetDistance))};
        float limitedDistance = 0.0f;
        int i = 1;
        while ((float)i <= max && world.func_195588_v(currentPos = start.func_177967_a(facing, i))) {
            block5: {
                VoxelShape voxelshape;
                BlockState state = world.func_180495_p(currentPos);
                if (!AirCurrent.shouldAlwaysPass(state) && !(voxelshape = state.func_215685_b((IBlockReader)world, currentPos, ISelectionContext.func_216377_a())).func_197766_b()) {
                    if (voxelshape == VoxelShapes.func_197868_b()) {
                        max = i - 1;
                        break;
                    }
                    for (Vector3d offset : offsets) {
                        Vector3d rayEnd;
                        Vector3d rayStart = VecHelper.getCenterOf((Vector3i)currentPos).func_178788_d(directionVec.func_186678_a(0.53125)).func_178787_e(offset);
                        BlockRayTraceResult blockraytraceresult = world.func_217296_a(rayStart, rayEnd = rayStart.func_178787_e(directionVec.func_186678_a(1.03125)), currentPos, voxelshape, state);
                        if (blockraytraceresult != null) {
                            double distance = (double)(i - 1) + blockraytraceresult.func_216347_e().func_72438_d(rayStart);
                            if (!((double)limitedDistance < distance)) continue;
                            limitedDistance = (float)distance;
                            continue;
                        }
                        break block5;
                    }
                    max = limitedDistance;
                    break;
                }
            }
            ++i;
        }
        return max;
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.getAirCurrentWorld().func_72839_b(null, this.bounds);
    }

    public void findAffectedHandlers() {
        World world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        this.affectedItemHandlers.clear();
        int i = 0;
        while ((float)i < this.maxDistance + 1.0f) {
            InWorldProcessing.Type type = this.getSegmentAt(i);
            if (type != null) {
                for (int offset : Iterate.zeroAndOne) {
                    BlockPos pos = start.func_177967_a(this.direction, i).func_177979_c(offset);
                    TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, TransportedItemStackHandlerBehaviour.TYPE);
                    if (behaviour != null) {
                        this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>)Pair.of((Object)behaviour, (Object)((Object)type)));
                    }
                    if (this.direction.func_176740_k().func_200128_b()) break;
                }
            }
            ++i;
        }
    }

    public void tickAffectedHandlers() {
        for (Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type> pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            World world = handler.getWorld();
            InWorldProcessing.Type processingType = (InWorldProcessing.Type)((Object)pair.getRight());
            handler.handleProcessingOnAllItems(transported -> {
                InWorldProcessing.spawnParticlesForProcessing(world, handler.getWorldPositionOf((TransportedItemStack)transported), processingType);
                if (world.field_72995_K) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                return InWorldProcessing.applyProcessing(transported, world, processingType);
            });
        }
    }

    private static boolean shouldAlwaysPass(BlockState state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    public InWorldProcessing.Type getSegmentAt(float offset) {
        for (AirCurrentSegment airCurrentSegment : this.segments) {
            if (offset > (float)airCurrentSegment.endOffset && this.pushing || offset < (float)airCurrentSegment.endOffset && !this.pushing) continue;
            return airCurrentSegment.type;
        }
        return InWorldProcessing.Type.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enableClientPlayerSound(Entity e, float maxVolume) {
        if (e != Minecraft.func_71410_x().func_175606_aa()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)MathHelper.func_151237_a((double)(e.func_213322_ci().func_72433_c() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.func_147667_k()) {
            flyingSound = new AirCurrentSound(SoundEvents.field_189426_aK, pitch);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stop();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    public static boolean isPlayerCreativeFlying(Entity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return player.func_184812_l_() && player.field_71075_bZ.field_75100_b;
        }
        return false;
    }

    public static class AirCurrentSegment {
        InWorldProcessing.Type type;
        int startOffset;
        int endOffset;
    }
}

