/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressBlock;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class PressInstance
extends ShaftInstance
implements IDynamicInstance {
    private final OrientedData pressHead;
    private final MechanicalPressTileEntity press;

    public PressInstance(MaterialManager<?> dispatcher, MechanicalPressTileEntity tile) {
        super(dispatcher, tile);
        this.press = tile;
        this.pressHead = (OrientedData)dispatcher.getOrientedMaterial().getModel(AllBlockPartials.MECHANICAL_PRESS_HEAD, this.blockState).createInstance();
        Quaternion q = Vector3f.field_229181_d_.func_229187_a_(AngleHelper.horizontalAngle((Direction)this.blockState.func_177229_b(MechanicalPressBlock.HORIZONTAL_FACING)));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        if (!this.press.running) {
            return;
        }
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset(this.press);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(MechanicalPressTileEntity press) {
        return press.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.pressHead});
    }

    @Override
    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

