/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.sync.ClientMotionPacket;
import com.simibubi.create.foundation.collision.ContinuousOBBCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OrientedBB;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class ContraptionCollider {
    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        World world = contraptionEntity.func_130014_f_();
        Contraption contraption = contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        Vector3d contraptionPosition = contraptionEntity.func_213303_ch();
        Vector3d contraptionMotion = contraptionPosition.func_178788_d(contraptionEntity.getPrevPositionVec());
        Vector3d anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        boolean skipClientPlayer = false;
        List entitiesWithinAABB = world.func_175647_a(Entity.class, bounds.func_186662_g(2.0).func_72321_a(0.0, 32.0, 0.0), contraptionEntity::canCollideWith);
        for (Entity entity : entitiesWithinAABB) {
            double d1;
            double idealVerticalMotion;
            boolean anyCollision;
            Vector3d entityMotion;
            PlayerType playerType = ContraptionCollider.getPlayerType(entity);
            if (playerType == PlayerType.REMOTE) continue;
            if (playerType == PlayerType.SERVER && entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.field_147365_f = 0;
                continue;
            }
            if (playerType == PlayerType.CLIENT) {
                if (skipClientPlayer) continue;
                skipClientPlayer = true;
            }
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            Vector3d entityPosition = entity.func_213303_ch();
            AxisAlignedBB entityBounds = entity.func_174813_aQ();
            Vector3d motion = entity.func_213322_ci();
            float yawOffset = rotation.getYawOffset();
            Vector3d position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            AxisAlignedBB localBB = entityBounds.func_191194_a(position).func_186662_g(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            motion = motion.func_178788_d(contraptionMotion);
            Vector3d motionCopy = motion = rotationMatrix.transform(motion);
            List collidableBBs = contraption.simplifiedEntityColliders.orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                ReuseableStream<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.func_216361_a(motionCopy));
                potentialHits.func_212761_a().forEach(shape -> shape.func_197756_d().forEach(bbs::add));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)Vector3d.field_186680_a);
            MutableObject normal = new MutableObject((Object)Vector3d.field_186680_a);
            MutableObject location = new MutableObject((Object)Vector3d.field_186680_a);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            Vector3d obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (AxisAlignedBB bb : collidableBBs) {
                    boolean nearest;
                    Vector3d separation;
                    double timeOfImpact;
                    Vector3d currentResponse = (Vector3d)collisionResponse.getValue();
                    Vector3d currentCenter = obbCenter.func_178787_e(currentResponse);
                    if (Math.abs(currentCenter.field_72450_a - bb.func_189972_c().field_72450_a) - entityBounds.func_216364_b() - 1.0 > bb.func_216364_b() / 2.0 || Math.abs(currentCenter.field_72448_b + motion.field_72448_b - bb.func_189972_c().field_72448_b) - entityBounds.func_216360_c() - 1.0 > bb.func_216360_c() / 2.0 || Math.abs(currentCenter.field_72449_c - bb.func_189972_c().field_72449_c) - entityBounds.func_216362_d() - 1.0 > bb.func_216362_d() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    Vector3d collidingNormal = intersect.getCollisionNormal();
                    Vector3d collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.field_70138_W)) != null && !separation.equals((Object)Vector3d.field_186680_a)) {
                        collisionResponse.setValue((Object)currentResponse.func_178787_e(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((Vector3d)collisionResponse.getValue()).field_72448_b == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((Vector3d)collisionResponse.getValue()).func_216372_d(1.0078125, 0.0, 1.0078125));
            }
            Vector3d entityMotionNoTemporal = entityMotion = entity.func_213322_ci();
            Vector3d collisionNormal = (Vector3d)normal.getValue();
            Vector3d collisionLocation = (Vector3d)location.getValue();
            Vector3d totalResponse = (Vector3d)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)Vector3d.field_186680_a);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            Vector3d motionResponse = !temporalCollision ? motion : motion.func_72432_b().func_186678_a(motion.func_72433_c() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).func_178787_e(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, Direction.Axis.Y);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, Direction.Axis.Y);
            collisionNormal = collisionNormal.func_72432_b();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, Direction.Axis.Y);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)Vector3d.field_186680_a)) {
                collisionLocation = collisionLocation.func_178787_e(entity.func_213303_ch().func_178787_e(entity.func_174813_aQ().func_189972_c()).func_186678_a(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.func_72441_c(0.0, motionResponse.field_72448_b, 0.0);
                }
                BlockPos pos = new BlockPos(contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    BlockState blockState = contraption.getBlocks().get((Object)pos).field_186243_b;
                    bounce = BlockHelper.getBounceMultiplier(blockState.func_177230_c());
                    slide = Math.max(0.0f, blockState.getSlipperiness((IWorldReader)contraption.world, pos, entity) - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)Vector3d.field_186680_a);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.field_70170_p.func_184148_a(playerType == PlayerType.CLIENT ? (PlayerEntity)entity : null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187876_fn, SoundCategory.BLOCKS, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.field_72448_b) != entityMotion.field_72448_b) {
                entity.func_213317_d(entityMotion.func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.func_213322_ci();
            }
            if (hardCollision) {
                double motionX = entityMotion.func_82615_a();
                double motionY = entityMotion.func_82617_b();
                double motionZ = entityMotion.func_82616_c();
                double intersectX = totalResponse.func_82615_a();
                double intersectY = totalResponse.func_82617_b();
                double intersectZ = totalResponse.func_82616_c();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.func_216372_d(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, contraptionMotion.field_72448_b, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.func_216372_d(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.func_216372_d(1.0, 0.0, 1.0).func_72433_c() * 1.25;
                Vector3d motionIn = entityMotionNoTemporal.func_216372_d(0.0, 0.9, 0.0).func_72441_c(0.0, (double)-0.01f, 0.0);
                Vector3d slideNormal = collisionNormal.func_72431_c(motionIn.func_72431_c(collisionNormal)).func_72432_b();
                Vector3d newMotion = entityMotion.func_216372_d(0.85, 0.0, 0.85).func_178787_e(slideNormal.func_186678_a(((double)0.2f + slide) * motionIn.func_72433_c() * slideFactor).func_72441_c(0.0, (double)-0.1f - collisionNormal.field_72448_b * 0.125, 0.0));
                entity.func_213317_d(newMotion);
                entityMotion = entity.func_213322_ci();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            Vector3d allowedMovement = ContraptionCollider.getAllowedMovement(totalResponse, entity);
            entity.func_70107_b(entityPosition.field_72450_a + allowedMovement.field_72450_a, entityPosition.field_72448_b + allowedMovement.field_72448_b, entityPosition.field_72449_c + allowedMovement.field_72449_c);
            entityPosition = entity.func_213303_ch();
            entity.field_70133_I = true;
            Vector3d contactPointMotion = Vector3d.field_186680_a;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                entity.field_70143_R = 0.0f;
                contraptionEntity.collidingEntities.put(entity, new MutableInt(0));
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.field_70122_E = true;
                    }
                    if (entity instanceof ItemEntity) {
                        entityMotion = entityMotion.func_216372_d(0.5, 1.0, 0.5);
                    }
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.getAllowedMovement(contactPointMotion, entity);
                entity.func_70107_b(entityPosition.field_72450_a + allowedMovement.field_72450_a, entityPosition.field_72448_b, entityPosition.field_72449_c + allowedMovement.field_72449_c);
            }
            entity.func_213317_d(entityMotion);
            if (playerType != PlayerType.CLIENT) continue;
            double d0 = entity.func_226277_ct_() - entity.field_70169_q - contactPointMotion.field_72450_a;
            float limbSwing = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = entity.func_226281_cx_() - entity.field_70166_s - contactPointMotion.field_72449_c) * d1)) * 4.0f;
            if (limbSwing > 1.0f) {
                limbSwing = 1.0f;
            }
            AllPackets.channel.sendToServer((Object)new ClientMotionPacket(entityMotion, true, limbSwing));
        }
    }

    static boolean bounceEntity(Entity entity, Vector3d normal, AbstractContraptionEntity contraption, double factor) {
        if (factor == 0.0) {
            return false;
        }
        if (entity.func_226272_bl_()) {
            return false;
        }
        Vector3d contactPointMotion = contraption.getContactPointMotion(entity.func_213303_ch());
        Vector3d motion = entity.func_213322_ci().func_178788_d(contactPointMotion);
        Vector3d deltav = normal.func_186678_a(factor * 2.0 * motion.func_72430_b(normal));
        if (deltav.func_72430_b(deltav) < (double)0.1f) {
            return false;
        }
        entity.func_213317_d(entity.func_213322_ci().func_178788_d(deltav));
        return true;
    }

    public static Vector3d getWorldToLocalTranslation(Entity entity, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static Vector3d getWorldToLocalTranslation(Entity entity, Vector3d anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static Vector3d getWorldToLocalTranslation(Entity entity, Vector3d anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vector3d entityPosition = entity.func_213303_ch();
        Vector3d centerY = new Vector3d(0.0, entity.func_174813_aQ().func_216360_c() / 2.0, 0.0);
        Vector3d position = entityPosition;
        position = position.func_178787_e(centerY);
        position = position.func_178788_d(VecHelper.CENTER_OF_ORIGIN);
        position = position.func_178788_d(anchorVec);
        position = VecHelper.rotate(position, -yawOffset, Direction.Axis.Y);
        position = rotationMatrix.transform(position);
        position = position.func_178787_e(VecHelper.CENTER_OF_ORIGIN);
        position = position.func_178788_d(centerY);
        position = position.func_178788_d(entityPosition);
        return position;
    }

    public static Vector3d getWorldToLocalTranslation(Vector3d entity, AbstractContraptionEntity contraptionEntity) {
        return ContraptionCollider.getWorldToLocalTranslation(entity, contraptionEntity.getAnchorVec(), contraptionEntity.getRotationState());
    }

    public static Vector3d getWorldToLocalTranslation(Vector3d inPos, Vector3d anchorVec, AbstractContraptionEntity.ContraptionRotationState rotation) {
        return ContraptionCollider.getWorldToLocalTranslation(inPos, anchorVec, rotation.asMatrix(), rotation.getYawOffset());
    }

    public static Vector3d getWorldToLocalTranslation(Vector3d inPos, Vector3d anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vector3d position = inPos;
        position = position.func_178788_d(VecHelper.CENTER_OF_ORIGIN);
        position = position.func_178788_d(anchorVec);
        position = VecHelper.rotate(position, -yawOffset, Direction.Axis.Y);
        position = rotationMatrix.transform(position);
        position = position.func_178787_e(VecHelper.CENTER_OF_ORIGIN);
        position = position.func_178788_d(inPos);
        return position;
    }

    static Vector3d getAllowedMovement(Vector3d movement, Entity e) {
        boolean notMovingUp;
        AxisAlignedBB bb = e.func_174813_aQ();
        ISelectionContext ctx = ISelectionContext.func_216374_a((Entity)e);
        World world = e.field_70170_p;
        VoxelShape voxelshape = world.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)bb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = world.func_230318_c_(e, bb.func_216361_a(movement), entity -> false);
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
        Vector3d allowedMovement = movement.func_189985_c() == 0.0 ? movement : Entity.func_223307_a((Entity)e, (Vector3d)movement, (AxisAlignedBB)bb, (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
        boolean xDifferent = movement.field_72450_a != allowedMovement.field_72450_a;
        boolean yDifferent = movement.field_72448_b != allowedMovement.field_72448_b;
        boolean zDifferent = movement.field_72449_c != allowedMovement.field_72449_c;
        boolean bl = notMovingUp = e.func_233570_aj_() || yDifferent && movement.field_72448_b < 0.0;
        if (e.field_70138_W > 0.0f && notMovingUp && (xDifferent || zDifferent)) {
            Vector3d vec3;
            Vector3d allowedStep = Entity.func_223307_a((Entity)e, (Vector3d)new Vector3d(movement.field_72450_a, (double)e.field_70138_W, movement.field_72449_c), (AxisAlignedBB)bb, (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
            Vector3d allowedStepGivenMovement = Entity.func_223307_a((Entity)e, (Vector3d)new Vector3d(0.0, (double)e.field_70138_W, 0.0), (AxisAlignedBB)bb.func_72321_a(movement.field_72450_a, 0.0, movement.field_72449_c), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream);
            if (allowedStepGivenMovement.field_72448_b < (double)e.field_70138_W && Entity.func_213296_b((Vector3d)(vec3 = Entity.func_223307_a((Entity)e, (Vector3d)new Vector3d(movement.field_72450_a, 0.0, movement.field_72449_c), (AxisAlignedBB)bb.func_191194_a(allowedStepGivenMovement), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream).func_178787_e(allowedStepGivenMovement))) > Entity.func_213296_b((Vector3d)allowedStep)) {
                allowedStep = vec3;
            }
            if (Entity.func_213296_b((Vector3d)allowedStep) > Entity.func_213296_b((Vector3d)allowedMovement)) {
                return allowedStep.func_178787_e(Entity.func_223307_a((Entity)e, (Vector3d)new Vector3d(0.0, -allowedStep.field_72448_b + movement.field_72448_b, 0.0), (AxisAlignedBB)bb.func_191194_a(allowedStep), (World)world, (ISelectionContext)ctx, (ReuseableStream)reuseablestream));
            }
        }
        return allowedMovement;
    }

    private static PlayerType getPlayerType(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return PlayerType.NONE;
        }
        if (!entity.field_70170_p.field_72995_K) {
            return PlayerType.SERVER;
        }
        MutableBoolean isClient = new MutableBoolean(false);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> isClient.setValue(ContraptionCollider.isClientPlayerEntity(entity)));
        return isClient.booleanValue() ? PlayerType.CLIENT : PlayerType.REMOTE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isClientPlayerEntity(Entity entity) {
        return entity instanceof ClientPlayerEntity;
    }

    private static ReuseableStream<VoxelShape> getPotentiallyCollidedShapes(World world, Contraption contraption, AxisAlignedBB localBB) {
        double width;
        double height = localBB.func_216360_c();
        double horizontalFactor = height > (width = localBB.func_216364_b()) && width != 0.0 ? height / width : 1.0;
        double verticalFactor = width > height && height != 0.0 ? width / height : 1.0;
        AxisAlignedBB blockScanBB = localBB.func_186662_g(0.5);
        blockScanBB = blockScanBB.func_72314_b(horizontalFactor, verticalFactor, horizontalFactor);
        BlockPos min = new BlockPos(blockScanBB.field_72340_a, blockScanBB.field_72338_b, blockScanBB.field_72339_c);
        BlockPos max = new BlockPos(blockScanBB.field_72336_d, blockScanBB.field_72337_e, blockScanBB.field_72334_f);
        ReuseableStream potentialHits = new ReuseableStream(BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).filter(contraption.getBlocks()::containsKey).map(p -> {
            BlockState blockState = contraption.getBlocks().get((Object)p).field_186243_b;
            BlockPos pos = contraption.getBlocks().get((Object)p).field_186242_a;
            VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)world, p);
            return collisionShape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }).filter((Predicate<VoxelShape>)Predicates.not(VoxelShape::func_197766_b)));
        return potentialHits;
    }

    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        if (!contraptionEntity.supportsTerrainCollision()) {
            return false;
        }
        World world = contraptionEntity.func_130014_f_();
        Vector3d motion = contraptionEntity.func_213322_ci();
        TranslatingContraption contraption = (TranslatingContraption)contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        Vector3d position = contraptionEntity.func_213303_ch();
        BlockPos gridPos = new BlockPos(position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vector3d.field_186680_a)) {
            return false;
        }
        Direction movementDirection = Direction.func_210769_a((double)motion.field_72450_a, (double)motion.field_72448_b, (double)motion.field_72449_c);
        if (movementDirection.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.func_177972_a(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : world.func_175647_a(ControlledContraptionEntity.class, bounds.func_186662_g(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vector3d otherMotion = otherContraptionEntity.func_213322_ci();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AxisAlignedBB otherBounds = otherContraptionEntity.func_174813_aQ();
            Vector3d otherPosition = otherContraptionEntity.func_213303_ch();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.func_191194_a(motion).func_72326_a(otherBounds.func_191194_a(otherMotion))) continue;
            for (BlockPos colliderPos : contraption.getColliders(world, movementDirection)) {
                colliderPos = colliderPos.func_177971_a((Vector3i)gridPos).func_177973_b((Vector3i)new BlockPos(otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(World world, TranslatingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getColliders(world, movementDirection)) {
            BlockBreakingMovementBehaviour behaviour;
            MovementBehaviour movementBehaviour;
            BlockPos colliderPos = pos.func_177971_a((Vector3i)anchor);
            if (!world.func_195588_v(colliderPos)) {
                return true;
            }
            BlockState collidedState = world.func_180495_p(colliderPos);
            Template.BlockInfo blockInfo = contraption.getBlocks().get(pos);
            if (!(AllMovementBehaviours.contains(blockInfo.field_186243_b.func_177230_c()) && (movementBehaviour = AllMovementBehaviours.of(blockInfo.field_186243_b.func_177230_c())) instanceof BlockBreakingMovementBehaviour ? !(behaviour = (BlockBreakingMovementBehaviour)movementBehaviour).canBreak(world, colliderPos, collidedState) && !collidedState.func_196952_d((IBlockReader)world, pos).func_197766_b() : (!AllBlocks.PULLEY_MAGNET.has(collidedState) || !pos.equals((Object)BlockPos.field_177992_a) || movementDirection != Direction.UP) && !(collidedState.func_177230_c() instanceof CocoaBlock) && !collidedState.func_185904_a().func_76222_j() && !collidedState.func_196952_d((IBlockReader)world, colliderPos).func_197766_b())) continue;
            return true;
        }
        return false;
    }

    static enum PlayerType {
        NONE,
        CLIENT,
        REMOTE,
        SERVER;

    }
}

