/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.WorldAttached;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ContraptionHandler {
    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions = new WorldAttached<Map>($ -> new HashMap());
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(World world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get((IWorld)world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get((IWorld)world);
        for (AbstractContraptionEntity contraptionEntity : queued) {
            map.put(contraptionEntity.func_145782_y(), new WeakReference<AbstractContraptionEntity>(contraptionEntity));
        }
        queued.clear();
        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator();
        while (iterator.hasNext()) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)weakReference.get());
            if (contraptionEntity == null || !contraptionEntity.func_70089_S()) {
                iterator.remove();
                continue;
            }
            ContraptionCollider.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(Entity entity, World world) {
        if (entity instanceof AbstractContraptionEntity) {
            queuedAdditions.get((IWorld)world).add((AbstractContraptionEntity)entity);
        }
    }

    public static void entitiesWhoJustDismountedGetSentToTheRightLocation(LivingEntity entityLiving, World world) {
        if (world.field_72995_K) {
            return;
        }
        CompoundNBT data = entityLiving.getPersistentData();
        if (!data.func_74764_b("ContraptionDismountLocation")) {
            return;
        }
        Vector3d position = VecHelper.readNBT(data.func_150295_c("ContraptionDismountLocation", 6));
        if (entityLiving.func_184187_bx() == null) {
            entityLiving.func_70634_a(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        }
        data.func_82580_o("ContraptionDismountLocation");
    }
}

