/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedBearingInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StabilizedBearingMovementBehaviour
extends MovementBehaviour {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        if (Backend.getInstance().canUseInstancing()) {
            return;
        }
        Direction facing = (Direction)context.state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        PartialModel top = AllBlockPartials.BEARING_TOP;
        SuperByteBuffer superBuffer = PartialBufferer.get(top, context.state);
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        Quaternion orientation = BearingInstance.getBlockStateOrientation(facing);
        float angle = StabilizedBearingMovementBehaviour.getCounterRotationAngle(context, facing, renderPartialTicks) * (float)facing.func_176743_c().func_179524_a();
        Quaternion rotation = facing.func_229386_k_().func_229187_a_(angle);
        rotation.func_195890_a(orientation);
        orientation = rotation;
        superBuffer.transform(matrices.contraptionStack);
        superBuffer.rotateCentered(orientation);
        superBuffer.light(matrices.entityMatrix, ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.entityStack, buffer.getBuffer(RenderType.func_228639_c_()));
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager<?> materialManager, PlacementSimulationWorld simulationWorld, MovementContext context) {
        return new StabilizedBearingInstance(materialManager, simulationWorld, context);
    }

    static float getCounterRotationAngle(MovementContext context, Direction facing, float renderPartialTicks) {
        float offset = 0.0f;
        Direction.Axis axis = facing.func_176740_k();
        AbstractContraptionEntity entity = context.contraption.entity;
        if (entity instanceof ControlledContraptionEntity) {
            ControlledContraptionEntity controlledCE = (ControlledContraptionEntity)entity;
            if (context.contraption.canBeStabilized(facing, context.localPos)) {
                offset = -controlledCE.getAngle(renderPartialTicks);
            }
        } else if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (axis.func_200128_b()) {
                offset = -orientedCE.func_195046_g(renderPartialTicks);
            } else if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().func_176740_k() == axis) {
                offset = -orientedCE.func_195050_f(renderPartialTicks);
            }
        }
        return offset;
    }
}

