/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageRenderer;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class GantryCarriageInstance
extends ShaftInstance
implements IDynamicInstance {
    private final ModelData gantryCogs;
    final Direction facing;
    final Boolean alongFirst;
    final Direction.Axis rotationAxis;
    final float rotationMult;
    final BlockPos visualPos;
    private float lastAngle = Float.NaN;

    public GantryCarriageInstance(MaterialManager<?> dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.gantryCogs = (ModelData)this.getTransformMaterial().getModel(AllBlockPartials.GANTRY_COGS, this.blockState).createInstance();
        this.facing = (Direction)this.blockState.func_177229_b((Property)GantryCarriageBlock.FACING);
        this.alongFirst = (Boolean)this.blockState.func_177229_b((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.rotationAxis = KineticTileEntityRenderer.getRotationAxisOf(tile);
        this.rotationMult = GantryCarriageInstance.getRotationMultiplier(this.getGantryAxis(), this.facing);
        this.visualPos = this.facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? tile.func_174877_v() : tile.func_174877_v().func_177972_a(this.facing.func_176734_d());
        this.animateCogs(this.getCogAngle());
    }

    public void beginFrame() {
        float cogAngle = this.getCogAngle();
        if (MathHelper.func_180185_a((float)cogAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return GantryCarriageRenderer.getAngleForTe((KineticTileEntity)this.tile, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateCogs(float cogAngle) {
        MatrixStack ms = new MatrixStack();
        MatrixStacker.of(ms).translate((Vector3i)this.getInstancePosition()).centre().rotateY(AngleHelper.horizontalAngle(this.facing)).rotateX(this.facing == Direction.UP ? 0.0 : (this.facing == Direction.DOWN ? 180.0 : 90.0)).rotateY(this.alongFirst ^ this.facing.func_176740_k() == Direction.Axis.Z ? 90.0 : 0.0).translate(0.0, -0.5625, 0.0).multiply(Vector3f.field_229179_b_.func_229193_c_(-cogAngle)).translate(0.0, 0.5625, 0.0).unCentre();
        this.gantryCogs.setTransform(ms);
    }

    static float getRotationMultiplier(Direction.Axis gantryAxis, Direction facing) {
        float multiplier = 1.0f;
        if (gantryAxis == Direction.Axis.Z && facing == Direction.DOWN) {
            multiplier *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            multiplier *= -1.0f;
        }
        return multiplier;
    }

    private Direction.Axis getGantryAxis() {
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == this.rotationAxis || axis == this.facing.func_176740_k()) continue;
            gantryAxis = axis;
        }
        return gantryAxis;
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, new IFlatLight[]{this.gantryCogs, this.rotatingModel});
    }

    @Override
    public void remove() {
        super.remove();
        this.gantryCogs.delete();
    }
}

