/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.backend.instancing.ITickableInstance;
import com.jozufozu.flywheel.backend.instancing.InstanceMaterial;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.instancing.ConditionalInstance;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;

public class GlueInstance
extends EntityInstance<SuperGlueEntity>
implements ITickableInstance {
    private static final boolean USE_ATLAS = false;
    private static final ResourceLocation TEXTURE = new ResourceLocation("create", "textures/entity/super_glue/slime.png");
    private final Quaternion rotation;
    protected ConditionalInstance<OrientedData> model;

    public GlueInstance(MaterialManager<?> materialManager, SuperGlueEntity entity) {
        super(materialManager, (Entity)entity);
        Instancer<OrientedData> instancer = this.getInstancer(materialManager, entity);
        Direction face = entity.getFacingDirection();
        this.rotation = new Quaternion(AngleHelper.verticalAngle(face), AngleHelper.horizontalAngleNew(face), 0.0f, true);
        this.model = new ConditionalInstance(instancer).withCondition(this::shouldShow).withSetupFunc(this::positionModel).update();
    }

    private Instancer<OrientedData> getInstancer(MaterialManager<?> materialManager, SuperGlueEntity entity) {
        InstanceMaterial material = materialManager.getMaterial(Materials.ORIENTED, TEXTURE);
        return material.get((Object)entity.func_200600_R(), GlueInstance::supplyModel);
    }

    public void tick() {
        this.model.update();
    }

    public void remove() {
        this.model.delete();
    }

    private void positionModel(OrientedData model) {
        model.setPosition(this.getInstancePosition()).setPivot(0.0f, 0.0f, 0.0f).setRotation(this.rotation);
        this.updateLight(model);
    }

    public void updateLight() {
        this.model.get().ifPresent(this::updateLight);
    }

    private void updateLight(OrientedData model) {
        BlockPos pos = ((SuperGlueEntity)this.entity).getHangingPosition();
        model.setBlockLight(this.world.func_226658_a_(LightType.BLOCK, pos)).setSkyLight(this.world.func_226658_a_(LightType.SKY, pos));
    }

    private boolean shouldShow() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return ((SuperGlueEntity)this.entity).isVisible() || AllItems.SUPER_GLUE.isIn(player.func_184614_ca()) || AllItems.SUPER_GLUE.isIn(player.func_184592_cb());
    }

    public static BufferedModel supplyModel() {
        Vector3d diff = Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m());
        Vector3d extension = diff.func_72432_b().func_186678_a(0.0234375);
        Vector3d plane = VecHelper.axisAlingedPlaneOf(diff);
        Direction.Axis axis = Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c).func_176740_k();
        Vector3d start = Vector3d.field_186680_a.func_178788_d(extension);
        Vector3d end = Vector3d.field_186680_a.func_178787_e(extension);
        plane = plane.func_186678_a(0.5);
        Vector3d a1 = plane.func_178787_e(start);
        Vector3d b1 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a2 = plane.func_178787_e(start);
        Vector3d b2 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a3 = plane.func_178787_e(start);
        Vector3d b3 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a4 = plane.func_178787_e(start);
        Vector3d b4 = plane.func_178787_e(end);
        VecBuffer buffer = VecBuffer.allocate((int)(Formats.UNLIT_MODEL.getStride() * 8));
        float minV = 0.0f;
        float minU = 0.0f;
        float maxV = 1.0f;
        float maxU = 1.0f;
        buffer.putVec3((float)a1.field_72450_a, (float)a1.field_72448_b, (float)a1.field_72449_c).putVec3((byte)0, (byte)0, (byte)-127).putVec2(maxU, minV);
        buffer.putVec3((float)a2.field_72450_a, (float)a2.field_72448_b, (float)a2.field_72449_c).putVec3((byte)0, (byte)0, (byte)-127).putVec2(maxU, maxV);
        buffer.putVec3((float)a3.field_72450_a, (float)a3.field_72448_b, (float)a3.field_72449_c).putVec3((byte)0, (byte)0, (byte)-127).putVec2(minU, maxV);
        buffer.putVec3((float)a4.field_72450_a, (float)a4.field_72448_b, (float)a4.field_72449_c).putVec3((byte)0, (byte)0, (byte)-127).putVec2(minU, minV);
        buffer.putVec3((float)b4.field_72450_a, (float)b4.field_72448_b, (float)b4.field_72449_c).putVec3((byte)0, (byte)0, (byte)127).putVec2(minU, minV);
        buffer.putVec3((float)b3.field_72450_a, (float)b3.field_72448_b, (float)b3.field_72449_c).putVec3((byte)0, (byte)0, (byte)127).putVec2(minU, maxV);
        buffer.putVec3((float)b2.field_72450_a, (float)b2.field_72448_b, (float)b2.field_72449_c).putVec3((byte)0, (byte)0, (byte)127).putVec2(maxU, maxV);
        buffer.putVec3((float)b1.field_72450_a, (float)b1.field_72448_b, (float)b1.field_72449_c).putVec3((byte)0, (byte)0, (byte)127).putVec2(maxU, minV);
        buffer.rewind();
        return IndexedModel.fromSequentialQuads((VertexFormat)Formats.UNLIT_MODEL, (ByteBuffer)buffer.unwrap(), (int)8);
    }
}

