/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SuperGlueRenderer
extends EntityRenderer<SuperGlueEntity> {
    private ResourceLocation regular = new ResourceLocation("create", "textures/entity/super_glue/slime.png");
    private float[] insideQuad;
    private float[] outsideQuad;

    public SuperGlueRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.initQuads();
    }

    public ResourceLocation getEntityTexture(SuperGlueEntity entity) {
        return this.regular;
    }

    public boolean shouldRender(SuperGlueEntity entity, ClippingHelper frustum, double x, double y, double z) {
        if (super.func_225626_a_((Entity)entity, frustum, x, y, z)) {
            boolean holdingGlue;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            boolean visible = entity.isVisible();
            boolean bl = holdingGlue = AllItems.SUPER_GLUE.isIn(player.func_184614_ca()) || AllItems.SUPER_GLUE.isIn(player.func_184592_cb());
            if (visible || holdingGlue) {
                return true;
            }
        }
        return false;
    }

    public void render(SuperGlueEntity entity, float yaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        super.func_225623_a_((Entity)entity, yaw, partialTicks, ms, buffer, light);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getEntityTexture(entity)));
        light = this.getBrightnessForRender(entity);
        Direction face = entity.getFacingDirection();
        ms.func_227860_a_();
        MatrixStacker.of(ms).rotateY(AngleHelper.horizontalAngleNew(face)).rotateX(AngleHelper.verticalAngle(face));
        MatrixStack.Entry peek = ms.func_227866_c_();
        this.renderQuad(builder, peek, this.insideQuad, light, -1.0f);
        this.renderQuad(builder, peek, this.outsideQuad, light, 1.0f);
        ms.func_227865_b_();
    }

    private void initQuads() {
        Vector3d diff = Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m());
        Vector3d extension = diff.func_72432_b().func_186678_a(0.0234375);
        Vector3d plane = VecHelper.axisAlingedPlaneOf(diff);
        Direction.Axis axis = Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c).func_176740_k();
        Vector3d start = Vector3d.field_186680_a.func_178788_d(extension);
        Vector3d end = Vector3d.field_186680_a.func_178787_e(extension);
        plane = plane.func_186678_a(0.5);
        Vector3d a1 = plane.func_178787_e(start);
        Vector3d b1 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a2 = plane.func_178787_e(start);
        Vector3d b2 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a3 = plane.func_178787_e(start);
        Vector3d b3 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a4 = plane.func_178787_e(start);
        Vector3d b4 = plane.func_178787_e(end);
        this.insideQuad = new float[]{(float)a1.field_72450_a, (float)a1.field_72448_b, (float)a1.field_72449_c, 1.0f, 0.0f, (float)a2.field_72450_a, (float)a2.field_72448_b, (float)a2.field_72449_c, 1.0f, 1.0f, (float)a3.field_72450_a, (float)a3.field_72448_b, (float)a3.field_72449_c, 0.0f, 1.0f, (float)a4.field_72450_a, (float)a4.field_72448_b, (float)a4.field_72449_c, 0.0f, 0.0f};
        this.outsideQuad = new float[]{(float)b4.field_72450_a, (float)b4.field_72448_b, (float)b4.field_72449_c, 0.0f, 0.0f, (float)b3.field_72450_a, (float)b3.field_72448_b, (float)b3.field_72449_c, 0.0f, 1.0f, (float)b2.field_72450_a, (float)b2.field_72448_b, (float)b2.field_72449_c, 1.0f, 1.0f, (float)b1.field_72450_a, (float)b1.field_72448_b, (float)b1.field_72449_c, 1.0f, 0.0f};
    }

    private int getBrightnessForRender(SuperGlueEntity entity) {
        BlockPos blockpos = entity.getHangingPosition();
        BlockPos blockpos2 = blockpos.func_177972_a(entity.getFacingDirection().func_176734_d());
        World world = entity.func_130014_f_();
        int light = world.func_195588_v(blockpos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos) : 15;
        int light2 = world.func_195588_v(blockpos2) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos2) : 15;
        return Math.max(light, light2);
    }

    private void renderQuad(IVertexBuilder builder, MatrixStack.Entry matrix, float[] data, int light, float normalZ) {
        for (int i = 0; i < 4; ++i) {
            builder.func_227888_a_(matrix.func_227870_a_(), data[5 * i], data[5 * i + 1], data[5 * i + 2]).func_225586_a_(255, 255, 255, 255).func_225583_a_(data[5 * i + 3], data[5 * i + 4]).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix.func_227872_b_(), 0.0f, 0.0f, normalZ).func_181675_d();
        }
    }
}

