/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.core.instancing.ConditionalInstance;
import com.jozufozu.flywheel.core.instancing.GroupInstance;
import com.jozufozu.flywheel.core.instancing.SelectInstance;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.jozufozu.flywheel.light.GridAlignedBB;
import com.jozufozu.flywheel.light.ILightUpdateListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import java.util.Arrays;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;

public abstract class AbstractPulleyInstance
extends ShaftInstance
implements IDynamicInstance,
ILightUpdateListener {
    final OrientedData coil;
    final SelectInstance<OrientedData> magnet;
    final GroupInstance<OrientedData> rope;
    final ConditionalInstance<OrientedData> halfRope;
    protected float offset;
    protected final Direction rotatingAbout;
    protected final Vector3f rotationAxis;
    private byte[] bLight = new byte[1];
    private byte[] sLight = new byte[1];
    private GridAlignedBB volume;

    public AbstractPulleyInstance(MaterialManager<?> dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.rotatingAbout = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis);
        this.rotationAxis = this.rotatingAbout.func_229386_k_();
        this.coil = ((OrientedData)this.getCoilModel().createInstance()).setPosition(this.getInstancePosition());
        this.magnet = new SelectInstance(this::getMagnetModelIndex);
        this.magnet.addModel(this.getMagnetModel()).addModel(this.getHalfMagnetModel());
        this.rope = new GroupInstance(this.getRopeModel());
        this.halfRope = new ConditionalInstance(this.getHalfRopeModel()).withCondition(this::shouldRenderHalfRope);
    }

    public void beginFrame() {
        this.updateOffset();
        this.transformModels();
    }

    private void transformModels() {
        this.resizeRope();
        this.coil.setRotation(this.rotationAxis.func_229187_a_(this.offset * 180.0f));
        this.magnet.update().get().ifPresent(data -> {
            int index = Math.max(0, MathHelper.func_76141_d((float)this.offset));
            data.setPosition(this.getInstancePosition()).nudge(0.0f, -this.offset, 0.0f).setBlockLight((int)this.bLight[index]).setSkyLight((int)this.sLight[index]);
        });
        this.halfRope.update().get().ifPresent(rope -> {
            float f = this.offset % 1.0f;
            float halfRopeNudge = f > 0.75f ? f - 1.0f : f;
            rope.setPosition(this.getInstancePosition()).nudge(0.0f, -halfRopeNudge, 0.0f).setBlockLight((int)this.bLight[0]).setSkyLight((int)this.sLight[0]);
        });
        if (this.isRunning()) {
            int size = this.rope.size();
            for (int i = 0; i < size; ++i) {
                ((OrientedData)this.rope.get(i)).setPosition(this.getInstancePosition()).nudge(0.0f, -this.offset + (float)i + 1.0f, 0.0f).setBlockLight((int)this.bLight[size - i]).setSkyLight((int)this.sLight[size - i]);
            }
        } else {
            this.rope.clear();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.coil});
    }

    @Override
    public void remove() {
        super.remove();
        this.coil.delete();
        this.magnet.delete();
        this.rope.clear();
        this.halfRope.delete();
    }

    protected abstract Instancer<OrientedData> getRopeModel();

    protected abstract Instancer<OrientedData> getMagnetModel();

    protected abstract Instancer<OrientedData> getHalfMagnetModel();

    protected abstract Instancer<OrientedData> getCoilModel();

    protected abstract Instancer<OrientedData> getHalfRopeModel();

    protected abstract float getOffset();

    protected abstract boolean isRunning();

    protected void resizeRope() {
        int neededRopeCount = this.getNeededRopeCount();
        this.rope.resize(neededRopeCount);
        int length = MathHelper.func_76123_f((float)this.offset);
        if (this.volume == null || this.bLight.length < length + 1) {
            this.volume = GridAlignedBB.from((BlockPos)this.pos.func_177979_c(length), (BlockPos)this.pos);
            this.volume.fixMinMax();
            this.bLight = Arrays.copyOf(this.bLight, length + 1);
            this.sLight = Arrays.copyOf(this.sLight, length + 1);
            this.initLight((IBlockDisplayReader)this.world, this.volume);
            LightUpdater.getInstance().startListening(this.volume, (ILightUpdateListener)this);
        }
    }

    private void updateOffset() {
        this.offset = this.getOffset();
    }

    private int getNeededRopeCount() {
        return Math.max(0, MathHelper.func_76123_f((float)(this.offset - 1.25f)));
    }

    private boolean shouldRenderHalfRope() {
        float f = this.offset % 1.0f;
        return this.offset > 0.75f && (f < 0.25f || f > 0.75f);
    }

    private int getMagnetModelIndex() {
        if (this.isRunning() || this.offset == 0.0f) {
            return this.offset > 0.25f ? 0 : 1;
        }
        return -1;
    }

    public boolean decreaseFramerateWithDistance() {
        return false;
    }

    public boolean onLightUpdate(IBlockDisplayReader world, LightType type, GridAlignedBB changed) {
        changed.intersectAssign(this.volume);
        this.initLight(world, changed);
        return false;
    }

    private void initLight(IBlockDisplayReader world, GridAlignedBB changed) {
        int top = this.pos.func_177956_o();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        changed.forEachContained((x, y, z) -> {
            pos.func_181079_c(x, y, z);
            byte block = (byte)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            byte sky = (byte)world.func_226658_a_(LightType.SKY, (BlockPos)pos);
            int i = top - y;
            this.bLight[i] = block;
            this.sLight[i] = sky;
        });
    }
}

