/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class ContraptionMatrices {
    public final MatrixStack entityStack;
    public final MatrixStack contraptionStack;
    public final Matrix4f entityMatrix;

    public ContraptionMatrices(MatrixStack entityStack, AbstractContraptionEntity entity) {
        this.entityStack = entityStack;
        this.contraptionStack = new MatrixStack();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        entity.doLocalTransforms(partialTicks, new MatrixStack[]{this.contraptionStack});
        this.entityMatrix = ContraptionMatrices.translateTo(entity, partialTicks);
    }

    public MatrixStack getFinalStack() {
        MatrixStack finalStack = new MatrixStack();
        ContraptionMatrices.transform(finalStack, this.entityStack);
        ContraptionMatrices.transform(finalStack, this.contraptionStack);
        return finalStack;
    }

    public Matrix4f getFinalModel() {
        Matrix4f finalModel = this.entityStack.func_227866_c_().func_227870_a_().func_226601_d_();
        finalModel.func_226595_a_(this.contraptionStack.func_227866_c_().func_227870_a_());
        return finalModel;
    }

    public Matrix3f getFinalNormal() {
        Matrix3f finalNormal = this.entityStack.func_227866_c_().func_227872_b_().func_226121_d_();
        finalNormal.func_226118_b_(this.contraptionStack.func_227866_c_().func_227872_b_());
        return finalNormal;
    }

    public Matrix4f getFinalLight() {
        Matrix4f lightTransform = this.entityMatrix.func_226601_d_();
        lightTransform.func_226595_a_(this.contraptionStack.func_227866_c_().func_227870_a_());
        return lightTransform;
    }

    public static Matrix4f translateTo(Entity entity, float partialTicks) {
        double x = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double y = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
        double z = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        return Matrix4f.func_226599_b_((float)((float)x), (float)((float)y), (float)((float)z));
    }

    public static void transform(MatrixStack ms, MatrixStack transform) {
        ms.func_227866_c_().func_227870_a_().func_226595_a_(transform.func_227866_c_().func_227870_a_());
        ms.func_227866_c_().func_227872_b_().func_226118_b_(transform.func_227866_c_().func_227872_b_());
    }
}

