/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionWorldHolder;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.render.AllProgramSpecs;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ContraptionRenderDispatcher {
    private static final Lazy<BlockModelRenderer> MODEL_RENDERER = Lazy.of(() -> new BlockModelRenderer(Minecraft.func_71410_x().func_184125_al()));
    private static final Lazy<BlockModelShapes> BLOCK_MODELS = Lazy.of(() -> Minecraft.func_71410_x().func_209506_al().func_174954_c());
    private static int worldHolderRefreshCounter;
    public static final Int2ObjectMap<RenderedContraption> RENDERERS;
    public static final Int2ObjectMap<ContraptionWorldHolder> WORLD_HOLDERS;
    public static final Compartment<Pair<Contraption, Integer>> CONTRAPTION;

    public static void tick() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (RenderedContraption contraption : RENDERERS.values()) {
            ContraptionLighter<?> lighter = contraption.getLighter();
            if (lighter.getBounds().volume() < (Integer)AllConfigs.CLIENT.maxContraptionLightVolume.get()) {
                lighter.tick(contraption);
            }
            contraption.kinetics.tick();
        }
        if (++worldHolderRefreshCounter >= 20) {
            ContraptionRenderDispatcher.removeDeadHolders();
            worldHolderRefreshCounter = 0;
        }
    }

    @SubscribeEvent
    public static void beginFrame(BeginFrameEvent event) {
        ActiveRenderInfo info = event.getInfo();
        double camX = info.func_216785_c().field_72450_a;
        double camY = info.func_216785_c().field_72448_b;
        double camZ = info.func_216785_c().field_72449_c;
        for (RenderedContraption renderer : RENDERERS.values()) {
            renderer.beginFrame(info, camX, camY, camZ);
        }
    }

    @SubscribeEvent
    public static void renderLayer(RenderLayerEvent event) {
        ContraptionRenderDispatcher.removeDeadContraptions();
        if (RENDERERS.isEmpty()) {
            return;
        }
        RenderType layer = event.getType();
        layer.func_228547_a_();
        GL11.glEnable((int)32879);
        GL13.glActiveTexture((int)33988);
        if (Backend.getInstance().canUseVBOs()) {
            ContraptionProgram structureShader = (ContraptionProgram)CreateContexts.STRUCTURE.getProgram(AllProgramSpecs.STRUCTURE);
            structureShader.bind();
            structureShader.uploadViewProjection(event.viewProjection);
            structureShader.uploadCameraPos(event.camX, event.camY, event.camZ);
            for (RenderedContraption renderer : RENDERERS.values()) {
                renderer.doRenderLayer(layer, structureShader);
            }
        }
        if (Backend.getInstance().canUseInstancing()) {
            for (RenderedContraption renderer : RENDERERS.values()) {
                renderer.materialManager.render(layer, event.viewProjection, event.camX, event.camY, event.camZ, renderer::setup);
            }
        }
        GL11.glBindTexture((int)32879, (int)0);
        layer.func_228549_b_();
        GL11.glDisable((int)32879);
        GL13.glActiveTexture((int)33984);
        GL20.glUseProgram((int)0);
    }

    @SubscribeEvent
    public static void onRendererReload(ReloadRenderersEvent event) {
        ContraptionRenderDispatcher.invalidateAll();
    }

    public static void invalidateOnGatherContext(GatherContextEvent e) {
        ContraptionRenderDispatcher.invalidateAll();
    }

    public static void render(AbstractContraptionEntity entity, Contraption contraption, ContraptionMatrices matrices, IRenderTypeBuffer buffers) {
        World world = entity.field_70170_p;
        if (Backend.getInstance().canUseVBOs() && Backend.isFlywheelWorld((IWorld)world)) {
            RenderedContraption renderer = ContraptionRenderDispatcher.getRenderer(world, contraption);
            PlacementSimulationWorld renderWorld = renderer.renderWorld;
            ContraptionRenderDispatcher.renderDynamic(world, renderWorld, contraption, matrices, buffers);
        } else {
            ContraptionWorldHolder holder = ContraptionRenderDispatcher.getWorldHolder(world, contraption);
            PlacementSimulationWorld renderWorld = holder.renderWorld;
            ContraptionRenderDispatcher.renderDynamic(world, renderWorld, contraption, matrices, buffers);
            ContraptionRenderDispatcher.renderStructure(world, renderWorld, contraption, matrices, buffers);
        }
    }

    private static RenderedContraption getRenderer(World world, Contraption c) {
        int entityId = c.entity.func_145782_y();
        RenderedContraption contraption = (RenderedContraption)RENDERERS.get(entityId);
        if (contraption == null) {
            PlacementSimulationWorld renderWorld = ContraptionRenderDispatcher.setupRenderWorld(world, c);
            contraption = new RenderedContraption(c, renderWorld);
            RENDERERS.put(entityId, (Object)contraption);
        }
        return contraption;
    }

    private static ContraptionWorldHolder getWorldHolder(World world, Contraption c) {
        int entityId = c.entity.func_145782_y();
        ContraptionWorldHolder holder = (ContraptionWorldHolder)WORLD_HOLDERS.get(entityId);
        if (holder == null) {
            PlacementSimulationWorld renderWorld = ContraptionRenderDispatcher.setupRenderWorld(world, c);
            holder = new ContraptionWorldHolder(c, renderWorld);
            WORLD_HOLDERS.put(entityId, (Object)holder);
        }
        return holder;
    }

    public static PlacementSimulationWorld setupRenderWorld(World world, Contraption c) {
        PlacementSimulationWorld renderWorld = new PlacementSimulationWorld(world);
        renderWorld.setTileEntities(c.presentTileEntities.values());
        for (Template.BlockInfo info : c.getBlocks().values()) {
            renderWorld.func_180501_a(info.field_186242_a, info.field_186243_b, 128);
        }
        renderWorld.updateLightSources();
        renderWorld.lighter.func_215575_a(Integer.MAX_VALUE, false, false);
        return renderWorld;
    }

    public static void renderDynamic(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        ContraptionRenderDispatcher.renderTileEntities(world, renderWorld, c, matrices, buffer);
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        ContraptionRenderDispatcher.renderActors(world, renderWorld, c, matrices, buffer);
    }

    public static void renderTileEntities(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, c.specialRenderedTileEntities, matrices.getFinalStack(), matrices.getFinalLight(), buffer);
    }

    protected static void renderActors(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.getLeft();
            MatrixStack m = matrices.contraptionStack;
            m.func_227860_a_();
            MatrixStacker.of(m).translate((Vector3i)blockInfo.field_186242_a);
            MovementBehaviour movementBehaviour = AllMovementBehaviours.of(blockInfo.field_186243_b);
            if (movementBehaviour != null) {
                movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            }
            m.func_227865_b_();
        }
    }

    public static void renderStructure(World world, PlacementSimulationWorld renderWorld, Contraption c, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        SuperByteBufferCache bufferCache = CreateClient.BUFFER_CACHE;
        List blockLayers = RenderType.func_228661_n_();
        buffer.getBuffer(RenderType.func_228639_c_());
        for (int i = 0; i < blockLayers.size(); ++i) {
            RenderType layer = (RenderType)blockLayers.get(i);
            Pair key = Pair.of((Object)c, (Object)i);
            SuperByteBuffer contraptionBuffer = bufferCache.get(CONTRAPTION, key, () -> ContraptionRenderDispatcher.buildStructureBuffer(renderWorld, c, layer));
            if (contraptionBuffer.isEmpty()) continue;
            contraptionBuffer.transform(matrices.contraptionStack).light(matrices.entityMatrix).hybridLight().renderInto(matrices.entityStack, buffer.getBuffer(layer));
        }
    }

    private static SuperByteBuffer buildStructureBuffer(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        BufferBuilder builder = ContraptionRenderDispatcher.buildStructure(renderWorld, c, layer);
        return new SuperByteBuffer(builder);
    }

    public static BufferBuilder buildStructure(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        MatrixStack ms = new MatrixStack();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        BlockModelRenderer.func_211847_a();
        for (Template.BlockInfo info : c.getBlocks().values()) {
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() != BlockRenderType.MODEL || !RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            BlockPos pos = info.field_186242_a;
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            ((BlockModelRenderer)MODEL_RENDERER.get()).renderModel((IBlockDisplayReader)renderWorld, ((BlockModelShapes)BLOCK_MODELS.get()).func_178125_b(state), state, pos, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
        BlockModelRenderer.func_210266_a();
        ForgeHooksClient.setRenderLayer(null);
        builder.func_178977_d();
        return builder;
    }

    public static int getLight(World world, float lx, float ly, float lz) {
        float offset;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float block = 0.0f;
        float sky = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    block += (float)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                    sky += (float)world.func_226658_a_(LightType.SKY, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return LightTexture.func_228451_a_((int)((int)block), (int)((int)sky));
    }

    public static int getContraptionWorldLight(MovementContext context, PlacementSimulationWorld renderWorld) {
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)renderWorld, (BlockPos)context.localPos);
    }

    public static void invalidateAll() {
        for (RenderedContraption renderer : RENDERERS.values()) {
            renderer.invalidate();
        }
        RENDERERS.clear();
        WORLD_HOLDERS.clear();
    }

    public static void removeDeadContraptions() {
        RENDERERS.values().removeIf(renderer -> {
            if (renderer.isDead()) {
                renderer.invalidate();
                return true;
            }
            return false;
        });
    }

    public static void removeDeadHolders() {
        WORLD_HOLDERS.values().removeIf(ContraptionWorldHolder::isDead);
    }

    static {
        RENDERERS = new Int2ObjectOpenHashMap();
        WORLD_HOLDERS = new Int2ObjectOpenHashMap();
        CONTRAPTION = new Compartment();
    }
}

