/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.attrib.CommonAttributes;
import com.jozufozu.flywheel.backend.gl.attrib.IAttribSpec;
import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.jozufozu.flywheel.backend.instancing.MaterialManager;
import com.jozufozu.flywheel.backend.model.ArrayModelRenderer;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.backend.model.ModelRenderer;
import com.jozufozu.flywheel.light.GridAlignedBB;
import com.jozufozu.flywheel.util.BufferBuilderReader;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionInstanceManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMaterialManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionWorldHolder;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;

public class RenderedContraption
extends ContraptionWorldHolder {
    public static final VertexFormat FORMAT = VertexFormat.builder().addAttributes(new IAttribSpec[]{CommonAttributes.VEC3, CommonAttributes.NORMAL, CommonAttributes.UV, CommonAttributes.RGBA, CommonAttributes.LIGHT}).build();
    private final ContraptionLighter<?> lighter;
    public final MaterialManager<ContraptionProgram> materialManager;
    public final ContraptionInstanceManager kinetics;
    private final Map<RenderType, ModelRenderer> renderLayers = new HashMap<RenderType, ModelRenderer>();
    private Matrix4f model;
    private AxisAlignedBB lightBox;

    public RenderedContraption(Contraption contraption, PlacementSimulationWorld renderWorld) {
        super(contraption, renderWorld);
        this.lighter = contraption.makeLighter();
        this.materialManager = new ContraptionMaterialManager(CreateContexts.CWORLD);
        this.kinetics = new ContraptionInstanceManager(this, this.materialManager);
        this.buildLayers();
        if (Backend.getInstance().canUseInstancing()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void doRenderLayer(RenderType layer, ContraptionProgram shader) {
        ModelRenderer structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.draw();
        }
    }

    public void beginFrame(ActiveRenderInfo info, double camX, double camY, double camZ) {
        this.kinetics.beginFrame(info);
        AbstractContraptionEntity entity = this.contraption.entity;
        float pt = AnimationTickHolder.getPartialTicks();
        MatrixStack stack = new MatrixStack();
        double x = MathHelper.func_219803_d((double)pt, (double)entity.field_70142_S, (double)entity.func_226277_ct_()) - camX;
        double y = MathHelper.func_219803_d((double)pt, (double)entity.field_70137_T, (double)entity.func_226278_cu_()) - camY;
        double z = MathHelper.func_219803_d((double)pt, (double)entity.field_70136_U, (double)entity.func_226281_cx_()) - camZ;
        stack.func_227861_a_(x, y, z);
        entity.doLocalTransforms(pt, new MatrixStack[]{stack});
        this.model = stack.func_227866_c_().func_227870_a_();
        AxisAlignedBB lightBox = GridAlignedBB.toAABB((GridAlignedBB)this.lighter.lightVolume.getTextureVolume());
        this.lightBox = lightBox.func_72317_d(-camX, -camY, -camZ);
    }

    void setup(ContraptionProgram shader) {
        if (this.model == null || this.lightBox == null) {
            return;
        }
        shader.bind(this.model, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    void invalidate() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.lightVolume.delete();
        this.materialManager.delete();
        this.kinetics.invalidate();
    }

    private void buildLayers() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = RenderType.func_228661_n_();
        for (RenderType layer : blockLayers) {
            BufferedModel layerModel = RenderedContraption.buildStructureModel(this.renderWorld, this.contraption, layer);
            if (layerModel == null) continue;
            if (Backend.getInstance().compat.vertexArrayObjectsSupported()) {
                this.renderLayers.put(layer, (ModelRenderer)new ArrayModelRenderer(layerModel));
                continue;
            }
            this.renderLayers.put(layer, new ModelRenderer(layerModel));
        }
    }

    private void buildInstancedTiles() {
        List<TileEntity> tileEntities = this.contraption.maybeInstancedTileEntities;
        if (!tileEntities.isEmpty()) {
            for (TileEntity te : tileEntities) {
                if (!(te instanceof IInstanceRendered)) continue;
                World world = te.func_145831_w();
                BlockPos pos = te.func_174877_v();
                te.func_226984_a_((World)this.renderWorld, pos);
                this.kinetics.add(te);
                te.func_226984_a_(world, pos);
            }
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.kinetics::createActor);
    }

    @Nullable
    private static BufferedModel buildStructureModel(PlacementSimulationWorld renderWorld, Contraption c, RenderType layer) {
        BufferBuilderReader reader = new BufferBuilderReader(ContraptionRenderDispatcher.buildStructure(renderWorld, c, layer));
        int vertexCount = reader.getVertexCount();
        if (vertexCount == 0) {
            return null;
        }
        VertexFormat format = FORMAT;
        ByteBuffer vertices = ByteBuffer.allocate(format.getStride() * vertexCount);
        vertices.order(ByteOrder.nativeOrder());
        for (int i = 0; i < vertexCount; ++i) {
            vertices.putFloat(reader.getX(i));
            vertices.putFloat(reader.getY(i));
            vertices.putFloat(reader.getZ(i));
            vertices.put(reader.getNX(i));
            vertices.put(reader.getNY(i));
            vertices.put(reader.getNZ(i));
            vertices.putFloat(reader.getU(i));
            vertices.putFloat(reader.getV(i));
            vertices.put(reader.getR(i));
            vertices.put(reader.getG(i));
            vertices.put(reader.getB(i));
            vertices.put(reader.getA(i));
            int light = reader.getLight(i);
            byte block = (byte)(LightTexture.func_228450_a_((int)light) << 4);
            byte sky = (byte)(LightTexture.func_228454_b_((int)light) << 4);
            vertices.put(block);
            vertices.put(sky);
        }
        vertices.rewind();
        return IndexedModel.fromSequentialQuads((VertexFormat)format, (ByteBuffer)vertices, (int)vertexCount);
    }
}

