/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.actors.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.Iterate;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerTickList;

public class FluidFillingBehaviour
extends FluidManipulationBehaviour {
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue = new ObjectHeapPriorityQueue((p, p2) -> -this.comparePositions((FluidManipulationBehaviour.BlockPosEntry)p, (FluidManipulationBehaviour.BlockPosEntry)p2));
    List<FluidManipulationBehaviour.BlockPosEntry> infinityCheckFrontier;
    Set<BlockPos> infinityCheckVisited;
    public static BehaviourType<FluidFillingBehaviour> TYPE = new BehaviourType();

    public FluidFillingBehaviour(SmartTileEntity te) {
        super(te);
        this.revalidateIn = 1;
        this.infinityCheckFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.infinityCheckVisited = new HashSet<BlockPos>();
    }

    @Override
    public void tick() {
        Fluid fluid;
        super.tick();
        if (!this.infinityCheckFrontier.isEmpty() && this.rootPos != null && (fluid = this.getWorld().func_204610_c(this.rootPos).func_206886_c()) != Fluids.field_204541_a) {
            this.continueValidation(fluid);
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    protected void continueValidation(Fluid fluid) {
        this.search(fluid, this.infinityCheckFrontier, this.infinityCheckVisited, (p, d) -> this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry((BlockPos)p, (int)d)), true);
        int maxBlocks = this.maxBlocks();
        if (this.infinityCheckVisited.size() > maxBlocks && maxBlocks != -1) {
            if (!this.infinite) {
                this.reset();
                this.infinite = true;
                this.tileEntity.sendData();
            }
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.infinityCheckFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.infinityCheckVisited.clear();
    }

    public boolean tryDeposit(Fluid fluid, BlockPos root, boolean simulate) {
        boolean evaporate;
        if (!Objects.equals(root, this.rootPos)) {
            this.reset();
            this.rootPos = root;
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.affectedArea = new MutableBoundingBox((Vector3i)this.rootPos, (Vector3i)this.rootPos);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = new MutableBoundingBox((Vector3i)root, (Vector3i)root);
        }
        if (this.revalidateIn == 0) {
            this.visited.clear();
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.setValidationTimer();
            this.softReset(root);
        }
        World world = this.getWorld();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = this.maxBlocks();
        boolean bl = evaporate = world.func_230315_m_().func_236040_e_() && fluid.func_207185_a((ITag)FluidTags.field_206959_a);
        if (this.infinite || evaporate) {
            FluidState fluidState = world.func_204610_c(this.rootPos);
            boolean equivalentTo = fluidState.func_206886_c().func_207187_a(fluid);
            if (!equivalentTo && !evaporate) {
                return false;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, null, fluid, false);
            if (evaporate) {
                int i = root.func_177958_n();
                int j = root.func_177956_o();
                int k = root.func_177952_p();
                world.func_184148_a(null, (double)i, (double)j, (double)k, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            }
            return true;
        }
        boolean success = false;
        for (int i = 0; !success && !this.queue.isEmpty() && i < 256; ++i) {
            FluidManipulationBehaviour.BlockPosEntry entry = (FluidManipulationBehaviour.BlockPosEntry)this.queue.first();
            BlockPos currentPos = entry.pos;
            if (this.visited.contains(currentPos)) {
                this.queue.dequeue();
                continue;
            }
            if (!simulate) {
                this.visited.add(currentPos);
            }
            if (this.visited.size() >= maxBlocks && maxBlocks != -1) {
                this.infinite = true;
                this.visited.clear();
                this.queue.clear();
                return false;
            }
            SpaceType spaceType = this.getAtPos(world, currentPos, fluid);
            if (spaceType == SpaceType.BLOCKING) continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                if (!simulate) {
                    ITickList pendingFluidTicks;
                    this.playEffect(world, currentPos, fluid, false);
                    BlockState blockState = world.func_180495_p(currentPos);
                    if (blockState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && fluid.func_207187_a((Fluid)Fluids.field_204546_a)) {
                        if (!this.tileEntity.isVirtual()) {
                            world.func_180501_a(currentPos, this.updatePostWaterlogging((BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true))), 18);
                        }
                    } else {
                        this.replaceBlock(world, currentPos, blockState);
                        if (!this.tileEntity.isVirtual()) {
                            world.func_180501_a(currentPos, FluidHelper.convertToStill(fluid).func_207188_f().func_206883_i(), 18);
                        }
                    }
                    if ((pendingFluidTicks = world.func_205219_F_()) instanceof ServerTickList) {
                        ServerTickList serverTickList = (ServerTickList)pendingFluidTicks;
                        NextTickListEntry removedEntry = null;
                        for (NextTickListEntry nextTickListEntry : serverTickList.field_205374_d) {
                            if (!nextTickListEntry.field_180282_a.equals((Object)currentPos)) continue;
                            removedEntry = nextTickListEntry;
                            break;
                        }
                        if (removedEntry != null) {
                            serverTickList.field_205374_d.remove(removedEntry);
                            serverTickList.field_205375_e.remove(removedEntry);
                        }
                    }
                    this.affectedArea.func_78888_b(new MutableBoundingBox((Vector3i)currentPos, (Vector3i)currentPos));
                }
            }
            if (simulate && success) {
                return true;
            }
            this.visited.add(currentPos);
            this.queue.dequeue();
            for (Direction side : Iterate.directions) {
                SpaceType nextSpaceType;
                BlockPos offsetPos;
                if (side == Direction.UP || this.visited.contains(offsetPos = currentPos.func_177972_a(side)) || offsetPos.func_177951_i((Vector3i)this.rootPos) > (double)maxRangeSq || (nextSpaceType = this.getAtPos(world, offsetPos, fluid)) == SpaceType.BLOCKING) continue;
                this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(offsetPos, entry.distance + 1));
            }
        }
        if (!simulate && success) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.HOSE_PULLEY, (IWorld)world, this.tileEntity.func_174877_v(), 8);
        }
        return success;
    }

    protected void softReset(BlockPos root) {
        this.visited.clear();
        this.queue.clear();
        this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.infinite = false;
        this.setValidationTimer();
        this.tileEntity.sendData();
    }

    protected SpaceType getAtPos(World world, BlockPos pos, Fluid toFill) {
        BlockState blockState = world.func_180495_p(pos);
        FluidState fluidState = blockState.func_204520_s();
        if (blockState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return toFill.func_207187_a((Fluid)Fluids.field_204546_a) ? (((Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() ? SpaceType.FILLED : SpaceType.FILLABLE) : SpaceType.BLOCKING;
        }
        if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
            return (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 ? (toFill.func_207187_a(fluidState.func_206886_c()) ? SpaceType.FILLED : SpaceType.BLOCKING) : SpaceType.FILLABLE;
        }
        if (fluidState.func_206886_c() != Fluids.field_204541_a && blockState.func_215685_b((IBlockReader)this.getWorld(), pos, ISelectionContext.func_216377_a()).func_197766_b()) {
            return toFill.func_207187_a(fluidState.func_206886_c()) ? SpaceType.FILLED : SpaceType.BLOCKING;
        }
        return this.canBeReplacedByFluid((IBlockReader)world, pos, blockState) ? SpaceType.FILLABLE : SpaceType.BLOCKING;
    }

    protected void replaceBlock(World world, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().hasTileEntity(state) ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
    }

    protected boolean canBeReplacedByFluid(IBlockReader world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (!(block instanceof DoorBlock) && !block.func_203417_a((ITag)BlockTags.field_219753_V) && block != Blocks.field_150468_ap && block != Blocks.field_196608_cF && block != Blocks.field_203203_C) {
            Material material = state.func_185904_a();
            if (material != Material.field_151567_E && material != Material.field_189963_J && material != Material.field_203243_f && material != Material.field_204868_h) {
                return !material.func_76230_c();
            }
            return false;
        }
        return false;
    }

    protected BlockState updatePostWaterlogging(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208190_q)) {
            state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Override
    public void reset() {
        super.reset();
        this.queue.clear();
        this.infinityCheckFrontier.clear();
        this.infinityCheckVisited.clear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    static enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING;

    }
}

