/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.itemAssembly;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SequencedAssemblyRecipeBuilder {
    private SequencedAssemblyRecipe recipe;
    protected List<ICondition> recipeConditions = new ArrayList<ICondition>();

    public SequencedAssemblyRecipeBuilder(ResourceLocation id) {
        this.recipe = new SequencedAssemblyRecipe(id, (SequencedAssemblyRecipeSerializer)AllRecipeTypes.SEQUENCED_ASSEMBLY.serializer);
    }

    public <T extends ProcessingRecipe<?>> SequencedAssemblyRecipeBuilder addStep(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, UnaryOperator<ProcessingRecipeBuilder<T>> builder) {
        ProcessingRecipeBuilder<T> recipeBuilder = new ProcessingRecipeBuilder<T>(factory, new ResourceLocation("dummy"));
        Item placeHolder = this.recipe.getTransitionalItem().func_77973_b();
        this.recipe.getSequence().add(new SequencedRecipe(((ProcessingRecipeBuilder)builder.apply(recipeBuilder.require((IItemProvider)placeHolder).output((IItemProvider)placeHolder))).build()));
        return this;
    }

    public SequencedAssemblyRecipeBuilder require(IItemProvider ingredient) {
        return this.require(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}));
    }

    public SequencedAssemblyRecipeBuilder require(ITag.INamedTag<Item> tag) {
        return this.require(Ingredient.func_199805_a(tag));
    }

    public SequencedAssemblyRecipeBuilder require(Ingredient ingredient) {
        this.recipe.ingredient = ingredient;
        return this;
    }

    public SequencedAssemblyRecipeBuilder transitionTo(IItemProvider item) {
        this.recipe.transitionalItem = new ProcessingOutput(new ItemStack(item), 1.0f);
        return this;
    }

    public SequencedAssemblyRecipeBuilder loops(int loops) {
        this.recipe.loops = loops;
        return this;
    }

    public SequencedAssemblyRecipeBuilder addOutput(IItemProvider item, float weight) {
        return this.addOutput(new ItemStack(item), weight);
    }

    public SequencedAssemblyRecipeBuilder addOutput(ItemStack item, float weight) {
        this.recipe.resultPool.add(new ProcessingOutput(item, weight));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new DataGenResult(this.recipe, this.recipeConditions));
    }

    public static class DataGenResult
    implements IFinishedRecipe {
        private List<ICondition> recipeConditions;
        private SequencedAssemblyRecipeSerializer serializer;
        private ResourceLocation id;
        private SequencedAssemblyRecipe recipe;

        public DataGenResult(SequencedAssemblyRecipe recipe, List<ICondition> recipeConditions) {
            this.recipeConditions = recipeConditions;
            this.recipe = recipe;
            this.id = Create.asResource(Lang.asId(AllRecipeTypes.SEQUENCED_ASSEMBLY.name()) + "/" + recipe.func_199560_c().func_110623_a());
            this.serializer = (SequencedAssemblyRecipeSerializer)recipe.func_199559_b();
        }

        public void func_218610_a(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

