/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.itemAssembly;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.content.contraptions.itemAssembly.IAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SequencedRecipe<T extends ProcessingRecipe<?>> {
    private T wrapped;

    public SequencedRecipe(T wrapped) {
        this.wrapped = wrapped;
    }

    public IAssemblyRecipe getAsAssemblyRecipe() {
        return (IAssemblyRecipe)this.wrapped;
    }

    public ProcessingRecipe<?> getRecipe() {
        return this.wrapped;
    }

    public JsonObject toJson() {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).func_199559_b();
        JsonObject json = new JsonObject();
        json.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((IForgeRegistryEntry)serializer).toString());
        serializer.write(json, this.wrapped);
        return json;
    }

    public static SequencedRecipe<?> fromJson(JsonObject json, SequencedAssemblyRecipe parent, int index) {
        ResourceLocation parentId = parent.func_199560_c();
        IRecipe recipe = RecipeManager.func_215377_a((ResourceLocation)new ResourceLocation(parentId.func_110624_b(), parentId.func_110623_a() + "_step_" + index), (JsonObject)json);
        if (recipe instanceof ProcessingRecipe && recipe instanceof IAssemblyRecipe) {
            ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
            IAssemblyRecipe assemblyRecipe = (IAssemblyRecipe)recipe;
            if (assemblyRecipe.supportsAssembly()) {
                Ingredient transit = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{parent.getTransitionalItem()});
                processingRecipe.func_192400_c().set(0, (Object)(index == 0 ? Ingredient.merge((Collection)ImmutableList.of((Object)transit, (Object)parent.getIngredient())) : transit));
                SequencedRecipe<ProcessingRecipe> sequencedRecipe = new SequencedRecipe<ProcessingRecipe>(processingRecipe);
                return sequencedRecipe;
            }
        }
        throw new JsonParseException("Not a supported recipe type");
    }

    public void writeToBuffer(PacketBuffer buffer) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).func_199559_b();
        buffer.func_192572_a(ForgeRegistries.RECIPE_SERIALIZERS.getKey((IForgeRegistryEntry)serializer));
        buffer.func_192572_a(((ProcessingRecipe)this.wrapped).func_199560_c());
        serializer.write(buffer, this.wrapped);
    }

    public static SequencedRecipe<?> readFromBuffer(PacketBuffer buffer) {
        ResourceLocation resourcelocation = buffer.func_192575_l();
        ResourceLocation resourcelocation1 = buffer.func_192575_l();
        IRecipeSerializer serializer = (IRecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(resourcelocation);
        if (!(serializer instanceof ProcessingRecipeSerializer)) {
            throw new JsonParseException("Not a supported recipe type");
        }
        ProcessingRecipe recipe = (ProcessingRecipe)serializer.func_199426_a_(resourcelocation1, buffer);
        return new SequencedRecipe<ProcessingRecipe>(recipe);
    }
}

