/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;

public class AirParticle
extends SimpleAnimatedParticle {
    private float originX;
    private float originY;
    private float originZ;
    private float targetX;
    private float targetY;
    private float targetZ;
    private float drag;
    private float twirlRadius;
    private float twirlAngleOffset;
    private Direction.Axis twirlAxis;

    protected AirParticle(ClientWorld world, AirParticleData data, double x, double y, double z, double dx, double dy, double dz, IAnimatedSprite sprite) {
        super(world, x, y, z, sprite, world.field_73012_v.nextFloat() * 0.5f);
        this.field_70544_f *= 0.75f;
        this.field_190017_n = false;
        this.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        this.field_187123_c = this.field_187126_f;
        this.originX = (float)this.field_187123_c;
        this.field_187124_d = this.field_187127_g;
        this.originY = (float)this.field_187124_d;
        this.field_187125_e = this.field_187128_h;
        this.originZ = (float)this.field_187125_e;
        this.targetX = (float)(x + dx);
        this.targetY = (float)(y + dy);
        this.targetZ = (float)(z + dz);
        this.drag = data.drag;
        this.twirlRadius = Create.RANDOM.nextFloat() / 6.0f;
        this.twirlAngleOffset = Create.RANDOM.nextFloat() * 360.0f;
        this.twirlAxis = Create.RANDOM.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
        double length = new Vector3d(dx, dy, dz).func_72433_c();
        this.field_70547_e = Math.min((int)(length / (double)data.speed), 60);
        this.selectSprite(7);
        this.func_82338_g(0.25f);
        if (length == 0.0) {
            this.func_187112_i();
            this.func_82338_g(0.0f);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        float progress = (float)Math.pow((float)this.field_70546_d / (float)this.field_70547_e, this.drag);
        float angle = (progress * 2.0f * 360.0f + this.twirlAngleOffset) % 360.0f;
        Vector3d twirl = VecHelper.rotate(new Vector3d(0.0, (double)this.twirlRadius, 0.0), angle, this.twirlAxis);
        float x = (float)((double)MathHelper.func_219799_g((float)progress, (float)this.originX, (float)this.targetX) + twirl.field_72450_a);
        float y = (float)((double)MathHelper.func_219799_g((float)progress, (float)this.originY, (float)this.targetY) + twirl.field_72448_b);
        float z = (float)((double)MathHelper.func_219799_g((float)progress, (float)this.originZ, (float)this.targetZ) + twirl.field_72449_c);
        this.field_187129_i = (double)x - this.field_187126_f;
        this.field_187130_j = (double)y - this.field_187127_g;
        this.field_187131_k = (double)z - this.field_187128_h;
        this.func_217566_b(this.field_217584_C);
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public int func_189214_a(float partialTick) {
        BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this.field_187122_b.func_195588_v(blockpos) ? WorldRenderer.func_228421_a_((IBlockDisplayReader)this.field_187122_b, (BlockPos)blockpos) : 0;
    }

    private void selectSprite(int index) {
        this.func_217567_a(this.field_217584_C.func_217591_a(index, 8));
    }

    public static class Factory
    implements IParticleFactory<AirParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle makeParticle(AirParticleData data, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new AirParticle(worldIn, data, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

